/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.OptionChecker;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DebugOptionChecker
extends OptionChecker {
    private static final String COMMA = ",";
    private static final String OUTPUT_EQUALS = "output=";
    private static final String EQUAL_SIGN = "=";
    private static final String XTRACE = "-Xtrace";
    private static final String NODYNAMIC = "-Xtrace:buffers=nodynamic";
    private static final String[] options = new String[]{"-Xcheck", "-Xdbg", "-Xdebug", "-Xrdbginfo", "-Xjarversion", "-Xrunjdwp", "-XselectiveDebug", "-agentlib:jdwp", "-Xtrace"};
    private static final Set<String> debugOptions = new HashSet<String>();

    public DebugOptionChecker() {
        if (debugOptions.size() == 0) {
            for (String string : options) {
                debugOptions.add(string);
            }
        }
    }

    @Override
    public Status checkOptions(Collection<String> collection, StructuredStringDataBuilder structuredStringDataBuilder) {
        Status status = Status.HEALTHY;
        for (String string : collection) {
            Object object;
            String[] stringArray;
            if (!string.startsWith("-X") || !debugOptions.contains((stringArray = string.split("[:=0-9]"))[0])) continue;
            if (!string.startsWith(XTRACE)) {
                object = MessageFormat.format(Messages.getString("DebugOptionChecker.debug.option"), string);
                structuredStringDataBuilder.addWarning((String)object);
                status = Status.WARNING;
                continue;
            }
            if (string.matches(NODYNAMIC)) continue;
            for (String string2 : object = string.split(COMMA)) {
                if (string2.indexOf(EQUAL_SIGN) < 0 || string2.indexOf(OUTPUT_EQUALS) != -1) continue;
                String string3 = MessageFormat.format(Messages.getString("DebugOptionChecker.debug.option"), string);
                structuredStringDataBuilder.addWarning(string3);
                status = Status.WARNING;
            }
        }
        return status;
    }
}

