/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.DgTracePoints;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.J9MMJava5TraceParser;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.J9MMTraceParser;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.MMTracePoints;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.ThreadState;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.TrcAuxTracePoints;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class J9MMTraceHandler
implements TracePointHandler,
DgTracePoints,
MMTracePoints,
TrcAuxTracePoints {
    private J9MMTraceParser parser;
    private DataBuilder data;
    private OutputProperties props;
    private TraceMetaData meta;
    private boolean isVMRealtime = false;
    private boolean is26vm = false;
    private static final String CLASSNAME = J9MMTraceHandler.class.getName();
    public static final Logger TRACE = LogFactory.getTrace(J9MMTraceHandler.class);
    private final Map<TracedThread, ThreadState> threadStateMap = new HashMap<TracedThread, ThreadState>();

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        this.handleTracePoint(tracePoint);
    }

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "handleTraceStart");
        this.data = dataBuilder;
        this.props = outputProperties;
        this.meta = traceMetaData;
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }

    private void initialiseParser(TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (this.parser == null || dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION) == null) {
            this.parser = J9MMJava5TraceParser.canParseThisVersion(traceMetaData.getVMVersion()) ? new J9MMJava5TraceParser(dataBuilder, outputProperties, traceMetaData) : new J9MMTraceParser(dataBuilder, outputProperties, traceMetaData);
        }
        if (this.meta.getVMVersion() != null) {
            VMLevelChecker vMLevelChecker = new VMLevelChecker(this.meta.getVMVersion());
            JVMDataImpl jVMDataImpl = (JVMDataImpl)dataBuilder.findRootData();
            if (vMLevelChecker.isVMRealtime() || jVMDataImpl != null && jVMDataImpl.isRealtimeVM()) {
                this.isVMRealtime = true;
            }
        }
    }

    public void handleTracePoint(TracePoint tracePoint) {
        if (tracePoint == null) {
            return;
        }
        String string = tracePoint.getComponent();
        if (string == null) {
            return;
        }
        if (string.equals("j9mm")) {
            this.handleJ9MMTracePoint(tracePoint);
        } else if (string.equals("omrmm")) {
            this.handleOMRMMTracePoint(tracePoint);
        } else if (string.equals("dg")) {
            this.handleDgTracePoint(tracePoint);
        }
    }

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (tracedThread != null) {
            ThreadState threadState = this.getThreadState(tracedThread);
            if (threadState != null) {
                threadState.reset();
            }
        } else {
            for (ThreadState threadState : this.threadStateMap.values()) {
                if (threadState == null) continue;
                this.parseGCTrace(threadState);
                threadState.reset();
                threadState.inCollection = false;
            }
        }
    }

    private void handleDgTracePoint(TracePoint tracePoint) {
        int n = tracePoint.getID();
        if (n == 262) {
            TracedThread tracedThread = tracePoint.getThread();
            this.removeThreadState(tracedThread);
        }
    }

    private void handleJ9MMTracePoint(TracePoint tracePoint) {
        this.initialiseParser(this.meta, this.data, this.props);
        int n = tracePoint.getID();
        TracedThread tracedThread = tracePoint.getThread();
        ThreadState threadState = this.getThreadState(tracedThread);
        switch (n) {
            case 50: 
            case 131: {
                if (this.isVMRealtime) break;
            }
            case 52: 
            case 64: 
            case 74: 
            case 132: 
            case 345: 
            case 347: 
            case 383: 
            case 474: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 475: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 474);
                break;
            }
            case 133: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 134: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 133);
                break;
            }
            case 469: {
                this.is26vm = true;
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 470: {
                this.is26vm = true;
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 469);
                break;
            }
            case 53: 
            case 91: 
            case 384: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 52);
                break;
            }
            case 65: 
            case 560: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 64);
                break;
            }
            case 51: {
                if (this.isVMRealtime) break;
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 131, 50);
                break;
            }
            case 75: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 74, 132);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                threadState.addTracePoint(tracePoint);
                if (threadState.inCollection) break;
                this.parseGCTrace(threadState);
                break;
            }
            case 279: 
            case 285: {
                threadState.addTracePoint(tracePoint);
                if (threadState.inCollection) break;
                this.parseGCTrace(threadState);
                break;
            }
            case 280: 
            case 286: {
                threadState.addTracePoint(tracePoint);
                if (threadState.inCollection) break;
                this.parseGCTrace(threadState);
                break;
            }
            case 281: {
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 282: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 281);
                break;
            }
            case 231: {
                this.parser.handleSetAllocationThreshold(threadState, tracePoint);
                break;
            }
            case 234: {
                this.parser.handleAllocationThreshold(threadState, tracePoint, this.meta);
                break;
            }
            case 395: {
                this.parser.handleOutOfLineAllocation(threadState, tracePoint, this.meta);
                break;
            }
            case 346: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 345);
                break;
            }
            case 348: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 347);
                break;
            }
            case 463: 
            case 464: {
                threadState.addTracePoint(tracePoint);
                if (!threadState.inCollection) {
                    this.parseGCTrace(threadState);
                }
            }
            default: {
                threadState.addTracePoint(tracePoint);
            }
        }
    }

    private void handleOMRMMTracePoint(TracePoint tracePoint) {
        this.initialiseParser(this.meta, this.data, this.props);
        int n = tracePoint.getID();
        TracedThread tracedThread = tracePoint.getThread();
        ThreadState threadState = this.getThreadState(tracedThread);
        switch (n) {
            case 14: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 15: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 14);
                break;
            }
            case 10: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 11: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 10);
                break;
            }
            case 12: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 13: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 12);
                break;
            }
            case 0: {
                this.handleCollectionStart(threadState);
                threadState.addTracePoint(tracePoint);
                break;
            }
            case 1: {
                threadState.addTracePoint(tracePoint);
                this.handleCollectionEnd(threadState, 0);
                break;
            }
            default: {
                threadState.addTracePoint(tracePoint);
            }
        }
    }

    private void handleCollectionStart(ThreadState threadState) {
        TracePoint tracePoint = threadState.getFirstTracePoint();
        if (tracePoint == null || !threadState.inCollection) {
            threadState.reset();
        }
        threadState.inCollection = true;
    }

    private void handleCollectionEnd(ThreadState threadState, int ... nArray) {
        if (threadState.inCollection) {
            TracePoint tracePoint = threadState.getFirstTracePoint();
            if (tracePoint != null) {
                int n = tracePoint.getID();
                for (int n2 : nArray) {
                    if (n != n2) continue;
                    this.parseGCTrace(threadState);
                    threadState.inCollection = false;
                    break;
                }
            }
        } else {
            threadState.reset();
        }
    }

    private void parseGCTrace(ThreadState threadState) {
        for (TracePoint tracePoint : threadState.getTracePoints()) {
            if (tracePoint.getComponent().startsWith("omr")) {
                this.parseOMRMMTracePoint(threadState, tracePoint);
                continue;
            }
            this.parseJ9MMTracePoint(threadState, tracePoint);
        }
        threadState.reset();
    }

    private void parseJ9MMTracePoint(ThreadState threadState, TracePoint tracePoint) {
        int n = tracePoint.getID();
        switch (n) {
            case 52: {
                this.parser.startGlobalCollection(threadState, tracePoint, 3, 4, 5, this.meta);
                break;
            }
            case 383: {
                this.parser.startGlobalCollection(threadState, tracePoint, -1, 0, 1, this.meta);
                break;
            }
            case 474: {
                this.parser.startGlobalCollection(threadState, tracePoint, -1, 0, -1, this.meta);
                break;
            }
            case 90: {
                this.parser.completeGlobalCollection(threadState, tracePoint);
                break;
            }
            case 91: {
                this.parser.endGlobalCollection(threadState, tracePoint, 6, 7, 8, 9, 10, 11, 12, this.meta);
                break;
            }
            case 384: {
                this.parser.endGlobalCollection(threadState, tracePoint, -1, 2, 3, 4, 5, 6, 7, this.meta);
                break;
            }
            case 475: {
                this.parser.endNewFormatGlobalCollection(threadState, tracePoint, 2, 3, this.meta);
                break;
            }
            case 53: {
                this.parser.endGlobalCollection(threadState, tracePoint, 5, 6, 7, 8, 9, 10, 11, this.meta);
                break;
            }
            case 50: 
            case 131: {
                if (this.isVMRealtime) break;
                this.parser.startSystemGC(threadState, tracePoint, this.meta);
                break;
            }
            case 51: {
                if (this.isVMRealtime) break;
                this.parser.endSystemGC(threadState, tracePoint, this.meta);
                break;
            }
            case 64: {
                this.parser.startLocalCollection(threadState, tracePoint, this.meta);
                break;
            }
            case 65: 
            case 560: {
                this.parser.endLocalCollection(threadState, tracePoint, this.meta);
                break;
            }
            case 279: 
            case 285: {
                this.parser.startSynchGC(threadState, tracePoint, this.meta);
                break;
            }
            case 280: 
            case 286: {
                this.parser.endSynchGC(threadState, tracePoint);
                break;
            }
            case 74: {
                this.parser.startConcurrentCollection(threadState, tracePoint, this.meta);
                break;
            }
            case 75: {
                this.parser.endConcurrentCollection(threadState, tracePoint, this.meta);
                break;
            }
            case 54: {
                this.parser.startMark(threadState, tracePoint);
                break;
            }
            case 55: {
                this.parser.endMark(threadState, tracePoint, this.meta);
                break;
            }
            case 56: {
                this.parser.startSweep(threadState, tracePoint);
                break;
            }
            case 57: {
                this.parser.endSweep(threadState, tracePoint, this.meta);
                break;
            }
            case 58: {
                this.parser.startCompact(threadState, tracePoint);
                break;
            }
            case 59: {
                this.parser.endCompact(threadState, tracePoint, this.meta);
                break;
            }
            case 69: {
                this.parser.handleConcurrentKickoff(threadState, tracePoint, this.meta);
                break;
            }
            case 133: {
                if (this.is26vm) break;
                this.parser.handleAfStart(threadState, tracePoint, this.meta);
                break;
            }
            case 134: {
                if (this.is26vm) break;
                this.parser.handleAfEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 469: {
                this.parser.handleAfStart(threadState, tracePoint, this.meta);
                break;
            }
            case 470: {
                this.parser.handleAfEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 138: {
                this.parser.handleReferenceCountAtStart(threadState, tracePoint, this.meta);
                break;
            }
            case 139: {
                this.parser.handleReferenceCountAtEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 135: {
                this.parser.handleExclusiveAccess(threadState, tracePoint, this.meta);
                break;
            }
            case 60: {
                this.parser.handleClassUnloadingStart(threadState, tracePoint);
                break;
            }
            case 94: {
                this.parser.handleClassUnloadingEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 132: {
                this.parser.handleConcurrentStart(threadState, tracePoint, this.meta);
                break;
            }
            case 136: {
                this.parser.handleCompactStart(threadState, tracePoint);
                break;
            }
            case 137: {
                this.parser.handleCompactEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                break;
            }
            case 73: {
                break;
            }
            case 85: {
                break;
            }
            case 86: {
                break;
            }
            case 467: {
                break;
            }
            case 468: {
                break;
            }
            case 345: {
                this.parser.handlePGCStart(threadState, tracePoint, this.meta);
                break;
            }
            case 346: {
                this.parser.handlePGCEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 463: {
                this.parser.handleGMPCycleStart(threadState, tracePoint);
                break;
            }
            case 464: {
                this.parser.handleGMPCycleEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 347: {
                this.parser.handleGMPIncrementStart(threadState, tracePoint, this.meta);
                break;
            }
            case 348: {
                this.parser.handleGMPIncrementEnd(threadState, tracePoint, this.meta);
                break;
            }
        }
    }

    private void parseOMRMMTracePoint(ThreadState threadState, TracePoint tracePoint) {
        int n = tracePoint.getID();
        switch (n) {
            case 14: {
                this.parser.startGlobalCollection(threadState, tracePoint, -1, 0, 1, this.meta);
                break;
            }
            case 16: {
                this.parser.completeGlobalCollection(threadState, tracePoint);
                break;
            }
            case 15: {
                this.parser.endNewFormatGlobalCollection(threadState, tracePoint, 2, 3, this.meta);
                break;
            }
            case 0: {
                this.parser.startSystemGC(threadState, tracePoint, this.meta);
                break;
            }
            case 1: {
                this.parser.endSystemGC(threadState, tracePoint, this.meta);
                break;
            }
            case 4: {
                this.parser.startMark(threadState, tracePoint);
                break;
            }
            case 5: {
                this.parser.endMark(threadState, tracePoint, this.meta);
                break;
            }
            case 6: {
                this.parser.startSweep(threadState, tracePoint);
                break;
            }
            case 7: {
                this.parser.endSweep(threadState, tracePoint, this.meta);
                break;
            }
            case 10: {
                this.parser.handleAfStart(threadState, tracePoint, this.meta);
                break;
            }
            case 11: {
                this.parser.handleAfEnd(threadState, tracePoint, this.meta);
                break;
            }
            case 12: {
                this.parser.handleAfStart(threadState, tracePoint, this.meta);
                break;
            }
            case 13: {
                this.parser.handleAfEnd(threadState, tracePoint, this.meta);
                break;
            }
        }
    }

    private ThreadState getThreadState(TracedThread tracedThread) {
        ThreadState threadState = this.threadStateMap.get(tracedThread);
        if (threadState == null) {
            threadState = new ThreadState();
            this.threadStateMap.put(tracedThread, threadState);
        }
        return threadState;
    }

    private void removeThreadState(TracedThread tracedThread) {
        this.threadStateMap.remove(tracedThread);
    }
}

