/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.datatruncation;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.healthcenter.marshaller.HealthCenterJob;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;

public class DataSeedingJob
implements HealthCenterJob {
    private static final String SEEDING_OF_DATA_JOB = Messages.getString("DataSeedingJob.job.name");
    private DataBuilder data;
    private String name;
    private OutputProperties properties;
    private int MAX_VALUE = Integer.MAX_VALUE;

    public DataSeedingJob(DataBuilder dataBuilder, OutputProperties outputProperties) {
        this.name = SEEDING_OF_DATA_JOB;
        this.data = dataBuilder;
        this.properties = outputProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean xValuesRequireReseed() {
        double d = AxisUtil.prepareXAxis(this.properties).getSeed();
        DataPointBuilder dataPointBuilder = this.data.getLargestOverallXAxisValue();
        if (dataPointBuilder != null) {
            double d2 = dataPointBuilder.getRawX();
            return d2 - d > (double)this.MAX_VALUE * 0.66;
        }
        return false;
    }

    @Override
    public long run() {
        if (this.xValuesRequireReseed()) {
            long l = AxisUtil.prepareXAxis(this.properties).getSeed();
            long l2 = (long)((double)l + (double)this.MAX_VALUE * 0.33);
            this.data.removeOldDataBeforeTime(l2, UnitLabels.MILLISECONDS_SINCE_EPOCH);
            AxisUtil.prepareXAxis(this.properties).setSeed(l2);
            this.data.updateXValues(l2 - l);
        }
        return 0L;
    }
}

