/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.DataManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.MQTTSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnection;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Random;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;

public class MQTTConnectionDataImpl
extends ConnectionDataImpl
implements MqttCallback {
    private MqttClient mqttClient;
    private final MQTTAgentConnection agentConnection;
    private final ConnectionProperties properties;
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private static final int QUALITY_OF_SERVICE = 2;
    private String clientId;
    private String agentTopic;
    private static final String DATASOURCE_TOPIC = "/datasource";
    private static final String CONFIGURATION_TOPIC = "configuration/";
    private static final String HISTORY_TOPIC = "/history/";
    private static final String AGENT_TOPIC = "agent/";
    private static final String WILL_TOPIC = "will";
    private static final String HEARTBEAT_TOPIC = "heartbeat";
    private DataManager dataManager;
    private ArrayList<String> sourceTopics;
    private boolean subscribe = false;
    private long lastMessageTime = 0L;

    public MQTTConnectionDataImpl(MQTTAgentConnection mQTTAgentConnection, ConnectionProperties connectionProperties) {
        super(mQTTAgentConnection.getDescription());
        this.agentConnection = mQTTAgentConnection;
        this.properties = connectionProperties;
        this.agentTopic = this.agentConnection.getAgentTopic() + this.agentConnection.getAgentID();
        this.dataManager = new DataManager();
        this.sourceTopics = new ArrayList();
    }

    private MQTTAgentConnection getAgentConnection() {
        return this.agentConnection;
    }

    @Override
    public boolean spawnSources(Marshaller marshaller) {
        String string;
        String string2;
        boolean bl = false;
        String string3 = Integer.toString(this.properties.getPort());
        Random random = new Random();
        this.clientId = "HC_" + random.nextInt(99999999);
        String string4 = this.getAgentConnection().isSSLProbablyUsed() ? "ssl://" : "tcp://";
        String string5 = string4 + this.properties.getHostName() + ":" + string3;
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        if (this.properties.getUserName() != null) {
            mqttConnectOptions.setUserName(this.properties.getUserName());
        }
        if (this.properties.getPassword() != null) {
            mqttConnectOptions.setPassword(this.properties.getPassword().toCharArray());
        }
        try {
            this.mqttClient = new MqttClient(string5, this.clientId, null);
            this.mqttClient.setCallback(this);
            this.mqttClient.connect(mqttConnectOptions);
            this.isConnectionAlive = true;
            string2 = this.agentTopic + SLASH + this.clientId + SLASH + "#";
            this.mqttClient.subscribe(string2, 2);
            string = this.agentTopic + SLASH + WILL_TOPIC;
            this.mqttClient.subscribe(string, 2);
            String string6 = this.agentTopic + SLASH + HEARTBEAT_TOPIC;
            this.mqttClient.subscribe(string6, 2);
            this.sendMessage("datasources", this.clientId, new String[0]);
            this.sendMessage("history", this.clientId, new String[0]);
            SourceSubscribeThread sourceSubscribeThread = new SourceSubscribeThread();
            sourceSubscribeThread.start();
            this.sendMessage("methoddictionary", "", new String[0]);
            bl = true;
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            this.handleMQTTException(mqttPersistenceException);
        }
        catch (MqttSecurityException mqttSecurityException) {
            this.handleMQTTException(mqttSecurityException);
        }
        catch (MqttException mqttException) {
            this.handleMQTTException(mqttException);
        }
        string2 = Messages.getString("AgentConnection.connected.to");
        string = MessageFormat.format(string2, this.getDetails());
        StatusManager.setSources(string);
        return bl;
    }

    @Override
    public void destroyConnection() {
        try {
            this.mqttClient.unsubscribe("#");
            this.mqttClient.disconnect();
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
        this.dataManager.clearData();
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.MQTT;
    }

    @Override
    public void connectionLost(Throwable throwable) {
        String string = Messages.getString("MQTTConnectionDataImpl.broker.connection.lost");
        this.errorOccurred(string, string, throwable);
    }

    public void handleMQTTException(MqttException mqttException) {
        String string = MessageFormat.format(Messages.getString("MQTTConnectionDataImpl.mqtt.exception"), mqttException.toString());
        this.errorOccurred(string, string, mqttException);
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void sendMessage(String string, String string2, String ... stringArray) {
        if (!this.mqttClient.isConnected()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        for (String string3 : stringArray) {
            stringBuffer.append(COMMA).append(string3);
        }
        stringBuffer.trimToSize();
        try {
            String mqttException = this.agentConnection.getAgentTopic() + AGENT_TOPIC + this.agentConnection.getAgentID() + SLASH + string;
            this.mqttClient.publish(mqttException, new MqttMessage(stringBuffer.toString().getBytes()));
        }
        catch (MqttException mqttException) {
            this.handleMQTTException(mqttException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        int n = string.indexOf(this.agentTopic);
        if (n >= 0) {
            Object object;
            this.lastMessageTime = System.currentTimeMillis();
            this.disableNotifications();
            this.setStatus(Status.HEALTHY);
            this.clearValue();
            this.isConnectionAlive = true;
            this.enableNotifications();
            String string2 = string.substring(this.agentTopic.length() + 1);
            if (string2.equals(WILL_TOPIC)) {
                object = Messages.getString("MQTTConnectionDataImpl.agent.ended");
                this.errorOccurred((String)object, (String)object, null);
            }
            if (string2.equals(HEARTBEAT_TOPIC)) {
                return;
            }
            if (string2.startsWith(this.clientId)) {
                if ((string2 = string2.substring(this.clientId.length())).equals(DATASOURCE_TOPIC)) {
                    object = new String(mqttMessage.getPayload());
                    String[] stringArray = ((String)object).split(COMMA);
                    String string3 = new String(stringArray[0]);
                    String string4 = ((String)object).substring(string3.length() + 1, ((String)object).length());
                    MQTTSourceImpl mQTTSourceImpl = new MQTTSourceImpl(string3, this);
                    Source source = mQTTSourceImpl.spawnConfigurationSource(this, string4);
                    ArrayList<String> arrayList = this.sourceTopics;
                    synchronized (arrayList) {
                        this.sourceTopics.add(string3);
                        this.sourceTopics.add(CONFIGURATION_TOPIC + string3);
                    }
                    MarshallerImpl.getMarshaller().addSource(mQTTSourceImpl);
                    MarshallerImpl.getMarshaller().addSource(source);
                } else if (string2.startsWith(HISTORY_TOPIC)) {
                    string2 = string2.substring(HISTORY_TOPIC.length());
                    object = mqttMessage.getPayload();
                    if (object == null || ((Object)object).length == 0) {
                        this.subscribe = true;
                    } else {
                        this.addData(string2, mqttMessage.getPayload());
                    }
                }
            } else {
                if (string2.startsWith(CONFIGURATION_TOPIC)) {
                    object = string2.substring(CONFIGURATION_TOPIC.length());
                    if (((String)object).equalsIgnoreCase("classhistogram")) {
                        object = "ClassHistogramSource";
                    } else if (((String)object).equalsIgnoreCase("cpu")) {
                        object = "CpuSource";
                    } else if (((String)object).equalsIgnoreCase("environment")) {
                        object = "EnvironmentSource";
                    } else if (((String)object).equalsIgnoreCase("locking")) {
                        object = "JLASource";
                    } else if (((String)object).equalsIgnoreCase("memory")) {
                        object = "MemorySource";
                    } else if (((String)object).equalsIgnoreCase("memorycounters")) {
                        object = "MemoryCountersSource";
                    } else if (((String)object).equalsIgnoreCase("methoddictionary")) {
                        object = "MethodDictionarySource";
                    } else if (((String)object).equalsIgnoreCase("threads")) {
                        object = "ThreadsSource";
                    } else if (((String)object).equalsIgnoreCase("trace")) {
                        object = "TRACESubscriberSource";
                    }
                    string2 = (String)object + "Configuration";
                }
                this.addData(string2, mqttMessage.getPayload());
            }
        }
    }

    public void addData(String string, byte[] byArray) {
        this.dataReceived(byArray.length);
        this.dataManager.addData(string, byArray);
    }

    public byte[] getTopicData(String string) {
        return this.dataManager.getData(string);
    }

    @Override
    public void outputMessage(String string, String string2, String ... stringArray) {
        this.sendMessage(string, string2, stringArray);
    }

    private class SourceSubscribeThread
    extends Thread {
        private static final long HEARTBEAT_TIMEOUT = 30000L;

        private SourceSubscribeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 10;
            while (!MQTTConnectionDataImpl.this.subscribe && n-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ArrayList arrayList = MQTTConnectionDataImpl.this.sourceTopics;
            synchronized (arrayList) {
                try {
                    for (String string : MQTTConnectionDataImpl.this.sourceTopics) {
                        String string2 = MQTTConnectionDataImpl.this.agentTopic + MQTTConnectionDataImpl.SLASH + string;
                        MQTTConnectionDataImpl.this.mqttClient.subscribe(string2, 2);
                    }
                }
                catch (MqttException mqttException) {
                    MQTTConnectionDataImpl.this.handleMQTTException(mqttException);
                }
            }
            while (MQTTConnectionDataImpl.this.mqttClient.isConnected()) {
                String string;
                long l = System.currentTimeMillis();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MQTTConnectionDataImpl.this.lastMessageTime > l) continue;
                string = Messages.getString("MQTTConnectionDataImpl.connection.lost");
                MQTTConnectionDataImpl.this.errorOccurred(string, string, null);
            }
        }
    }
}

