/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.io.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.io.IOLabels;
import com.ibm.java.diagnostics.healthcenter.io.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class IOAnalyserPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(IOAnalyserPostProcessor.class);
    private static final String CLASS_NAME = IOAnalyserPostProcessor.class.getName();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.IO);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(IOLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(IOLabels.RECOMMENDATION_LABEL);
            Data data = subsystemDataBuilder.getData(IOLabels.FILE_OPEN);
            Data data2 = subsystemDataBuilder.getData(IOLabels.FILE_CLOSE);
            double d = 0.0;
            double d2 = 0.0;
            if (data != null) {
                d = ((TwoDimensionalData)data).getTotalY();
            }
            if (data2 != null) {
                d2 = ((TwoDimensionalData)data2).getTotalY();
            }
            String string = MessageFormat.format(Messages.getString("IOAnalyserPostProcessor.openedAndClosedFiles"), d, d2);
            structuredStringDataImpl.addInformation(string);
            structuredStringDataImpl.addGoodThing(Messages.getString("IO.no.problem.detected"));
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }
}

