/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.profiling.parser.nodejs;

import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.impl.data.MethodNode;
import java.io.File;

public class JSMethod
implements Method {
    private static final String[] SYNTHETIC_METHODS = new String[]{"(root)", "(garbage collector)", "(program)"};
    private final long numericId;
    private final String fullName;
    private final String mediumName;
    private final String shortName;
    private String stringId = null;

    public JSMethod(long l, String string, String string2, int n) {
        this.numericId = l;
        this.shortName = JSMethod.isSynthetic(string2) ? string2 : (JSMethod.isAnonymous(string2) ? string2 : string2 + "()");
        String string3 = !JSMethod.isBlank(string) ? new File(string).getName() : "";
        this.mediumName = this.shortName + (!JSMethod.isBlank(string) ? " (" + string3 + ":" + n + ")" : "");
        this.fullName = this.shortName + (!JSMethod.isBlank(string) ? " (" + string + ":" + n + ")" : "");
    }

    @Override
    public String getUniqueId() {
        if (this.stringId == null) {
            this.stringId = Long.toHexString(this.numericId);
        }
        return this.stringId;
    }

    @Override
    public long getUniqueIdAsNumber() {
        return this.numericId;
    }

    @Override
    public boolean isNameKnown() {
        return true;
    }

    @Override
    public String getName() {
        return this.fullName;
    }

    @Override
    public String getName(int n) {
        if (this.fullName.length() <= n) {
            return this.fullName;
        }
        if (this.mediumName.length() <= n) {
            return this.mediumName;
        }
        return this.shortName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getMethodName() {
        return this.fullName;
    }

    @Override
    public String getName(boolean bl, boolean bl2, boolean bl3) {
        return bl || bl2 ? this.mediumName : this.shortName;
    }

    private static boolean isBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    private static boolean isAnonymous(String string) {
        return "(anonymous function)".equals(string);
    }

    private static boolean isSynthetic(String string) {
        for (String string2 : SYNTHETIC_METHODS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JSMethod) {
            JSMethod jSMethod = (JSMethod)object;
            return this.numericId == jSMethod.numericId;
        }
        if (object instanceof MethodNode) {
            Method method = ((MethodNode)object).getMethod();
            return this.equals(method);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.numericId;
    }
}

