/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.stacks;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.healthcenter.stacks.StackData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTableData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTableRow;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTraceDataPoint;

public class StackDataPostProcessor
implements PostProcessor {
    private static final String EMPTY_STRING = "";

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        StackData stackData = StackData.getStackData(dataBuilder);
        if (stackData != null) {
            this.processStackData(dataBuilder, stackData);
        }
    }

    private void processStackData(DataBuilder dataBuilder, StackData stackData) {
        DataBuilder[] dataBuilderArray;
        for (DataBuilder dataBuilder2 : dataBuilderArray = stackData.getChildren()) {
            if (!(dataBuilder2 instanceof TwoDimensionalDataBuilder)) continue;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder2;
            StackTableData stackTableData = stackData.createStackTable(dataBuilder2.getLabel());
            twoDimensionalDataBuilder.addData(stackTableData);
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = dataPointBuilderArray.length;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                TwoDimensionalDataBuilder twoDimensionalDataBuilder2;
                StackTraceDataPoint stackTraceDataPoint;
                String string;
                if (!(dataPointBuilder instanceof StackTraceDataPoint) || (string = (stackTraceDataPoint = (StackTraceDataPoint)dataPointBuilder).getStackTop()).equals(EMPTY_STRING) || stackTableData.contains(string) || (twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)twoDimensionalDataBuilder.getTopLevelData(string)) == null) continue;
                double d = twoDimensionalDataBuilder2.getTotalY();
                double d2 = d / (double)n * 100.0;
                stackTableData.addRow(new StackTableRow(stackTraceDataPoint, string, (int)d, d2));
            }
        }
    }
}

