/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    private static final String[] z;

    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected abstract int engineGetBlockSize();

    protected abstract int engineGetOutputSize(int var1);

    protected abstract byte[] engineGetIV();

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return this.a(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException(z[1]);
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException(z[1]);
        }
    }

    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.a(byteBuffer, byteBuffer2, false);
    }

    static int a(int n) {
        return Math.min(4096, n);
    }

    private int a(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException(z[5]);
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (bl && n2 == 0) {
            return 0;
        }
        int n5 = this.engineGetOutputSize(n2);
        if (byteBuffer2.remaining() < n5) {
            throw new ShortBufferException(z[3] + n5 + z[2]);
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        if (bl2 && bl3) {
            byte[] byArray2 = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + n3;
            byte[] byArray3 = byteBuffer2.array();
            int n7 = byteBuffer2.position();
            int n8 = byteBuffer2.arrayOffset() + n7;
            int n9 = bl ? this.engineUpdate(byArray2, n6, n2, byArray3, n8) : this.engineDoFinal(byArray2, n6, n2, byArray3, n8);
            byteBuffer.position(n4);
            byteBuffer2.position(n7 + n9);
            return n9;
        }
        if (!bl2 && bl3) {
            int n10;
            int n11 = byteBuffer2.position();
            byte[] byArray4 = byteBuffer2.array();
            int n12 = byteBuffer2.arrayOffset() + n11;
            byte[] byArray5 = new byte[CipherSpi.a(n2)];
            int n13 = 0;
            for (n2 = n4 - n3; n2 > 0; n2 -= n10) {
                int n14;
                n10 = Math.min(n2, byArray5.length);
                byteBuffer.get(byArray5, 0, n10);
                if (bl || n2 != n10) {
                    try {
                        n14 = this.engineUpdate(byArray5, 0, n10, byArray4, n12);
                    }
                    catch (ProviderException providerException) {
                        byteBuffer.position(n3);
                        n10 = n2;
                        byArray5 = new byte[n10];
                        byteBuffer.get(byArray5, 0, n10);
                        n14 = this.engineDoFinal(byArray5, 0, n10, byArray4, n12);
                    }
                } else {
                    n14 = this.engineDoFinal(byArray5, 0, n10, byArray4, n12);
                }
                n13 += n14;
                n12 += n14;
            }
            byteBuffer2.position(n11 + n13);
            return n13;
        }
        if (bl2) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + n3;
        } else {
            byArray = new byte[CipherSpi.a(n2)];
            n = 0;
        }
        byte[] byArray6 = new byte[CipherSpi.a(n5)];
        int n15 = byArray6.length;
        int n16 = 0;
        boolean bl4 = false;
        while (n2 > 0) {
            int n17 = Math.min(n2, n15);
            if (!bl2 && !bl4) {
                byteBuffer.get(byArray, 0, n17);
                n = 0;
            }
            try {
                int n18;
                if (bl || n2 != n17) {
                    try {
                        n18 = this.engineUpdate(byArray, n, n17, byArray6, 0);
                    }
                    catch (ProviderException providerException) {
                        byteBuffer.position(n3);
                        n17 = n2;
                        if (!bl2) {
                            byArray = new byte[n17];
                            byteBuffer.get(byArray, 0, n17);
                        }
                        byArray6 = new byte[n5];
                        n15 = byArray6.length;
                        n18 = this.engineDoFinal(byArray, n, n17, byArray6, 0);
                    }
                } else {
                    n18 = this.engineDoFinal(byArray, n, n17, byArray6, 0);
                }
                bl4 = false;
                n += n17;
                n2 -= n17;
                byteBuffer2.put(byArray6, 0, n18);
                n16 += n18;
            }
            catch (ShortBufferException shortBufferException) {
                if (bl4) {
                    throw (ProviderException)new ProviderException(z[4]).initCause(shortBufferException);
                }
                bl4 = true;
                int n19 = this.engineGetOutputSize(n17);
                byArray6 = new byte[n19];
            }
        }
        byteBuffer.position(n4);
        return n16;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException(z[0]);
    }

    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException(z[0]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "Yd[(\u001ach[z\u0003tePoONeN`\n\u007f,We\u001faiSm\u0001ymJa\u0000c,Zg\n~,Pg\u001b-\u007fKx\u001fb~J(\u001beeM(\u0002hxVg\u000b";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 13;
                                break;
                            }
                            case 1: {
                                n8 = 12;
                                break;
                            }
                            case 2: {
                                n8 = 62;
                                break;
                            }
                            case 3: {
                                n8 = 8;
                                break;
                            }
                            default: {
                                n8 = 111;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "DbJm\u001dcmR(\n\u007f~QzOdb\u001e}\u001fimJmG$";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "-nG|\n~,QnO~|_k\n-eP(\u0000xxN}\u001b-nKn\th~";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "Ci[lOlx\u001ed\nl\u007fJ(";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "NcKd\u000b-bQ|OiiJm\u001d`ePmOoyXn\n\u007f,Ma\u0015h";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "DbN}\u001b-mPlObyJx\u001ay,\\}\tkiL{O`yM|OccJ(\rh,P}\u0003a";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

