/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ActiveSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long active_offset;
    private long active_end;
    private TraceFile traceFile;

    public ActiveSection(TraceFile traceFile, int start) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(start);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.active_offset = traceFile.getFilePointer();
        this.active_end = start + this.length;
        Util.Debug.println("ActiveSection: eyecatcher:         " + this.eyecatcher_string);
        Util.Debug.println("ActiveSection: length:             " + this.length);
        Util.Debug.println("ActiveSection: version:            " + this.version);
        Util.Debug.println("ActiveSection: modification:       " + this.modification);
    }

    protected void summary(BufferedWriter out) throws IOException {
        this.traceFile.seek(this.active_offset);
        byte[] activeBuffer = new byte[(int)(this.active_end - this.active_offset)];
        Util.Debug.println("ActiveSection: active_offset:        " + this.active_offset);
        Util.Debug.println("ActiveSection: active_end:           " + this.active_end);
        out.write("Activation Info :");
        out.newLine();
        int i = 0;
        this.traceFile.read(activeBuffer);
        for (i = 0; i < activeBuffer.length; ++i) {
            StringBuffer buf = new StringBuffer();
            while (activeBuffer[i] != 0) {
                buf.append((char)activeBuffer[i]);
                ++i;
            }
            if (buf.length() == 0) break;
            out.write("        ");
            out.write(buf.toString());
            out.newLine();
        }
        out.newLine();
    }
}

