/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.Debug;
import com.ibm.lex.lapapp.ImagePanel;
import com.ibm.lex.lapapp.JReadmeDialog;
import com.ibm.lex.lapapp.LAP;
import com.ibm.lex.lapapp.LAPConstants;
import com.ibm.lex.lapapp.License;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import com.ibm.lex.lapapp.TextPrinter;
import com.ibm.lex.lapapp.resource.LAPResources;
import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class JLAP
extends JFrame {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2003, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private JDialog dialog;
    private JPanel topPanel;
    private JTextArea heading;
    private LAP lap;
    private LicenseAcceptanceProcess licenseAcceptanceProcess;
    private int winX = 0;
    private int winY = 0;
    private int winWidth;
    private int winHeight;
    private int xCenter;
    private int yCenter;
    private int dialogWidth = 550;
    private int dialogHeight = 450;
    private int dialogX;
    private int dialogY;
    private Color winColor = Color.blue;
    private Font lapFont;
    private int fontStyle = 0;
    private int fontSize;
    private boolean controlFontSize;
    private Color dialogColor = Color.lightGray;
    private LAPResources lapResources;
    private LicenseAcceptanceProcess model;
    private Image logoImage;
    protected String logoFileName = "logo.gif";
    private JPanel controlPanel;
    private JButton acceptButton;
    private JButton declineButton;
    private boolean noControll;
    private JButton printButton;
    private boolean printable = true;
    private JButton languageButton;
    private JButton viewNonIBMButton;
    protected String languageButName = "language";
    protected String acceptButName = "accept";
    protected String declineButName = "decline";
    protected String printButName = "print";
    protected String yesButName = "yes";
    protected String noButName = "no";
    private JTextArea laView;
    private String[] textLines;
    private JPanel laPanel;
    private JDialog declineDlg;
    private JReadmeDialog readmeDlg;

    public JLAP() {
    }

    public JLAP(LAP lAP) {
        try {
            this.lap = lAP;
            if (this.lap.getnoPrint()) {
                this.printable = false;
            }
            this.showMe();
        }
        catch (Exception exception) {
            Debug.printException(exception);
        }
    }

    private void applicationStatusChanged(int n) {
        switch (n) {
            case 91: {
                String string = this.getLAPTitle();
                this.setTitle(string);
                if (this.dialog.isVisible()) {
                    this.dialog.repaint();
                } else {
                    this.setVisible(true);
                    this.dialog.setVisible(true);
                }
                this.dialog.repaint();
                break;
            }
            case 9: {
                this.exitLAP(9);
                break;
            }
            case 3: {
                this.exitLAP(3);
                break;
            }
            default: {
                this.exitLAP(n);
            }
        }
    }

    public String[] breakText(int n, int n2, String[] stringArray, Locale locale) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray[i];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (string == null) {
                string = " ";
            }
            breakIterator.setText(string);
            int n4 = breakIterator.first();
            int n5 = breakIterator.next();
            int n6 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n7 = 0;
            while (n5 != -1) {
                String string2 = string.substring(n4, n5);
                n7 = string2.length() * n2;
                if (n6 + n7 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string2);
                    n6 = n7;
                } else {
                    stringBuffer.append(string2);
                    n6 += n7;
                }
                n4 = n5;
                n5 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void showMe() {
        this.parseParameters();
        this.setLocale(this.lap.getLicenseAcceptanceProcess().getCurrentLocale());
        String string = System.getProperty("os.name");
        String string2 = this.getLocale().toString();
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        if ((string.equalsIgnoreCase("aix") || string.equalsIgnoreCase("linux")) && string2.equalsIgnoreCase("ja")) {
            this.controlFontSize = false;
        }
        this.setTitle(this.getLAPTitle());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        if ((string.equalsIgnoreCase("aix") || string.equalsIgnoreCase("linux")) && string2.equalsIgnoreCase("ja")) {
            this.controlFontSize = false;
        }
        try {
            this.setIconImage(this.getImage("icon.gif"));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Null pointer in getting icon image");
        }
        this.controlFontSize = true;
        if (this.controlFontSize) {
            try {
                this.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(nullPointerException.toString());
            }
        }
        this.getContentPane().setBackground(this.winColor);
        this.setLocation(this.winX, this.winY);
        this.setSize(this.winWidth, this.winHeight);
        if (this.winWidth > 0 && this.winHeight > 0) {
            this.setVisible(true);
        }
        this.dialog = new JDialog((Frame)this, true);
        this.dialog.getContentPane().setBackground(this.dialogColor);
        this.dialog.setLocation(this.dialogX - 10, this.dialogY - 10);
        this.dialog.setSize(this.dialogWidth, this.dialogHeight);
        this.dialog.setTitle(this.getLAPTitle());
        this.dialog.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.dialog.setDefaultCloseOperation(0);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        ImagePanel imagePanel = null;
        JPanel jPanel = new JPanel();
        this.logoImage = this.lap.getLicenseAcceptanceProcess().getLAPResources().getImage(this.logoFileName);
        if (this.logoImage != null) {
            imagePanel = new ImagePanel(this.logoImage);
            imagePanel.setBackground(this.dialogColor);
        }
        this.topPanel.setBackground(this.dialogColor);
        if (imagePanel != null) {
            this.topPanel.add((Component)imagePanel, "East");
        }
        this.heading = new JTextArea();
        this.heading.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("heading"));
        this.heading.setLineWrap(true);
        this.heading.setWrapStyleWord(true);
        this.heading.setBackground(this.dialogColor);
        this.heading.setEditable(false);
        this.heading.setMargin(new Insets(0, 20, 25, 10));
        this.heading.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.heading.addKeyListener(new LabelTabHandler());
        this.topPanel.add((Component)this.heading, "Center");
        this.laPanel = new JPanel();
        this.laPanel.setBackground(this.dialogColor);
        this.laView = new JTextArea("");
        this.laView.setBackground(this.dialogColor);
        this.laView.setEditable(false);
        this.laView.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.laView.addKeyListener(new TextTabHandler());
        this.laView.setLineWrap(true);
        this.laView.setWrapStyleWord(true);
        this.laView.setText(this.getLicenseAgreement());
        this.laView.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this.laView);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(this.dialogWidth * 9 / 10, this.dialogHeight / 2));
        jScrollPane.setBorder(jScrollPane.getBorder());
        this.laPanel.add(jScrollPane);
        if (this.lap.getLicenseAcceptanceProcess().hasNonIBMFile()) {
            this.viewNonIBMButton = new JButton();
            this.viewNonIBMButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("non_ibm_key"));
            this.viewNonIBMButton.setBackground(this.dialogColor);
            this.viewNonIBMButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            this.viewNonIBMButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLAP.this.doDisplyNonIBMDialog();
                }
            });
            this.laPanel.add(this.viewNonIBMButton);
        }
        this.controlPanel = new JPanel();
        if (!this.noControll) {
            if (this.printable) {
                this.printButton = new JButton();
                this.printButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("print"));
                this.printButton.setBackground(this.dialogColor);
                this.printButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
                this.printButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JLAP.this.onPrint();
                    }
                });
                this.controlPanel.add(this.printButton);
            }
            this.acceptButton = new JButton();
            this.acceptButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("accept"));
            this.acceptButton.setBackground(this.dialogColor);
            this.acceptButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            this.acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLAP.this.onAccept();
                }
            });
            this.declineButton = new JButton();
            this.declineButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("decline"));
            this.declineButton.setBackground(this.dialogColor);
            this.declineButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            this.declineButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLAP.this.onDecline();
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(this.dialogColor);
            jPanel2.add(this.acceptButton);
            jPanel2.add(this.declineButton);
            if (this.lap.getLicenseAcceptanceProcess().isMultiLanguage()) {
                this.languageButton = new JButton();
                this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
                this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
                this.languageButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("language"));
                this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
                this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
                this.languageButton.setBackground(this.dialogColor);
                this.languageButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
                this.languageButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JLAP.this.onLanguage();
                    }
                });
                this.controlPanel.add(this.languageButton);
            }
            this.controlPanel.add(jPanel2);
        }
        this.controlPanel.setBackground(this.dialogColor);
        this.dialog.getContentPane().add((Component)this.laPanel, "Center");
        this.dialog.getContentPane().add((Component)this.topPanel, "North");
        this.dialog.getContentPane().add((Component)this.controlPanel, "South");
        this.dialog.setLocation(this.dialogX, this.dialogY);
        this.dialog.setVisible(true);
    }

    private int getFontSize() {
        if (this.fontSize <= 0) {
            this.fontSize = this.lap.getLicenseAcceptanceProcess().getLAPResources().getFontSize();
        }
        return this.fontSize;
    }

    public Image getImage(String string) {
        return this.getLAPResources().getImage(string);
    }

    private String getLanguageLabel() {
        return "View in " + this.lap.getLicenseAcceptanceProcess().getNextLocale().getDisplayLanguage(LAPConstants.DEFAULT_LOCALE);
    }

    private LAPResources getLAPResources() {
        return this.lap.getLicenseAcceptanceProcess().getLAPResources();
    }

    public String getLAPTitle() {
        return this.getLAPResources().getText("title");
    }

    private License getLicense() {
        return this.lap.getLicenseAcceptanceProcess().getLicense();
    }

    private String getLicenseAgreement() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("");
        this.textLines = this.lap.getLicenseAcceptanceProcess().getLicenseAgreement(this.getLocale());
        for (int i = 0; i < this.textLines.length; ++i) {
            stringBuffer.append(this.textLines[i]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String[] getLicenseAgreement(Locale locale) {
        return this.lap.getLicenseAcceptanceProcess().getLicenseAgreement(locale);
    }

    public int getStatus() {
        return this.lap.getLicenseAcceptanceProcess().getStatus();
    }

    private SupportedLanguages getSupportedLanguages() {
        return this.lap.getLicenseAcceptanceProcess().getSupportedLanguages();
    }

    public boolean licenseIsValid() {
        return this.getLicense().licenseExists(this.getSupportedLanguages().getSupportedLocales());
    }

    public static void main(String[] stringArray) {
        LAP lAP = new LAP(stringArray);
    }

    public void onAccept() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.declineDlg == null || !this.declineDlg.isVisible()) {
            this.lap.getLicenseAcceptanceProcess().setStatus(9);
            this.exitLAP(9);
        }
        if (this.declineDlg != null && this.declineDlg.isVisible()) {
            this.declineDlg.toFront();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onDecline_old() {
        Object object = null;
        object = UIManager.get("Panel.background");
        UIManager.put("Panel.background", this.dialogColor);
        String[] stringArray = this.lap.getLicenseAcceptanceProcess().getLAPResources().getMessage("declinedMessage");
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            string = string + "\n\n";
        }
        Object[] objectArray = new JButton[]{new JButton(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("yes")), new JButton(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("no"))};
        objectArray[0].setBackground(this.dialogColor);
        objectArray[1].setBackground(this.dialogColor);
        objectArray[0].setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        objectArray[1].setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        objectArray[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLAP.this.declineDlg.dispose();
                JLAP.this.declineDlg = null;
                JLAP.this.lap.getLicenseAcceptanceProcess().setStatus(3);
                JLAP.this.exitLAP(3);
            }
        });
        objectArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLAP.this.declineDlg.dispose();
                JLAP.this.declineDlg = null;
            }
        });
        JTextArea jTextArea = new JTextArea(string, 20, 40);
        jTextArea.setBackground(this.dialogColor);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        JOptionPane jOptionPane = new JOptionPane(jTextArea, -1, 0, null, objectArray);
        jOptionPane.setBackground(this.dialogColor);
        jOptionPane.setPreferredSize(new Dimension(this.dialogWidth * 4 / 5, this.dialogHeight * 3 / 4));
        jOptionPane.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.declineDlg = jOptionPane.createDialog(this, this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("title"));
        this.declineDlg.setBackground(this.dialogColor);
        this.declineDlg.getContentPane().setBackground(this.dialogColor);
        this.declineDlg.getContentPane().setLayout(new FlowLayout());
        this.declineDlg.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.declineDlg.setModal(true);
        this.declineDlg.show();
    }

    private void onDecline() {
        LAPResources lAPResources = this.lap.getLicenseAcceptanceProcess().getLAPResources();
        Object[] objectArray = new Object[]{lAPResources.getText("yes"), lAPResources.getText("no")};
        String string = this.breakDialogText(lAPResources.getText("declinedMsgA")) + "\n\n" + this.breakDialogText(lAPResources.getText("declinedMsgB"));
        int n = JOptionPane.showOptionDialog(this, string, lAPResources.getText("title"), 0, -1, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.lap.getLicenseAcceptanceProcess().setStatus(3);
            this.exitLAP(3);
        }
    }

    private String breakDialogText(String string) {
        return this.breakDialogText(this.lap.getLicenseAcceptanceProcess().getCurrentLocale(), string, 80);
    }

    private String breakDialogText(Locale locale, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        StringBuffer stringBuffer2 = new StringBuffer("");
        while (n3 != -1) {
            String string2 = string.substring(n2, n3);
            if (string2.endsWith("\n")) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer();
            } else if (this.getDisplayWidth(locale, stringBuffer2.toString() + string2) > n) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("\n");
                stringBuffer2 = new StringBuffer(string2);
            } else {
                stringBuffer2.append(string2);
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    private int getDisplayWidth(Locale locale, String string) {
        String string2 = locale.toString();
        if (string2.equalsIgnoreCase("ko") || string2.equalsIgnoreCase("ja") || string2.equalsIgnoreCase("zh") || string2.equalsIgnoreCase("zh_tw")) {
            int n = 0;
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                n += string.charAt(i) <= '\u007f' ? 1 : 2;
            }
            return n;
        }
        return string.length();
    }

    private void onLanguage() {
        this.laView.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize()));
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize()));
        this.laView.setText(this.getLicenseAgreement());
        this.laView.setCaretPosition(0);
        this.heading.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("heading"));
        this.acceptButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("accept"));
        this.declineButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("decline"));
        this.printButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("print"));
        if (this.lap.getLicenseAcceptanceProcess().hasNonIBMFile()) {
            this.viewNonIBMButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("non_ibm_key"));
        }
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.languageButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText("language"));
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.applicationStatusChanged(91);
        this.laView.setCaretPosition(0);
        this.laView.setCursor(Cursor.getPredefinedCursor(0));
        this.laPanel.revalidate();
        this.topPanel.revalidate();
        this.controlPanel.revalidate();
        if (this.viewNonIBMButton != null) {
            this.viewNonIBMButton.revalidate();
        }
        this.dialog.setTitle(this.getTitle());
        this.setTitle(this.getTitle());
        this.repaint();
    }

    private void onPrint() {
        TextPrinter textPrinter = new TextPrinter(this.lap.getLicenseAcceptanceProcess().getLicenseAgreementPrint(), this.dialog, this.lap.getLicenseAcceptanceProcess(), this.lap.getLicenseAcceptanceProcess().getLAPResources(), this.controlFontSize, this.acceptButton, this.getFont(), this.getBackground(), this.getToolkit().getScreenSize(), this.getBounds());
        textPrinter.setMargin(1.0, 1.0, 1.0, 1.0);
        textPrinter.print();
    }

    private void parseParameters() {
        int n;
        int n2;
        int n3;
        Object object;
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.winWidth = dimension.width;
        this.winHeight = dimension.height;
        this.xCenter = this.winWidth / 2;
        this.yCenter = this.winHeight / 2;
        if (this.lap.getwinStyle().equals("0")) {
            this.winX = this.winWidth / 2;
            this.winY = this.winHeight / 2;
            this.winWidth = 0;
            this.winHeight = 0;
        } else if (this.lap.getwinStyle().equals("2")) {
            object = this.getInsets();
            this.winX = -((Insets)object).left;
            this.winY = -((Insets)object).top;
            this.winWidth = this.winWidth + ((Insets)object).left + ((Insets)object).right;
            this.winHeight = this.winHeight + ((Insets)object).top + ((Insets)object).bottom;
        }
        if (this.lap.getdialogSizeString() != null) {
            object = new StringTokenizer(this.lap.getdialogSizeString(), ";");
            try {
                n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n3 > 0 && n3 <= dimension.width && n2 > 0 && n2 <= dimension.height) {
                    this.dialogWidth = n3;
                    this.dialogHeight = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dialogX = (dimension.width - this.dialogWidth) / 2;
        this.dialogY = (dimension.height - this.dialogHeight) / 2;
        if (this.lap.getwinColorString() != null) {
            object = new StringTokenizer(this.lap.getwinColorString(), ";");
            try {
                n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n = Integer.parseInt(((StringTokenizer)object).nextToken());
                this.winColor = new Color(n3, n2, n);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        if (this.lap.getdialogBackcolorString() != null) {
            object = new StringTokenizer(this.lap.getdialogBackcolorString(), ";");
            try {
                int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n = Integer.parseInt(((StringTokenizer)object).nextToken());
                this.dialogColor = new Color(n4, n2, n);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        if (this.lap.getfontStyleString() != null) {
            this.fontStyle = this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("plain") ? 0 : (this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("italic") ? 2 : (this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("bold") ? 1 : 0));
        }
        if (this.lap.getfontSizeString() != null) {
            try {
                int n5 = Integer.parseInt(this.lap.getfontSizeString());
                if (n5 > 0) {
                    this.fontSize = n5;
                    this.lapFont = new Font(this.lap.getfontName(), this.fontStyle, this.fontSize);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    public void setStatus(int n) {
        this.lap.getLicenseAcceptanceProcess().setStatus(n);
    }

    private void exitLAP(int n) {
        if (this.lap.getbShowExitCode()) {
            System.out.println("Exited with: " + n);
        } else if (n != 3 && n != 9) {
            System.out.println("Exited with: " + n);
        }
        System.exit(n);
    }

    private void doDisplyNonIBMDialog() {
        this.readmeDlg = new JReadmeDialog(this, this.getLAPTitle(), true);
        try {
            this.readmeDlg.setReadmeText(this.lap.getLicenseAcceptanceProcess().getNonIBMText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        rectangle = new Rectangle((dimension.width - 360) / 2, (dimension.height - 250) / 2, 720, 500);
        this.readmeDlg.setBounds(rectangle);
        this.readmeDlg.setVisible(true);
    }

    public class TextTabHandler
    extends KeyAdapter {
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2003, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                if ((keyEvent.getModifiers() & 1) != 0) {
                    JLAP.this.heading.requestFocus();
                } else if (JLAP.this.printable) {
                    JLAP.this.printButton.requestFocus();
                } else {
                    JLAP.this.acceptButton.requestFocus();
                }
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }

    public class LabelTabHandler
    extends KeyAdapter {
        private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2003, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                if ((keyEvent.getModifiers() & 1) != 0) {
                    JLAP.this.declineButton.requestFocus();
                } else {
                    JLAP.this.laView.requestFocus();
                }
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }
}

