/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp.resource;

import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class LAPResources {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String laPath;
    private URL laURL;
    private Locale locale;
    private ResourceBundle resBundle;
    public static final String LANGUAGE_KEY = "language";
    public static final String TITLE_KEY = "title";
    public static final String HEADING_KEY = "heading";
    public static final String FOOTING_KEY = "footing";
    public static final String ACCEPT_KEY = "accept";
    public static final String DECLINE_KEY = "decline";
    public static final String PRINT_KEY = "print";
    public static final String YES_KEY = "yes";
    public static final String NO_KEY = "no";
    public static final String ACCEPTED_URL_KEY = "url.accepted";
    public static final String DECLINED_URL_KEY = "url.declined";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String CONFIRM_MESSAGE_KEY = "declinedMessage";
    public static final String CONFIRM_MSG_A_KEY = "declinedMsgA";
    public static final String CONFIRM_MSG_B_KEY = "declinedMsgB";
    public static final String CLILANGMSG_KEY = "clilangmsg";
    public static final String CLILANG2MSG_KEY = "clilang2msg";
    public static final String CLIMSG1_KEY = "climsg1";
    public static final String CLIMSG2_KEY = "climsg2";
    public static final String CLICONTMSG_KEY = "clicontmsg";
    public static final String CLICONTMSG_NONIBM_KEY = "clicontmsgnonibm";
    public static final String CLICONTMSG_NOPRINT_KEY = "clicontmsgnoprint";
    public static final String CLICONTMSG_NOPRINT_NONIBM_KEY = "clicontmsgnoprintnonibm";
    public static final String CLICONTMSG_ENGONLY_KEY = "clicontmsgengonly";
    public static final String CLICONTMSG_ENGONLY_NONIBM_KEY = "clicontmsgengonlynonibm";
    public static final String CLICONTMSG_ENGONLY_NOPRINT_KEY = "clicontmsgengonlynoprint";
    public static final String CLICONTMSG_ENGONLY_NOPRINT_NONIBM_KEY = "clicontmsgengonlynoprintnonibm";
    public static final String CLICFMMSG_KEY = "clicfmmsg";
    public static final String CLIACCMSG_KEY = "cliaccmsg";
    public static final String ASSUMED_FONT_WIDTH_KEY = "assumedFontWidth";
    public static final String ASSUMED_FONT_HEIGHT_KEY = "assumedFontHeight";
    public static final String CLICONTMSG_LANGREPLACE = "REPLACEWITHLANG";
    public static final String PRINT_ERROR_MSG_KEY = "printError";
    public static final String PRINT_ERROR_MSG_KEY_A = "printErrorA";
    public static final String PRINT_ERROR_MSG_KEY_B = "printErrorB";
    public static final String PRINTING_ERROR_TITLE = "printing_error_title";
    public static final String PRINTING_ERROR_NO_PRINTERS = "printing_error_no_printers";
    public static final String NON_IBM_KEY = "non_ibm_key";

    public LAPResources(String string) {
        this.laPath = string;
        this.init();
    }

    public LAPResources(URL uRL) {
        this.laURL = uRL;
        this.init();
    }

    public int getFontSize() {
        return Integer.parseInt(this.getText(FONT_SIZE_KEY));
    }

    public Image getImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            if (this.laPath != null) {
                String string2 = this.laPath + File.separator + string;
                File file = new File(string2);
                if (file.exists()) {
                    image = new ImageIcon(string2).getImage();
                }
            } else {
                URL uRL = new URL(this.laURL, string);
                image = new ImageIcon(uRL).getImage();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public Image getImage(String string, ImageObserver imageObserver) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            if (this.laPath != null) {
                String string2 = this.laPath + File.separator + string;
                image = toolkit.getImage(string2);
                toolkit.prepareImage(image, -1, -1, imageObserver);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getText(String string) {
        if (this.resBundle == null) {
            this.resBundle = ResourceBundle.getBundle("com.ibm.lex.lapapp.resource.Resource", this.locale);
        }
        return this.resBundle.getString(string);
    }

    public String[] getMessage(String string) {
        if (string.equals(CONFIRM_MESSAGE_KEY)) {
            String[] stringArray = new String[]{this.getText(CONFIRM_MSG_A_KEY), "", this.getText(CONFIRM_MSG_B_KEY)};
            return stringArray;
        }
        if (string.equals(PRINT_ERROR_MSG_KEY)) {
            String[] stringArray = new String[]{this.getText(PRINT_ERROR_MSG_KEY_A), "", this.getText(PRINT_ERROR_MSG_KEY_B)};
            return stringArray;
        }
        return null;
    }

    private void init() {
        this.locale = SupportedLanguages.DEFAULT_LANGUAGE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.resBundle = null;
    }
}

