/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int a = 1024;
    private int b;
    private SecureRandom c;
    private static final String[] z;

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 < 256 || n2 > 2048 || n2 % 64 != 0) {
            throw new InvalidParameterException(z[8]);
        }
        this.a = n2;
        this.c = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[7]);
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.a = dHGenParameterSpec.getPrimeSize();
        if (this.a < 256 || this.a > 2048 || this.a % 64 != 0) {
            throw new InvalidAlgorithmParameterException(z[6]);
        }
        this.b = dHGenParameterSpec.getExponentSize();
        if (this.b <= 0) {
            throw new InvalidAlgorithmParameterException(z[5]);
        }
        if (this.b >= this.a) {
            throw new InvalidAlgorithmParameterException(z[4]);
        }
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.b == 0) {
            this.b = this.a - 1;
        }
        if (this.c == null) {
            try {
                this.c = SecureRandom.getInstance(z[3]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(z[1], z[0]);
            algorithmParameterGenerator.init(this.a, this.c);
            algorithmParameters = algorithmParameterGenerator.generateParameters();
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dHParameterSpec = this.b > 0 ? new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG(), this.b) : new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG());
            algorithmParameters = AlgorithmParameters.getInstance(z[2], z[0]);
            algorithmParameters.init(dHParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        return algorithmParameters;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "68/\\Q:";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                block19: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block19;
                    n5 = n5;
                    if (n5 <= n4) break block20;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 127;
                            break;
                        }
                        case 1: {
                            n6 = 122;
                            break;
                        }
                        case 2: {
                            n6 = 98;
                            break;
                        }
                        case 3: {
                            n6 = 22;
                            break;
                        }
                        default: {
                            n6 = 18;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ";)#";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ";2";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "68/Ew\u001c\u000f\u0010s@\u001e\u0014\u0006y\u007f";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ":\u0002\u0012y|\u001a\u0014\u00166a\u0016\u0000\u00076\u007f\n\t\u00166p\u001aZ\u000esa\fZ\u0016~s\u0011Z\u000fyv\n\u0016\u0017e2\f\u0013\u0018s";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ":\u0002\u0012y|\u001a\u0014\u00166a\u0016\u0000\u00076\u007f\n\t\u00166p\u001aZ\u0005dw\u001e\u000e\u0007d2\u000b\u0012\u0003x2\u0005\u001f\u0010y";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "2\u0015\u0006c~\n\tBe{\u0005\u001fB{g\f\u000eBtw_\u0017\u0017zf\u0016\n\u000es2\u0010\u001cB &SZ\u0003xv_\u0019\u0003x2\u0010\u0014\u000eo2\r\u001b\fqw_\u001c\u0010y\u007f_HW 2\u000b\u0015B$\"KBB>{\u0011\u0019\u000eca\u0016\f\u0007?";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "6\u0014\u0003fb\r\u0015\u0012d{\u001e\u000e\u00076b\u001e\b\u0003{w\u000b\u001f\u00106f\u0006\n\u0007";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "4\u001f\u001be{\u0005\u001fB{g\f\u000eBtw_\u0017\u0017zf\u0016\n\u000es2\u0010\u001cB &SZ\u0003xv_\u0019\u0003x2\u0010\u0014\u000eo2\r\u001b\fqw_\u001c\u0010y\u007f_HW 2\u000b\u0015B$\"KBB>{\u0011\u0019\u000eca\u0016\f\u0007?";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

