/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit;

import com.ibm.jit.DecimalFormatHelper;
import java.lang.reflect.Field;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITHelpers {
    private static final JITHelpers helpers;
    private static final Unsafe unsafe;
    private static final DecimalFormatHelper dummyDecFormat;
    private static final int CLASS_IS_INTERFACE_OR_PRIMITIVE;
    private static final int CLASS_DEPTH_MASK;
    private static final int JLCLASS_J9CLASS_OFFSET;
    private static final int J9CLASS_J9ROMCLASS_OFFSET;
    private static final int J9ROMCLASS_MODIFIERS_OFFSET;
    private static final int J9CLASS_SUPERCLASSES_OFFSET;
    private static final int J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET;
    private static final int POINTER_SIZE;
    private static final boolean IS_32_BIT;

    private JITHelpers() {
    }

    @CallerSensitive
    public static JITHelpers getHelpers() {
        if (Reflection.getCallerClass().getClassLoader() != null) {
            throw new SecurityException("JITHelpers");
        }
        return helpers;
    }

    private static JITHelpers jitHelpers() {
        return helpers;
    }

    private static native int javaLangClassJ9ClassOffset();

    private static native int j9ClassROMClassOffset();

    private static native int romClassModifiersOffset();

    private static native int classIsInterfaceFlag();

    private static native int classIsPrimitiveFlag();

    private static native int j9ClassSuperclassesOffset();

    private static native int j9ClassClassDepthAndFlagsOffset();

    private static native int classDepthMask();

    public Class getSuperclass(Class clazz) {
        if (IS_32_BIT) {
            int j9Class = unsafe.getInt(clazz, JLCLASS_J9CLASS_OFFSET);
            int romClass = unsafe.getInt(j9Class + J9CLASS_J9ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                int superclasses = unsafe.getInt(j9Class + J9CLASS_SUPERCLASSES_OFFSET);
                int depthAndFlags = unsafe.getInt(j9Class + J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                int depth = depthAndFlags & CLASS_DEPTH_MASK;
                if (depth > 0) {
                    int superclass = unsafe.getInt(superclasses + POINTER_SIZE * (depth - 1));
                    return helpers.getClassFromJ9Class32(superclass);
                }
            }
        } else {
            long j9Class = unsafe.getLong(clazz, JLCLASS_J9CLASS_OFFSET);
            long romClass = unsafe.getLong(j9Class + (long)J9CLASS_J9ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + (long)J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                long superclasses = unsafe.getLong(j9Class + (long)J9CLASS_SUPERCLASSES_OFFSET);
                long depthAndFlags = unsafe.getLong(j9Class + (long)J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                long depth = depthAndFlags & (long)CLASS_DEPTH_MASK;
                if (depth > 0L) {
                    long superclass = unsafe.getLong(superclasses + (long)POINTER_SIZE * (depth - 1L));
                    return helpers.getClassFromJ9Class64(superclass);
                }
            }
        }
        return null;
    }

    public native boolean is32Bit();

    public native int getNumBitsInReferenceField();

    public native int getNumBytesInReferenceField();

    public native int getNumBitsInDescriptionWord();

    public native int getNumBytesInDescriptionWord();

    public native int getNumBytesInJ9ObjectHeader();

    public native int getJ9ClassFromClass32(Class var1);

    public native Class getClassFromJ9Class32(int var1);

    public native int getTotalInstanceSizeFromJ9Class32(int var1);

    public native int getInstanceDescriptionFromJ9Class32(int var1);

    public native int getDescriptionWordFromPtr32(int var1);

    public native long getJ9ClassFromClass64(Class var1);

    public native Class getClassFromJ9Class64(long var1);

    public native long getTotalInstanceSizeFromJ9Class64(long var1);

    public native long getInstanceDescriptionFromJ9Class64(long var1);

    public native long getDescriptionWordFromPtr64(long var1);

    public native int getNumSlotsInObject(Class var1);

    public native int getSlotIndex(Field var1);

    public native boolean isDescriptorPointerTagged(int var1, long var2);

    public native int getRomClassFromJ9Class32(int var1);

    public native int getSuperClassesFromJ9Class32(int var1);

    public native int getClassDepthAndFlagsFromJ9Class32(int var1);

    public native int getBackfillOffsetFromJ9Class32(int var1);

    public native int getArrayShapeFromRomClass32(int var1);

    public native int getModifiersFromRomClass32(int var1);

    public native long getRomClassFromJ9Class64(long var1);

    public native long getSuperClassesFromJ9Class64(long var1);

    public native long getClassDepthAndFlagsFromJ9Class64(long var1);

    public native long getBackfillOffsetFromJ9Class64(long var1);

    public native int getArrayShapeFromRomClass64(long var1);

    public native int getModifiersFromRomClass64(long var1);

    public native int getClassFlagsFromJ9Class32(int var1);

    public native int getClassFlagsFromJ9Class64(long var1);

    static {
        dummyDecFormat = new DecimalFormatHelper();
        helpers = new JITHelpers();
        unsafe = Unsafe.getUnsafe();
        CLASS_IS_INTERFACE_OR_PRIMITIVE = JITHelpers.classIsInterfaceFlag() | JITHelpers.classIsPrimitiveFlag();
        CLASS_DEPTH_MASK = JITHelpers.classDepthMask();
        JLCLASS_J9CLASS_OFFSET = JITHelpers.javaLangClassJ9ClassOffset();
        J9CLASS_J9ROMCLASS_OFFSET = JITHelpers.j9ClassROMClassOffset();
        J9ROMCLASS_MODIFIERS_OFFSET = JITHelpers.romClassModifiersOffset();
        J9CLASS_SUPERCLASSES_OFFSET = JITHelpers.j9ClassSuperclassesOffset();
        J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET = JITHelpers.j9ClassClassDepthAndFlagsOffset();
        POINTER_SIZE = unsafe.addressSize();
        IS_32_BIT = POINTER_SIZE == 4;
    }
}

