/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import java.security.AccessControlException;

public abstract class SharedAbstractHelperFactory {
    private static int idCount = 1;
    static Object monitor = new Monitor();

    boolean checkPermission(ClassLoader loader, String type) {
        boolean result = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SharedClassPermission(loader, type));
            }
            catch (AccessControlException e) {
                result = false;
            }
        }
        return result;
    }

    boolean canFind(ClassLoader loader) {
        return this.checkPermission(loader, "read");
    }

    boolean canStore(ClassLoader loader) {
        return this.checkPermission(loader, "write");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNewID() {
        Object object = monitor;
        synchronized (object) {
            return idCount++;
        }
    }

    private static class Monitor {
        private Monitor() {
        }
    }
}

