/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.IPC;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;

class FilelockTimer
extends Timer {
    volatile Field timerThreadField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                String timerThreadFieldName = "thread";
                Field impl = Timer.class.getDeclaredField(timerThreadFieldName);
                impl.setAccessible(true);
                return impl;
            }
            catch (Exception e) {
                IPC.logMessage("FilelockTimer: get field exception " + e.getClass().getName() + ":" + e.getMessage());
                return null;
            }
        }
    });

    FilelockTimer(String name) {
        super(name, true);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (null != this.timerThreadField) {
            try {
                Thread timerThread = (Thread)this.timerThreadField.get(this);
                if (null != timerThread) {
                    timerThread.join(10000L);
                }
            }
            catch (Exception e) {
                IPC.logMessage("Exception in FilelockTimer.cancel: ", e.getClass().getName() + ":" + e.getMessage());
            }
        }
    }
}

