/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.misc.Launcher;
import sun.reflect.CallerSensitive;

public abstract class ClassLoader {
    private static CodeSource defaultCodeSource = new CodeSource(null, (Certificate[])null);
    static ClassLoader bootstrapClassLoader;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private static boolean reflectCacheEnabled;
    private static boolean reflectCacheAppOnly;
    private static boolean reflectCacheDebug;
    private static final boolean isAssertOptionFound;
    private long vmRef;
    ClassLoader parent;
    private boolean initDone;
    private static boolean checkAssertionOptions;
    private Object assertionLock = new AssertionLock();
    private boolean defaultAssertionStatus;
    private Map packageAssertionStatus;
    private Map classAssertionStatus;
    private volatile Hashtable packages;
    Object lazyInitLock = new LazyInitLock();
    private volatile Hashtable classSigners;
    private volatile Hashtable packageSigners;
    private static Certificate[] emptyCertificates;
    private volatile ProtectionDomain defaultProtectionDomain;
    private static Map<Class, Object> parallelCapableCollection;
    private volatile Hashtable classNameBasedLock;
    private boolean isParallelCapable;
    private static boolean allowArraySyntax;
    private static boolean lazyClassLoaderInit;
    private static ReferenceQueue queue;
    private volatile Hashtable methodCache;
    private volatile Hashtable fieldCache;
    private volatile Hashtable constructorCache;

    static final void initializeClassLoaders() {
        String propValue;
        if (bootstrapClassLoader != null) {
            return;
        }
        parallelCapableCollection = Collections.synchronizedMap(new WeakHashMap());
        String allowValue = System.getProperty("sun.lang.ClassLoader.allowArraySyntax");
        if (allowValue != null) {
            allowValue = allowValue.toLowerCase();
        }
        if ("true".equals(allowValue)) {
            allowArraySyntax = true;
        }
        if ((propValue = System.getProperty("reflect.cache")) != null) {
            propValue = propValue.toLowerCase();
        }
        if (!"false".equals(propValue)) {
            reflectCacheEnabled = true;
            if (propValue != null) {
                StringTokenizer tokenizer = new StringTokenizer(propValue, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    if (!"debug".equals(value)) continue;
                    reflectCacheDebug = true;
                }
            }
        }
        try {
            Class.forName("java.security.ProtectionDomain");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ClassLoader sysTemp = null;
        String systemLoaderString = System.getProperty("systemClassLoader");
        if (null == systemLoaderString) {
            sysTemp = BootstrapClassLoader.singleton();
        } else {
            try {
                sysTemp = (ClassLoader)Class.forName(systemLoaderString, true, null).newInstance();
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
        bootstrapClassLoader = sysTemp;
        AbstractClassLoader.setBootstrapClassLoader(bootstrapClassLoader);
        applicationClassLoader = bootstrapClassLoader;
        ClassLoader tempLoader = applicationClassLoader = Launcher.getLauncher().getClassLoader();
        while (tempLoader.parent != null) {
            tempLoader = tempLoader.parent;
        }
        VMAccess.setExtClassLoader(tempLoader);
        if (reflectCacheEnabled) {
            Class.initCacheIds();
        }
        lazyClassLoaderInit = true;
        String lazyValue = System.getProperty("java.lang.ClassLoader.lazyInitialization");
        if (lazyValue != null && "false".equals(lazyValue = lazyValue.toLowerCase())) {
            lazyClassLoaderInit = false;
        }
    }

    protected ClassLoader() {
        this(applicationClassLoader);
    }

    protected ClassLoader(ClassLoader parentLoader) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        if (parallelCapableCollection.containsKey(this.getClass())) {
            this.isParallelCapable = true;
        }
        if (parentLoader != null && !parentLoader.initDone) {
            throw new SecurityException(Msg.getString("K0546"));
        }
        this.parent = parentLoader;
        if (bootstrapClassLoader != null && !lazyClassLoaderInit) {
            VM.initializeClassLoader(this, false, this.isParallelCapable);
        }
        if (isAssertOptionFound) {
            this.initializeClassLoaderAssertStatus();
        }
        this.initDone = true;
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] classRep, int offset, int length) throws ClassFormatError {
        return this.defineClass(null, classRep, offset, length);
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length) throws ClassFormatError {
        return this.defineClass(className, classRep, offset, length, null);
    }

    private String checkClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            String packageName = className.substring(0, index);
            if (className.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", packageName, className));
            }
            return packageName;
        }
        return "";
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length, ProtectionDomain protectionDomain) throws ClassFormatError {
        CodeSource cs;
        Object[] certs = null;
        if (protectionDomain != null && (cs = protectionDomain.getCodeSource()) != null) {
            certs = cs.getCertificates();
        }
        if (className != null) {
            String packageName = this.checkClassName(className);
            this.checkPackageSigners(packageName, className, (Certificate[])certs);
        }
        if (offset < 0 || length < 0 || offset > classRep.length || length > classRep.length - offset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        ProtectionDomain pd = protectionDomain;
        Class answer = this.defineClassImpl(className, classRep, offset, length, pd);
        if (this.isVerboseImpl()) {
            URL url;
            CodeSource cs2;
            String location = "<unknown>";
            if (pd != null && (cs2 = pd.getCodeSource()) != null && (url = cs2.getLocation()) != null) {
                location = url.toString();
            }
            VM.dumpString("class load: " + answer.getName() + " from: " + location + "\n");
        }
        if (certs != null) {
            this.setSigners(answer, certs);
        }
        return answer;
    }

    private native boolean isVerboseImpl();

    private static native boolean foundJavaAssertOption();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPackageSigners(String packageName, String className, Certificate[] classCerts) {
        Certificate[] packageCerts = null;
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.packageSigners != null) {
                packageCerts = (Certificate[])this.packageSigners.get(packageName);
            } else {
                this.packageSigners = new Hashtable();
            }
        }
        if (packageCerts == null) {
            if (classCerts == null) {
                this.packageSigners.put(packageName, emptyCertificates);
            } else {
                this.packageSigners.put(packageName, classCerts);
            }
        } else {
            if (classCerts == null && packageCerts.length == 0 || classCerts == packageCerts) {
                return;
            }
            if (classCerts != null && classCerts.length == packageCerts.length) {
                boolean foundMatch = true;
                block3: for (int i = 0; i < classCerts.length; ++i) {
                    if (classCerts[i] == packageCerts[i] || classCerts[i].equals(packageCerts[i])) continue;
                    for (int j = 0; j < packageCerts.length; ++j) {
                        if (j != i && (classCerts[i] == packageCerts[j] || classCerts[i].equals(packageCerts[j]))) continue block3;
                    }
                    foundMatch = false;
                    break;
                }
                if (foundMatch) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", className));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.isParallelCapable) {
            if (this.defaultProtectionDomain == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    return this.getDefaultProtectionDomainHelper();
                }
            }
            return this.defaultProtectionDomain;
        }
        return this.getDefaultProtectionDomainHelper();
    }

    private final ProtectionDomain getDefaultProtectionDomainHelper() {
        if (this.defaultProtectionDomain == null) {
            this.defaultProtectionDomain = new ProtectionDomain(defaultCodeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class<?> findClass(String className) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final Class<?> findLoadedClass(String className) {
        if (!allowArraySyntax && className != null && className.length() > 0 && className.charAt(0) == '[') {
            return null;
        }
        return this.findLoadedClassImpl(className);
    }

    private native Class findLoadedClassImpl(String var1);

    protected final Class<?> findSystemClass(String className) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(className);
    }

    @CallerSensitive
    public final ClassLoader getParent() {
        ClassLoader callersClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != this.parent && !callersClassLoader.isAncestorOf(this.parent)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.parent;
    }

    public URL getResource(String resName) {
        URL url;
        URL uRL = url = this.parent == null ? bootstrapClassLoader.findResource(resName) : this.parent.getResource(resName);
        if (url != null) {
            return url;
        }
        return this.findResource(resName);
    }

    public Enumeration<URL> getResources(String resName) throws IOException {
        final Vector<Enumeration<URL>> resources = new Vector<Enumeration<URL>>(2);
        Enumeration<URL> parentResources = null;
        if (this.parent != null) {
            parentResources = this.parent.getResources(resName);
        } else if (this != bootstrapClassLoader) {
            parentResources = bootstrapClassLoader.getResources(resName);
        }
        Enumeration<URL> localResources = this.findResources(resName);
        if (parentResources != null) {
            resources.add(parentResources);
        }
        if (localResources != null) {
            resources.add(localResources);
        }
        return new Enumeration<URL>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                while (this.index < resources.size()) {
                    if (((Enumeration)resources.elementAt(this.index)).hasMoreElements()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.index < resources.size()) {
                    Enumeration e = (Enumeration)resources.elementAt(this.index);
                    if (e.hasMoreElements()) {
                        return (URL)e.nextElement();
                    }
                    ++this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String resName) {
        URL url = this.getResource(resName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void completeInitialization() {
        Class<Void> voidClass = Void.TYPE;
        String propValue = System.getProperty("reflect.cache");
        if (propValue != null) {
            propValue = propValue.toLowerCase();
        }
        if (!"false".equals(propValue)) {
            reflectCacheAppOnly = false;
            if (propValue != null) {
                StringTokenizer tokenizer = new StringTokenizer(propValue, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    if ("boot".equals(value)) {
                        reflectCacheAppOnly = false;
                    }
                    if (!"app".equals(value)) continue;
                    reflectCacheAppOnly = true;
                }
            }
        }
        initSystemClassLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    public static ClassLoader getSystemClassLoader() {
        ClassLoader callersClassLoader;
        if (initSystemClassLoader) {
            Class<ClassLoader> classLoaderClass;
            Class<ClassLoader> clazz = classLoaderClass = ClassLoader.class;
            synchronized (clazz) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    String userLoader = System.getProperty("java.system.class.loader");
                    if (userLoader != null) {
                        try {
                            Class<?> loaderClass = Class.forName(userLoader, true, applicationClassLoader);
                            Constructor<?> constructor = loaderClass.getConstructor(classLoaderClass);
                            ClassLoader tempLoader = applicationClassLoader = (ClassLoader)constructor.newInstance(applicationClassLoader);
                            while (tempLoader.parent != null) {
                                tempLoader = tempLoader.parent;
                            }
                            VMAccess.setExtClassLoader(tempLoader);
                        }
                        catch (Throwable e) {
                            throw new Error(e);
                        }
                    }
                }
            }
        }
        ClassLoader sysLoader = applicationClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != sysLoader && !callersClassLoader.isAncestorOf(sysLoader)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return sysLoader;
    }

    public static URL getSystemResource(String resName) {
        return ClassLoader.getSystemClassLoader().getResource(resName);
    }

    public static Enumeration<URL> getSystemResources(String resName) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(resName);
    }

    public static InputStream getSystemResourceAsStream(String resName) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(resName);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        if (this.isParallelCapable) {
            Object object = this.getClassLoadingLock(className);
            synchronized (object) {
                return this.loadClassHelper(className, resolveClass);
            }
        }
        ClassLoader classLoader = this;
        synchronized (classLoader) {
            return this.loadClassHelper(className, resolveClass);
        }
    }

    private Class<?> loadClassHelper(String className, boolean resolveClass) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass == null) {
            try {
                loadedClass = this.parent == null ? bootstrapClassLoader.loadClass(className) : this.parent.loadClass(className, resolveClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (loadedClass == null) {
                loadedClass = this.findClass(className);
            }
        }
        if (resolveClass) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @CallerSensitive
    protected static boolean registerAsParallelCapable() {
        Class callerCls = System.getCallerClass();
        Class superCls = callerCls.getSuperclass();
        if (parallelCapableCollection.containsKey(callerCls)) {
            return true;
        }
        if (superCls == ClassLoader.class || parallelCapableCollection.containsKey(superCls)) {
            parallelCapableCollection.put(callerCls, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getClassLoadingLock(String className) {
        if (this.isParallelCapable) {
            if (this.classNameBasedLock == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classNameBasedLock == null) {
                        this.classNameBasedLock = new Hashtable();
                    }
                }
            }
            Object[] locks = new Object[]{null};
            Hashtable hashtable = this.classNameBasedLock;
            synchronized (hashtable) {
                WeakReference wf = (WeakReference)this.classNameBasedLock.get(className);
                Object object = locks[0] = null != wf ? (Object)wf.get() : null;
                if (locks[0] == null) {
                    locks[0] = new ClassNameBasedLock();
                    this.classNameBasedLock.put(className, new ClassNameLockRef(locks[0], className, this.classNameBasedLock));
                }
            }
            return locks[0];
        }
        return this;
    }

    protected final void resolveClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
    }

    private void setParent(ClassLoader newParent) {
        this.parent = newParent;
    }

    final boolean isASystemClassLoader() {
        if (this == bootstrapClassLoader) {
            return true;
        }
        ClassLoader cl = applicationClassLoader;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader child) {
        if (child == null) {
            return false;
        }
        if (this == bootstrapClassLoader) {
            return true;
        }
        ClassLoader cl = child.parent;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    protected URL findResource(String resName) {
        return null;
    }

    protected Enumeration<URL> findResources(String resName) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String libName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Package result;
        boolean packagesNotNull = true;
        if (this.packages == null) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                if (this.packages == null) {
                    packagesNotNull = false;
                }
            }
        }
        if (packagesNotNull && (result = (Package)this.packages.get(name)) != null) {
            return result;
        }
        if (this != bootstrapClassLoader) {
            ClassLoader parent = this.parent;
            if (parent == null) {
                parent = bootstrapClassLoader;
            }
            return parent.getPackage(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        int resultSize;
        Hashtable localPackages;
        Package[] ancestorsPackages = null;
        if (this.parent == null) {
            if (this != bootstrapClassLoader) {
                ancestorsPackages = bootstrapClassLoader.getPackages();
            }
        } else {
            ancestorsPackages = this.parent.getPackages();
        }
        Object object = this.lazyInitLock;
        synchronized (object) {
            localPackages = this.packages;
        }
        int n = resultSize = localPackages == null ? 0 : localPackages.size();
        if (ancestorsPackages != null) {
            resultSize += ancestorsPackages.length;
        }
        Package[] result = new Package[resultSize];
        if (ancestorsPackages != null) {
            for (int i = 0; i < ancestorsPackages.length; ++i) {
                result[i] = ancestorsPackages[i];
            }
        }
        if (localPackages != null) {
            Enumeration myPkgs = localPackages.elements();
            while (myPkgs.hasMoreElements()) {
                result[i++] = (Package)myPkgs.nextElement();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Object object;
        if (this.packages == null) {
            object = this.lazyInitLock;
            synchronized (object) {
                if (this.packages == null) {
                    this.packages = new Hashtable();
                }
            }
        }
        object = this.packages;
        synchronized (object) {
            if (this.getPackage(name) == null) {
                Package newPackage = null;
                newPackage = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase, this);
                this.packages.put(name, newPackage);
                return newPackage;
            }
            throw new IllegalArgumentException(Msg.getString("K0053", name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getSigners(Class c) {
        if (this.classSigners == null) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                if (this.classSigners == null) {
                    return null;
                }
            }
        }
        try {
            Object result = this.classSigners.get(c);
            if (result != null) {
                return (Object[])result.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class<?> c, Object[] signers) {
        if (c.getClassLoaderImpl() == this) {
            if (signers == null) {
                if (this.classSigners == null) {
                    Object object = this.lazyInitLock;
                    synchronized (object) {
                        if (this.classSigners == null) {
                            return;
                        }
                    }
                }
                this.classSigners.remove(c);
            } else {
                if (this.classSigners == null) {
                    Object object = this.lazyInitLock;
                    synchronized (object) {
                        if (this.classSigners == null) {
                            this.classSigners = new Hashtable();
                        }
                    }
                }
                this.classSigners.put(c, signers);
            }
        } else {
            c.getClassLoaderImpl().setSigners(c, signers);
        }
    }

    @CallerSensitive
    static ClassLoader getCallerClassLoader() {
        ClassLoader loader = ClassLoader.getStackClassLoader(2);
        if (loader == bootstrapClassLoader) {
            return null;
        }
        return loader;
    }

    @CallerSensitive
    static final native ClassLoader getStackClassLoader(int var0);

    @CallerSensitive
    static ClassLoader callerClassLoader() {
        ClassLoader loader = ClassLoader.getStackClassLoader(2);
        if (loader == bootstrapClassLoader) {
            return null;
        }
        return loader;
    }

    static synchronized void loadLibraryWithClassLoader(String libName, ClassLoader loader) {
        String realLibName;
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(libName);
        }
        if (loader != null && (realLibName = loader.findLibrary(libName)) != null) {
            ClassLoader.loadLibraryWithPath(realLibName, loader, null);
            return;
        }
        ClassLoader.loadLibraryWithPath(libName, loader, System.internalGetProperties().getProperty(loader == null ? "com.ibm.oti.vm.bootstrap.library.path" : "java.library.path"));
    }

    static void loadLibraryWithPath(String libName, ClassLoader loader, String libraryPath) {
        byte[] message;
        if (File.separatorChar == '\\' && libName.startsWith("/") && Util.startsWithDriveLetter(libName.substring(1))) {
            libName = libName.substring(1);
        }
        if ((message = ClassLoader.loadLibraryWithPath(Util.getBytes(libName), loader, libraryPath == null ? null : Util.getBytes(libraryPath))) != null) {
            String error;
            try {
                error = Util.convertFromUTF8(message, 0, message.length);
            }
            catch (IOException e) {
                error = Util.toString(message);
            }
            throw new UnsatisfiedLinkError(libName + " (" + error + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    static void loadLibrary(Class caller, String name, boolean fullPath) {
        if (fullPath) {
            ClassLoader.loadLibraryWithPath(name, caller.getClassLoaderImpl(), null);
        } else {
            ClassLoader.loadLibraryWithClassLoader(name, caller.getClassLoaderImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String cname, boolean enable) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.setClassAssertionStatusHelper(cname, enable);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.setClassAssertionStatusHelper(cname, enable);
        }
    }

    private void setClassAssertionStatusHelper(String cname, boolean enable) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap();
        }
        this.classAssertionStatus.put(cname, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String pname, boolean enable) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.setPackageAssertionStatusHelper(pname, enable);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.setPackageAssertionStatusHelper(pname, enable);
        }
    }

    private void setPackageAssertionStatusHelper(String pname, boolean enable) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap();
        }
        this.packageAssertionStatus.put(pname, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean enable) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.defaultAssertionStatus = enable;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.defaultAssertionStatus = false;
                this.classAssertionStatus = null;
                this.packageAssertionStatus = null;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String cname) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.getClassAssertionStatusHelper(cname);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.getClassAssertionStatusHelper(cname);
        }
    }

    private boolean getClassAssertionStatusHelper(String cname) {
        int dlrIndex = -1;
        if (this.classAssertionStatus != null) {
            Boolean b = (Boolean)this.classAssertionStatus.get(cname);
            if (b != null) {
                return b;
            }
            dlrIndex = cname.indexOf(36);
            if (dlrIndex > 0 && (b = (Boolean)this.classAssertionStatus.get(cname.substring(0, dlrIndex))) != null) {
                return b;
            }
        }
        if ((dlrIndex = cname.lastIndexOf(46)) > 0) {
            return this.getPackageAssertionStatus(cname.substring(0, dlrIndex));
        }
        return this.getDefaultAssertionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String pname) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.getPackageAssertionStatusHelper(pname);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.getPackageAssertionStatusHelper(pname);
        }
    }

    private boolean getPackageAssertionStatusHelper(String pname) {
        int prdIndex = -1;
        if (this.packageAssertionStatus != null) {
            Boolean b = (Boolean)this.packageAssertionStatus.get(pname);
            if (b != null) {
                return b;
            }
            prdIndex = pname.lastIndexOf(46);
            if (prdIndex > 0) {
                return this.getPackageAssertionStatus(pname.substring(0, prdIndex));
            }
        }
        return this.getDefaultAssertionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.defaultAssertionStatus;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bootLoader;
        boolean bl = bootLoader = bootstrapClassLoader == null;
        if (!bootLoader && !checkAssertionOptions) {
            return;
        }
        boolean foundAssertionOptions = false;
        String[] vmargs = VM.getVMArgs();
        for (int i = 0; i < vmargs.length; ++i) {
            boolean def;
            String vmargExtraInfo;
            String vmargOptions;
            if (!vmargs[i].startsWith("-e") && !vmargs[i].startsWith("-d")) continue;
            int indexColon = vmargs[i].indexOf(58);
            if (indexColon == -1) {
                vmargOptions = vmargs[i];
                vmargExtraInfo = null;
            } else {
                vmargOptions = vmargs[i].substring(0, indexColon);
                vmargExtraInfo = vmargs[i].substring(indexColon + 1);
            }
            if (vmargOptions.compareTo("-ea") == 0 || vmargOptions.compareTo("-enableassertions") == 0 || vmargOptions.compareTo("-da") == 0 || vmargOptions.compareTo("-disableassertions") == 0) {
                foundAssertionOptions = true;
                boolean bl2 = def = vmargOptions.charAt(1) == 'e';
                if (vmargExtraInfo == null) {
                    if (bootLoader) continue;
                    this.setDefaultAssertionStatus(def);
                    continue;
                }
                String str = vmargExtraInfo;
                int len = str.length();
                if (len > 3 && str.charAt(len - 1) == '.' && str.charAt(len - 2) == '.' && str.charAt(len - 3) == '.') {
                    str = str.substring(0, len - 3);
                    this.setPackageAssertionStatus(str, def);
                    continue;
                }
                this.setClassAssertionStatus(str, def);
                continue;
            }
            if (vmargOptions.compareTo("-esa") != 0 && vmargOptions.compareTo("-enablesystemassertions") != 0 && vmargOptions.compareTo("-dsa") != 0 && vmargOptions.compareTo("-disablesystemassertions") != 0 || !bootLoader) continue;
            def = vmargOptions.charAt(1) == 'e';
            this.setDefaultAssertionStatus(def);
        }
        if (bootLoader && foundAssertionOptions) {
            checkAssertionOptions = true;
        }
    }

    protected final Class<?> defineClass(String name, ByteBuffer buffer, ProtectionDomain domain) throws ClassFormatError {
        if (buffer.hasArray()) {
            return this.defineClass(name, buffer.array(), buffer.position(), buffer.limit() - buffer.position(), domain);
        }
        int size = buffer.limit() - buffer.position();
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return this.defineClass(name, bytes, 0, bytes.length, domain);
    }

    static boolean isReflectCacheEnabled() {
        return reflectCacheEnabled;
    }

    static boolean isReflectCacheAppOnly() {
        return reflectCacheAppOnly;
    }

    static boolean isReflectCacheDebug() {
        return reflectCacheDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Hashtable getMethodCache() {
        Hashtable cache = this.methodCache;
        if (cache == null) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                cache = this.methodCache;
                if (cache == null) {
                    this.methodCache = cache = new Hashtable();
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getMethodCache(Class cl) {
        Object object;
        Hashtable<Class, CacheTable> cache = this.methodCache;
        if (cache == null) {
            object = this.lazyInitLock;
            synchronized (object) {
                cache = this.methodCache;
                if (cache == null) {
                    this.methodCache = cache = new Hashtable<Class, CacheTable>();
                }
            }
        }
        object = cache;
        synchronized (object) {
            CacheTable clCache = (CacheTable)cache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(cache, cl);
                cache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Hashtable getFieldCache() {
        Hashtable cache = this.fieldCache;
        if (cache == null) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                cache = this.fieldCache;
                if (cache == null) {
                    this.fieldCache = cache = new Hashtable();
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getFieldCache(Class cl) {
        Object object;
        Hashtable<Class, CacheTable> cache = this.fieldCache;
        if (cache == null) {
            object = this.lazyInitLock;
            synchronized (object) {
                cache = this.fieldCache;
                if (cache == null) {
                    this.fieldCache = cache = new Hashtable<Class, CacheTable>();
                }
            }
        }
        object = cache;
        synchronized (object) {
            CacheTable clCache = (CacheTable)cache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(cache, cl);
                cache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Hashtable getConstructorCache() {
        Hashtable cache = this.constructorCache;
        if (cache == null) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                cache = this.constructorCache;
                if (cache == null) {
                    this.constructorCache = cache = new Hashtable();
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getConstructorCache(Class cl) {
        Object object;
        Hashtable<Class, CacheTable> cache = this.constructorCache;
        if (cache == null) {
            object = this.lazyInitLock;
            synchronized (object) {
                cache = this.constructorCache;
                if (cache == null) {
                    this.constructorCache = cache = new Hashtable<Class, CacheTable>();
                }
            }
        }
        object = cache;
        synchronized (object) {
            CacheTable clCache = (CacheTable)cache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(cache, cl);
                cache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    private boolean compareCerts(Certificate[] pcerts, Certificate[] certs) {
        if (pcerts == null && certs == null || pcerts == certs || pcerts == null && certs.length == 0 || certs == null && pcerts.length == 0) {
            return true;
        }
        if (pcerts == null || certs == null || pcerts.length != certs.length) {
            return false;
        }
        boolean foundMatch = true;
        block0: for (int i = 0; i < pcerts.length; ++i) {
            if (pcerts[i] == certs[i] || pcerts[i].equals(certs[i])) continue;
            for (int j = 0; j < certs.length; ++j) {
                if (j != i && (pcerts[i] == certs[j] || pcerts[i].equals(certs[j]))) continue block0;
            }
            foundMatch = false;
            break;
        }
        return foundMatch;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    static {
        reflectCacheAppOnly = true;
        isAssertOptionFound = ClassLoader.foundJavaAssertOption();
        emptyCertificates = new Certificate[0];
        lazyClassLoaderInit = false;
        queue = new ReferenceQueue();
    }

    static class CacheTable
    extends Hashtable {
        private static final long serialVersionUID = 7227948070918461051L;
        Hashtable parent;
        Object key;
        int useCount;

        public CacheTable(Hashtable parent, Object key) {
            this.parent = parent;
            this.key = key;
        }

        @Override
        public Object get(Object key) {
            SoftReference sf = (SoftReference)super.get(key);
            return sf != null ? sf.get() : null;
        }

        public Object getRef(Object key) {
            return super.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEmpty() {
            Hashtable hashtable = this.parent;
            synchronized (hashtable) {
                CacheTable cacheTable = this;
                synchronized (cacheTable) {
                    if (this.isEmpty() && this.useCount == 0) {
                        if (ClassLoader.isReflectCacheDebug()) {
                            System.err.println("Removed reflect cache for: " + this.key);
                        }
                        this.parent.remove(this.key);
                    } else if (ClassLoader.isReflectCacheDebug()) {
                        System.err.println("Reflect cache size: " + this.size() + " and useCount: " + this.useCount + " for: " + this.key);
                    }
                }
            }
        }

        public synchronized void used() {
            ++this.useCount;
        }

        public synchronized void free() {
            --this.useCount;
        }
    }

    static final class ClassNameLockRef
    extends WeakReference
    implements Runnable {
        private String key;
        private Hashtable classNameLockHT;

        public ClassNameLockRef(Object referent, String keyValue, Hashtable classNameLockHTValue) {
            super(referent, queue);
            this.key = keyValue;
            this.classNameLockHT = classNameLockHTValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Hashtable hashtable = this.classNameLockHT;
            synchronized (hashtable) {
                if (this.classNameLockHT.get(this.key) == this) {
                    this.classNameLockHT.remove(this.key);
                }
            }
        }
    }

    private static class ClassNameBasedLock {
        private ClassNameBasedLock() {
        }
    }

    private static class LazyInitLock {
        private LazyInitLock() {
        }
    }

    private static class AssertionLock {
        private AssertionLock() {
        }
    }
}

