/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Unsafe;
import sun.reflect.misc.ReflectUtil;

class J9VMInternals {
    private static final int j9Version = 84083312;
    private static final long j9Config = 8314596480236151296L;
    private static Map exceptions;
    static boolean initialized;
    private static Unsafe unsafe;

    J9VMInternals() {
    }

    private static void completeInitialization() {
        initialized = true;
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        Thread.currentThread().completeInitialization();
    }

    static native boolean isXaggressiveImpl();

    static void initialize(Class<?> clazz) {
        if (null != clazz.initializationLock) {
            Unsafe localUnsafe = unsafe;
            if (null == localUnsafe) {
                localUnsafe = unsafe = Unsafe.getUnsafe();
            }
            localUnsafe.ensureClassInitialized(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializationAlreadyFailed(Class clazz) {
        NoClassDefFoundError notFound = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
        if (exceptions != null) {
            Map map = exceptions;
            synchronized (map) {
                Throwable reason;
                SoftReference weakReason = (SoftReference)exceptions.get(clazz);
                if (weakReason != null && (reason = (Throwable)weakReason.get()) != null) {
                    reason = J9VMInternals.copyThrowable(reason);
                    notFound.initCause(reason);
                }
            }
        }
        throw notFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordInitializationFailure(Class clazz, Throwable err) {
        if (initialized) {
            if (exceptions == null) {
                exceptions = new WeakHashMap();
            }
            Map map = exceptions;
            synchronized (map) {
                Throwable cause = err;
                if (err instanceof ExceptionInInitializerError && (cause = ((ExceptionInInitializerError)err).getException()) == null) {
                    cause = err;
                }
                exceptions.put(clazz, new SoftReference<Throwable>(J9VMInternals.copyThrowable(cause)));
            }
        }
        J9VMInternals.ensureError(err);
    }

    private static void ensureError(Throwable err) {
        if (err instanceof Error) {
            throw (Error)err;
        }
        throw new ExceptionInInitializerError(err);
    }

    private static native Throwable newInstance(Class var0, Class var1);

    private static Throwable cloneThrowable(final Throwable throwable, final HashMap hashMapThrowable) {
        return (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Throwable clone;
                try {
                    Class cls = throwable.getClass();
                    clone = J9VMInternals.newInstance(cls, Object.class);
                    while (cls != null) {
                        Field[] fields = cls.getDeclaredFields();
                        for (int i = 0; i < fields.length; ++i) {
                            Object value;
                            if (Modifier.isStatic(fields[i].getModifiers()) || cls == Throwable.class && fields[i].getName().equals("walkback")) continue;
                            fields[i].setAccessible(true);
                            if (cls == Throwable.class && fields[i].getName().equals("cause")) {
                                value = clone;
                            } else {
                                value = fields[i].get(throwable);
                                if (value instanceof Throwable) {
                                    value = J9VMInternals.copyThrowable((Throwable)value, hashMapThrowable);
                                }
                            }
                            fields[i].set(clone, value);
                        }
                        cls = J9VMInternals.getSuperclass(cls);
                    }
                }
                catch (Throwable e) {
                    clone = new Throwable("Error cloning Throwable (" + e + "). The original exception was: " + throwable.toString());
                }
                return clone;
            }
        });
    }

    private static Throwable copyThrowable(Throwable throwable) {
        HashMap hashMapThrowable = new HashMap();
        return J9VMInternals.copyThrowable(throwable, hashMapThrowable);
    }

    private static Throwable copyThrowable(Throwable throwable, HashMap hashMapThrowable) {
        if (hashMapThrowable.get(throwable) != null) {
            return throwable;
        }
        hashMapThrowable.put(throwable, throwable);
        Throwable root = J9VMInternals.cloneThrowable(throwable, hashMapThrowable);
        root.setStackTrace(throwable.getStackTrace());
        Throwable parent = root;
        for (Throwable cause = throwable.getCause(); cause != null && hashMapThrowable.get(cause) == null; cause = cause.getCause()) {
            hashMapThrowable.put(cause, cause);
            Throwable child = J9VMInternals.cloneThrowable(cause, hashMapThrowable);
            child.setStackTrace(cause.getStackTrace());
            parent.setCause(child);
            parent = child;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.group.remove(thread);
        }
        finally {
            thread.cleanup();
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(final Class clazz, ProtectionDomain pd) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sm.checkPackageAccess(clazz.getPackageName());
                    if (Proxy.isProxyClass(clazz)) {
                        ClassLoader cl = J9VMInternals.getClassLoader(clazz);
                        ReflectUtil.checkProxyPackageAccess(cl, clazz.getInterfaces());
                    }
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{pd}));
        }
    }

    private static void runFinalize(Object obj) {
        try {
            obj.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static native StackTraceElement[] getStackTrace(Throwable var0, boolean var1);

    private static native void prepareClassImpl(Class var0);

    static void prepare(Class clazz) {
        if (clazz.initializationLock == null) {
            return;
        }
        J9VMInternals.prepareClassImpl(clazz);
    }

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native ClassLoader getClassLoader(Class var0);

    static native Object newInstanceImpl(Class var0) throws IllegalAccessException, InstantiationException;

    static native int identityHashCode(Object var0);

    static native Object primitiveClone(Object var0) throws CloneNotSupportedException;

    public static native void dumpString(String var0);

    static class ClassInitializationLock {
        Class theClass;

        ClassInitializationLock() {
        }
    }
}

