/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PassThroughHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithInt;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class CatchHandle
extends PassThroughHandle {
    private final MethodHandle tryTarget;
    private final Class<? extends Throwable> exceptionClass;
    private final MethodHandle catchTarget;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected CatchHandle(MethodHandle tryTarget, Class<? extends Throwable> exceptionClass, MethodHandle catchTarget, MethodHandle equivalent) {
        super(equivalent, "CatchHandle", CatchHandle.infoAffectingThunks(catchTarget.type().parameterCount()));
        this.tryTarget = tryTarget;
        this.exceptionClass = exceptionClass;
        this.catchTarget = catchTarget;
    }

    CatchHandle(CatchHandle catchHandle, MethodType newType) {
        super(catchHandle, newType);
        this.tryTarget = catchHandle.tryTarget;
        this.exceptionClass = catchHandle.exceptionClass;
        this.catchTarget = catchHandle.catchTarget;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new CatchHandle(this, newType);
    }

    public static CatchHandle get(MethodHandle tryTarget, Class<? extends Throwable> exceptionClass, MethodHandle catchTarget, MethodHandle equivalent) {
        return new CatchHandle(tryTarget, exceptionClass, catchTarget, equivalent);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static native int numCatchTargetArgsToPassThrough();

    private static Object infoAffectingThunks(int numCatchTargetArgs) {
        return numCatchTargetArgs;
    }

    @Override
    protected final ThunkTuple computeThunks(Object arg) {
        int numCatchTargetArgs = (Integer)arg;
        return this.thunkTable().get(new ThunkKeyWithInt(ThunkKey.computeThunkableType(this.type()), numCatchTargetArgs));
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.tryTarget, this.catchTarget);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        try {
            return ILGenMacros.invokeExact_X(this.tryTarget, argPlaceholder);
        }
        catch (Throwable t) {
            if (this.exceptionClass.isInstance(t)) {
                return ILGenMacros.invokeExact_X(this.catchTarget, ILGenMacros.placeholder(t, ILGenMacros.firstN(CatchHandle.numCatchTargetArgsToPassThrough(), argPlaceholder)));
            }
            throw t;
        }
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof CatchHandle) {
            ((CatchHandle)right).compareWithCatch(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithCatch(CatchHandle left, Comparator c) {
        c.compareStructuralParameter(left.exceptionClass, this.exceptionClass);
        c.compareChildHandle(left.tryTarget, this.tryTarget);
        c.compareChildHandle(left.catchTarget, this.catchTarget);
    }
}

