/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.Debug;
import java.util.Collections;
import java.util.Map;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrefixResolverImpl
implements PrefixResolver {
    private static Debug debug = Debug.getInstance("xmlenc");
    Node m_context;
    Map nsmap;

    public PrefixResolverImpl(Node xpathExpressionContext) {
        this.m_context = xpathExpressionContext;
    }

    public void setNamespaceMap(Map map) {
        this.nsmap = Collections.unmodifiableMap(map);
    }

    public String getNamespaceForPrefix(String prefix) {
        String ns = this.getNamespaceForPrefix(prefix, this.m_context);
        if (ns == null) {
            try {
                ns = (String)this.nsmap.get(prefix);
            }
            catch (RuntimeException ex) {
                ns = null;
            }
        }
        if (debug != null) {
            debug.trace("PrefixResloverImpl", "getNamespaceForPrefix", "getNS:" + ns);
        }
        return ns;
    }

    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        if (debug != null) {
            debug.trace("PrefixResloveImpl", "getNamespaceForPrefix", "getNS for node " + namespaceContext.getLocalName());
        }
        String namespace = null;
        if (prefix.equals("xml")) {
            namespace = "http://www.w3.org/XML/1998/namespace";
        } else {
            short type;
            block0: for (Node parent = namespaceContext; null != parent && null == namespace && ((type = parent.getNodeType()) == 1 || type == 5); parent = parent.getParentNode()) {
                if (type != 1) continue;
                if (parent.getNodeName().indexOf(prefix + ":") == 0) {
                    return parent.getNamespaceURI();
                }
                NamedNodeMap nnm = parent.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    String p;
                    Node attr = nnm.item(i);
                    String aname = attr.getNodeName();
                    boolean isPrefix = aname.startsWith("xmlns:");
                    if (!isPrefix && !aname.equals("xmlns")) continue;
                    int index = aname.indexOf(58);
                    String string = p = isPrefix ? aname.substring(index + 1) : "";
                    if (!p.equals(prefix)) continue;
                    namespace = attr.getNodeValue();
                    continue block0;
                }
            }
        }
        return namespace;
    }

    public String getBaseIdentifier() {
        return null;
    }

    public boolean handlesNullPrefixes() {
        return false;
    }
}

