/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.ntlm;

import com.ibm.security.ntlm.NTLMException;
import com.ibm.security.ntlm.Server;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class NTLMServer
implements SaslServer {
    private static final String NTLM_VERSION = "com.sun.security.sasl.ntlm.version";
    private static final String NTLM_DOMAIN = "com.sun.security.sasl.ntlm.domain";
    private static final String NTLM_HOSTNAME = "com.sun.security.sasl.ntlm.hostname";
    private static final String NTLM_RANDOM = "com.sun.security.sasl.ntlm.random";
    private final Random random;
    private final Server server;
    private byte[] nonce;
    private int step = 0;
    private String authzId;
    private final String mech;
    private String hostname;

    NTLMServer(String mech, String protocol, String serverName, Map props, final CallbackHandler cbh) throws SaslException {
        this.mech = mech;
        String version = null;
        String domain = null;
        Random rtmp = null;
        if (props != null) {
            domain = (String)props.get(NTLM_DOMAIN);
            version = (String)props.get(NTLM_VERSION);
            rtmp = (Random)props.get(NTLM_RANDOM);
        }
        Random random = this.random = rtmp != null ? rtmp : new Random();
        if (version == null) {
            version = System.getProperty("ntlm.version");
        }
        if (domain == null) {
            domain = serverName;
        }
        if (domain == null) {
            throw new NullPointerException("Domain must be provided as the serverName argument or in props");
        }
        try {
            this.server = new Server(version, domain){

                public char[] getPassword(String ntdomain, String username) {
                    try {
                        RealmCallback rcb = new RealmCallback("Domain: ", ntdomain);
                        NameCallback ncb = new NameCallback("Name: ", username);
                        PasswordCallback pcb = new PasswordCallback("Password: ", false);
                        cbh.handle(new Callback[]{rcb, ncb, pcb});
                        char[] passwd = pcb.getPassword();
                        pcb.clearPassword();
                        return passwd;
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    catch (UnsupportedCallbackException uce) {
                        return null;
                    }
                }
            };
        }
        catch (NTLMException ne) {
            throw new SaslException("NTLM: Invalid version string: " + version, ne);
        }
        this.nonce = new byte[8];
    }

    public String getMechanismName() {
        return this.mech;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            ++this.step;
            if (this.step == 1) {
                this.random.nextBytes(this.nonce);
                return this.server.type2(response, this.nonce);
            }
            String[] out = this.server.verify(response, this.nonce);
            this.authzId = out[0];
            this.hostname = out[1];
            return null;
        }
        catch (GeneralSecurityException ex) {
            throw new SaslException("", ex);
        }
    }

    public boolean isComplete() {
        return this.step >= 2;
    }

    public String getAuthorizationID() {
        return this.authzId;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getNegotiatedProperty(String propName) {
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        if (propName.equals(NTLM_HOSTNAME)) {
            return this.hostname;
        }
        return null;
    }

    public void dispose() throws SaslException {
    }
}

