/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.heapdump.portableheapdump;

import com.ibm.jvm.heapdump.ReferenceIterator;
import com.ibm.jvm.heapdump.portableheapdump.LongObjectRecord;
import com.ibm.jvm.heapdump.portableheapdump.MediumObjectRecord;
import com.ibm.jvm.heapdump.portableheapdump.PortableHeapDumpClassCache;
import com.ibm.jvm.heapdump.portableheapdump.PortableHeapDumpRecord;
import com.ibm.jvm.heapdump.portableheapdump.ShortObjectRecord;

public abstract class ObjectRecord
extends PortableHeapDumpRecord {
    protected final int _hashCode;
    protected final long _classAddress;

    protected ObjectRecord(long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references) {
        super(address, previousAddress, references);
        this._hashCode = hashCode;
        this._classAddress = classAddress;
    }

    protected static boolean isShortObjectEligible(long current, long previous) {
        long addressDifference = PortableHeapDumpRecord.getAddressDifference(current, previous);
        return addressDifference < 32767L && addressDifference > -32768L;
    }

    public static ObjectRecord getObjectRecord(long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references, PortableHeapDumpClassCache cache, boolean is64Bit) {
        byte classCacheIndex = cache.getClassCacheIndex(classAddress);
        if (classCacheIndex == -1 || previousAddress == 0L) {
            cache.setClassCacheIndex(classAddress);
            return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit);
        }
        if (ObjectRecord.isShortObjectEligible(address, previousAddress)) {
            int numberOfReferences = ObjectRecord.countReferences(references);
            if (numberOfReferences <= 3) {
                return new ShortObjectRecord(address, previousAddress, classAddress, hashCode, references, classCacheIndex);
            }
            if (numberOfReferences < 8) {
                cache.setClassCacheIndex(classAddress);
                return new MediumObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit);
            }
            cache.setClassCacheIndex(classAddress);
            return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit);
        }
        cache.setClassCacheIndex(classAddress);
        return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit);
    }

    private static int countReferences(ReferenceIterator references) {
        int count = 0;
        references.reset();
        while (references.hasNext()) {
            references.next();
            ++count;
        }
        return count;
    }
}

