/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.heapdump.HeapDumpFormatter;
import com.ibm.jvm.heapdump.LongArrayReferenceIterator;
import com.ibm.jvm.heapdump.LongListReferenceIterator;
import com.ibm.jvm.heapdump.classicheapdump.ClassicHeapDumpFormatter;
import com.ibm.jvm.heapdump.portableheapdump.PortableHeapDumpFormatter;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpStats;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoader;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPool;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPoolEntry;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class HeapDumpUtil {
    public static String getDefaultFileName() {
        StringBuffer result = new StringBuffer();
        result.append(DumpConsole.getInputFilePath());
        result.append(HeapDumpUtil.isPortableDump() ? ".phd" : ".txt");
        result.append(".gz");
        return result.toString();
    }

    public static boolean isPortableDump() {
        String DumpFormatType = Console.getProperty("HEAPDUMPFORMAT");
        if (DumpFormatType == null) {
            return true;
        }
        return !DumpFormatType.equalsIgnoreCase("Classic");
    }

    public static HeapDumpStats doClassicHeapDump(Writer out) throws IOException {
        Dump toWalk = J9JVMConsole.getTheDump();
        return HeapDumpUtil.doHeapDump(toWalk, new ClassicHeapDumpFormatter(out, toWalk.getVersion(), toWalk.is64bit()));
    }

    public static HeapDumpStats doPortableHeapDump(OutputStream out) throws IOException, IllegalArgumentException {
        Dump toWalk = J9JVMConsole.getTheDump();
        return HeapDumpUtil.doHeapDump(toWalk, new PortableHeapDumpFormatter(new DataOutputStream(out), toWalk.getVersion(), toWalk.is64bit()));
    }

    private static HeapDumpStats doHeapDump(Dump toWalk, HeapDumpFormatter formatter) throws IOException {
        int numObj = 0;
        HeapDumpStats stats = new HeapDumpStats();
        J9ObjectIterator iter = J9ObjectIterator.getObjectIterator(null);
        while (iter.hasNext()) {
            J9Object current = (J9Object)iter.next();
            J9Class currentObjectClass = current.getClassForObject();
            if (current.isPrimitiveArray()) {
                HeapDumpUtil.dumpPrimitiveArray(formatter, current, stats);
            } else if (current.isArray()) {
                HeapDumpUtil.dumpObjectArray(formatter, current, stats);
            } else if (current.isInstanceOfClass()) {
                HeapDumpUtil.dumpClass(formatter, current, stats);
            } else {
                HeapDumpUtil.dumpObject(formatter, current, stats);
            }
            ++numObj;
        }
        formatter.close();
        stats.setNumberOfObjects(numObj);
        return stats;
    }

    private static void dumpObject(HeapDumpFormatter formatter, J9Object current, HeapDumpStats stats) throws IOException {
        J9Class objectClass = current.getClassForObject();
        formatter.addObject(current.getObjectAddress(), objectClass.getClassAddress(), objectClass.getName(), objectClass.getInstanceSize(), (int)current.getHashCode(), new LongArrayReferenceIterator(current.getObjectRefs()));
    }

    private static boolean stringContains(String value, String content) {
        return value.indexOf(content) != -1;
    }

    private static String decodePrimitiveArrayClassName(String name, HeapDumpStats stats) {
        if (HeapDumpUtil.stringContains(name, "boolean")) {
            return name.replaceAll("boolean", "Z");
        }
        if (HeapDumpUtil.stringContains(name, "char")) {
            return name.replaceAll("char", "C");
        }
        if (HeapDumpUtil.stringContains(name, "byte")) {
            return name.replaceAll("byte", "B");
        }
        if (HeapDumpUtil.stringContains(name, "short")) {
            return name.replaceAll("short", "S");
        }
        if (HeapDumpUtil.stringContains(name, "int")) {
            return name.replaceAll("int", "I");
        }
        if (HeapDumpUtil.stringContains(name, "long")) {
            return name.replaceAll("long", "J");
        }
        if (HeapDumpUtil.stringContains(name, "float")) {
            return name.replaceAll("float", "F");
        }
        if (HeapDumpUtil.stringContains(name, "double")) {
            return name.replaceAll("double", "D");
        }
        Console.reportError("Unknown primitive array type: " + name, null);
        stats.incrementErrors();
        return name;
    }

    private static void dumpClass(HeapDumpFormatter formatter, J9Object current, HeapDumpStats stats) throws IOException {
        Vector interfaces;
        String loaderAddress;
        J9ConstantPool pool;
        J9Class clazz = J9JVMConsole.getClass(current.getObjectAddress());
        if (clazz == null) {
            Console.reportError("Couldn't get class for object " + current.getObjectAddress(), null);
            stats.incrementErrors();
            return;
        }
        LinkedList<Long> references = new LinkedList<Long>();
        Vector statics = clazz.getStatics();
        if (statics != null) {
            for (J9Static thisStatic : statics) {
                String signature = thisStatic.getSignature();
                if (!signature.matches("^\\[*L.*")) continue;
                long address = thisStatic.getValue();
                references.add(new Long(address));
            }
        }
        if ((pool = clazz.getConstantPool()) != null) {
            Iterator constantPoolEntries = pool.getEntries();
            while (constantPoolEntries.hasNext()) {
                J9ConstantPoolEntry thisEntry = (J9ConstantPoolEntry)constantPoolEntries.next();
                Long address = Long.decode(thisEntry.getId());
                references.add(address);
            }
        }
        if (null != (loaderAddress = clazz.getLoader())) {
            J9ClassLoader loader = J9JVMConsole.getClassLoader(loaderAddress);
            if (null != loader) {
                references.add(new Long(loader.getObj()));
            } else {
                Console.reportError("Couldn't get classloader for address " + loaderAddress + " referenced by class " + clazz.getName() + "(" + Long.toHexString(clazz.getClassAddress()) + ")", null);
                stats.incrementErrors();
            }
        } else if (!clazz.isPrimitiveClass() && !clazz.isArrayClass()) {
            Console.reportError("Couldn't get loader address for class: " + clazz.getName() + "(" + Long.toHexString(clazz.getClassAddress()) + ")", null);
            stats.incrementErrors();
        }
        Vector inheritanceChain = clazz.getInheritanceChain();
        for (String thisParentName : inheritanceChain) {
            J9Class parentClass = J9JVMConsole.getClass(thisParentName);
            if (parentClass != null) {
                references.add(new Long(parentClass.getClassAddress()));
                continue;
            }
            Console.reportError("Couldn't get class object while walking inheritance tree. Base class: " + clazz.getName() + "(" + Long.toHexString(clazz.getClassAddress()) + ") - failed parent name: " + thisParentName, null);
            stats.incrementErrors();
        }
        if (clazz.isArrayClass() || clazz.isPrimitiveArray()) {
            references.add(new Long(clazz.getLeaf()));
            references.add(new Long(J9JVMConsole.getClass("java/lang/Object").getClassAddress()));
        }
        String className = clazz.getName();
        if (clazz.isPrimitiveArray()) {
            className = HeapDumpUtil.decodePrimitiveArrayClassName(className, stats);
        }
        if ((interfaces = clazz.getInterfaces()) != null) {
            for (String interfaceName : interfaces) {
                J9Class interfaceClass = J9JVMConsole.getClass(interfaceName);
                references.add(new Long(interfaceClass.getClassAddress()));
            }
        }
        String superClassIdStr = clazz.getSuperId();
        long superClassId = 0L;
        if (superClassIdStr != null) {
            superClassId = Long.decode(superClassIdStr);
        } else if (!(clazz.isPrimitiveClass() || clazz.isArrayClass() || clazz.getName().equals("java/lang/Object"))) {
            Console.reportError("Null superclass returned from class " + clazz.getName() + "(" + Long.toHexString(clazz.getClassAddress()) + ")", null);
            stats.incrementErrors();
        }
        formatter.addClass(clazz.getClassAddress(), className, superClassId, current.getInstanceSize(), clazz.getInstanceSize(), (int)current.getHashCode(), new LongListReferenceIterator(references));
    }

    private static void dumpObjectArray(HeapDumpFormatter formatter, J9Object current, HeapDumpStats stats) throws IOException {
        J9Class arrayClass = current.getClassForObject();
        J9Class elementClass = null;
        J9Class leafClass = J9JVMConsole.getClass(arrayClass.getLeaf());
        if (leafClass == null) {
            Console.reportError("Couldn't get leafClass from arrayClass: " + arrayClass.getName() + "(" + Long.toHexString(arrayClass.getClassAddress()) + ")", null);
            stats.incrementErrors();
            return;
        }
        if (arrayClass.getArity() == 1) {
            elementClass = leafClass;
        } else {
            String elementClassName = "[";
            for (int arity = 1; arity < arrayClass.getArity() - 1; ++arity) {
                elementClassName = elementClassName + "[";
            }
            elementClass = J9JVMConsole.getClass(elementClassName = elementClassName + "L" + leafClass.getName() + ";");
            if (elementClass == null) {
                Console.reportError("Couldn't get elementClass " + elementClassName + " while processing arrayClass: " + arrayClass.getName() + "(" + Long.toHexString(arrayClass.getClassAddress()) + ")", null);
                stats.incrementErrors();
                return;
            }
        }
        LinkedList<Long> references = new LinkedList<Long>();
        long[] directObjReferences = current.getObjectRefs();
        if (directObjReferences != null) {
            for (int i = 0; i != directObjReferences.length; ++i) {
                references.add(new Long(directObjReferences[i]));
            }
        }
        references.add(new Long(arrayClass.getClassAddress()));
        formatter.addObjectArray(current.getObjectAddress(), arrayClass.getClassAddress(), arrayClass.getName(), elementClass.getClassAddress(), elementClass.getName(), current.getInstanceSize(), current.getElementCount(), (int)current.getHashCode(), new LongListReferenceIterator(references));
    }

    private static void dumpPrimitiveArray(HeapDumpFormatter formatter, J9Object current, HeapDumpStats stats) throws IOException {
        if (current.getClassForObject().getArity() == 1) {
            formatter.addPrimitiveArray(current.getObjectAddress(), current.getClassForObject().getClassAddress(), current.getPrimitiveArrayType(), current.getInstanceSize(), (int)current.getHashCode(), current.getElementCount());
        } else {
            J9Class arrayClass = current.getClassForObject();
            String elementClassName = arrayClass.getName().substring(1);
            J9Class elementClass = J9JVMConsole.getClass(elementClassName);
            if (elementClass == null) {
                Console.reportError("Couldn't get elementClass " + elementClassName + " while processing primitive high-arity arrayClass: " + arrayClass.getName() + "(" + Long.toHexString(arrayClass.getClassAddress()) + ")", null);
                stats.incrementErrors();
                return;
            }
            formatter.addObjectArray(current.getObjectAddress(), arrayClass.getClassAddress(), arrayClass.getName(), elementClass.getClassAddress(), elementClass.getName(), current.getInstanceSize(), current.getElementCount(), (int)current.getHashCode(), new LongArrayReferenceIterator(current.getObjectRefs()));
        }
    }
}

