/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.command.BaseCommands;
import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleInput;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleMsg;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Console
implements Observer {
    private static boolean verboseMode = false;
    private static Console mySelf;
    private static int mode;
    private static ConsoleOutput[] output;
    private static ConsoleInput input;
    private static Vector commandList;
    private static String title;
    protected static HashMap cmdConversions;
    private static boolean bTerminate;
    private static boolean bCommandEcho;
    private static boolean bStripdown;
    private static Vector errors;
    private static Properties setProperties;
    private static ArrayList help;
    private static PropertyResourceBundle helpData;
    private static CommandPlugin cp;
    private static Method argsProcessorMethod;

    public Console(String aTitle) {
        title = aTitle;
        mySelf = this;
        try {
            helpData = (PropertyResourceBundle)ResourceBundle.getBundle("com.ibm.jvm.j9.dump.command.CommandHelp");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (null != helpData) {
            Console.addHelp(helpData);
        }
    }

    public static void main(String[] args) {
        new Console("Generic");
        Console.mainLoop();
    }

    public static void mainLoop() {
        Console.commandPreProcessorInit();
        if (mode == 0) {
            Console.setOutput(new ConsoleOutput(), false);
            input = new ConsoleInput();
        }
        BaseCommands baseCommands = new BaseCommands();
        Command[] baseCommandSet = ((CommandPlugin)baseCommands).getCommandSet();
        Console.registerCommandSet(baseCommandSet);
        baseCommands.addObserver(mySelf);
        Console.doOutput("jdmpview " + title);
        if (null != argsProcessorMethod) {
            try {
                argsProcessorMethod.invoke((Object)null, (Object[])null);
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        Console.doOutput("\nReady....('h' shows help, 'cmds' shows available commands)");
        while (!bTerminate) {
            String in = input.getInput();
            Console.handleInput(in, true);
        }
    }

    public static void handleInput(String in, boolean bDoReady) {
        int pos;
        String originalIn = in;
        if (bStripdown) {
            in = Console.stripDown(in);
        }
        if (bCommandEcho) {
            Console.doOutput(in + "\n");
        }
        if (-1 == (pos = Console.findVerbNounCombo(in.toUpperCase()))) {
            Console.doOutput("\" " + in + " \" not recognised as a valid command.");
        }
        String returnFromCommand = null;
        if (-1 != pos) {
            try {
                returnFromCommand = Console.doCommand(pos, in, originalIn);
            }
            catch (Exception e) {
                Console.reportError(" Unexpected/unhandled error in the code involved processing \"" + in + "\"", e);
            }
            if (returnFromCommand != null) {
                Console.doOutput(returnFromCommand);
            }
        }
        if (verboseMode && errors.size() > 0) {
            Console.doOutput("\n\t!!! " + errors.size() + " error(s) were detected whilst processing one or more commands");
            Console.doOutput("\n\tThese errors may require further investigation, XML errors (in particular) may be due to problems");
            Console.doOutput("\tencountered during jextract processing and flagged within the output xml using <error> elements");
            Console.doOutput("\tThe errors are: \n");
            for (int i = 0; i < errors.size(); ++i) {
                Console.doOutput("#" + (i + 1) + ": " + errors.get(i));
            }
            errors.clear();
        }
        if (!bTerminate && bDoReady) {
            String currentAsid = Console.getProperty("ASID");
            String currentProc = Console.getProperty("Proc");
            String apInfo = " ";
            if (null != currentAsid) {
                apInfo = apInfo + " asid:" + currentAsid;
            }
            if (null != currentProc) {
                apInfo = apInfo + " proc:" + currentProc;
            }
            Console.doOutput("\nReady" + apInfo + " ....");
        } else if (bTerminate) {
            cp = new J9JVMBaseCmds();
            cp.cleanUp();
            cp = new DumpBaseCmds();
            String whereTemps = cp.cleanUp();
            if (whereTemps != null && new File(whereTemps).exists()) {
                Console.doOutput("Jdmpview was passed a .zip file on initialization or with the SET DUMP command \nit may be necessary to manually delete the temporary files that have been created.\nThese files can be found at: \n" + whereTemps);
            }
            Console.doOutput("\nQuitting - bye");
        }
    }

    public static boolean registerCommand(Command c) {
        boolean bRet = false;
        int pos = Console.findInCommandList(c.getVerb(), c.getNoun());
        if (-1 == pos) {
            commandList.add(c);
            bRet = true;
        }
        return bRet;
    }

    public static void registerCommandSet(Command[] commandSet) {
        for (int i = 0; i < commandSet.length; ++i) {
            if (null == commandSet[i]) continue;
            Console.registerCommand(commandSet[i]);
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof ConsoleMsg) {
            ConsoleMsg msg = (ConsoleMsg)arg1;
            if (msg.verboseOnly && !verboseMode) {
                return;
            }
        }
        if (arg1 instanceof Vector) {
            Vector v = (Vector)arg1;
            for (int i = 0; i < v.size(); ++i) {
                Object o = v.get(i);
                if (o instanceof Vector) {
                    Vector v1 = (Vector)o;
                    for (int j = 0; j < v1.size(); ++j) {
                        Object o1 = v1.get(j);
                        Console.doOutput(o1.toString());
                    }
                    continue;
                }
                Console.doOutput(o.toString());
            }
        } else {
            Console.doOutput(arg1.toString());
        }
    }

    public static String doCommand(int pos, String input, String origInput) {
        String retString = null;
        Command c = (Command)commandList.elementAt(pos);
        CommandPlugin cp = c.getCommandObject();
        retString = cp.checkCommandValidity(c);
        if (retString == null) {
            retString = cp.go(input, origInput);
        }
        return retString;
    }

    private static int findInCommandList(String verb, String noun) {
        int foundIt = -1;
        for (int i = 0; -1 == foundIt && i < commandList.size(); ++i) {
            Command existingCmd = (Command)commandList.get(i);
            if (existingCmd.getNoun().equals(noun) && existingCmd.getVerb().equals(verb)) {
                foundIt = i;
            }
            if (!noun.equals("*") || !existingCmd.getNoun().equals("") || !existingCmd.getVerb().equals(verb)) continue;
            foundIt = i;
        }
        return foundIt;
    }

    public static int findVerbNounCombo(String input) {
        int pos = -1;
        String verb = null;
        String noun = "*";
        String realVerb = null;
        String realNoun = null;
        StringTokenizer st = new StringTokenizer(input);
        if (st.countTokens() > 0) {
            verb = st.nextToken();
            if (st.countTokens() > 0) {
                noun = st.nextToken();
            }
            realVerb = Console.commandPreProcessor(verb);
            realNoun = Console.commandPreProcessor(noun);
            pos = Console.findInCommandList(realVerb, realNoun);
        }
        if (-1 == pos && !noun.equals("*")) {
            noun = "*";
            pos = Console.findInCommandList(realVerb, noun);
        }
        return pos;
    }

    public static Vector getCommandList() {
        return commandList;
    }

    public static String commandPreProcessor(String input) {
        String retString = input;
        Object o = cmdConversions.get(input.toUpperCase());
        if (o != null) {
            retString = (String)o;
        }
        return retString;
    }

    private static void commandPreProcessorInit() {
        cmdConversions.put("Q", "QUIT");
        cmdConversions.put("?", "HELP");
        cmdConversions.put("H", "HELP");
        cmdConversions.put("DISPLAY", "DIS");
        cmdConversions.put("D", "DIS");
        cmdConversions.put("M", "MEM");
        cmdConversions.put("MEMORY", "MEM");
        cmdConversions.put("EXIT", "QUIT");
        cmdConversions.put("END", "QUIT");
        cmdConversions.put("S", "SET");
        cmdConversions.put("T", "THREAD");
        cmdConversions.put("MD", "METADATA");
        cmdConversions.put("DU", "DUMP");
        cmdConversions.put("O", "OBJECT");
        cmdConversions.put("C", "CLASS");
        cmdConversions.put("CL", "CLASS");
        cmdConversions.put("SYN", "SYNONYMS");
        cmdConversions.put("OUTPUT", "OUT");
        cmdConversions.put("INPUT", "IN");
        cmdConversions.put("A", "ADD");
        cmdConversions.put("SYSTEM", "SYS");
        cmdConversions.put("OBJ", "OBJECT");
        cmdConversions.put("FP", "FINDPTR");
        cmdConversions.put("FINDP", "FINDPTR");
        cmdConversions.put("FN", "FINDNEXT");
        cmdConversions.put("P", "PTR");
        cmdConversions.put("I", "INT");
        cmdConversions.put("L", "LONG");
        cmdConversions.put("W", "WHATIS");
        cmdConversions.put("EXEC", "EX");
        cmdConversions.put("EXECUTE", "EX");
    }

    public void addCmdConversion(String key, String value) {
        cmdConversions.put(key, value);
    }

    public static void quitConsole() {
        bTerminate = true;
    }

    public static ConsoleOutput[] getOutput() {
        return output;
    }

    public static void setOutput(ConsoleOutput output, boolean addIn) {
        if (null == Console.output) {
            Console.output = new ConsoleOutput[1];
            Console.output[0] = output;
            Console.setProperty("out", "*");
        } else if (addIn) {
            ConsoleOutput[] newOutput = new ConsoleOutput[Console.output.length + 1];
            String outputString = "";
            for (int i = 0; i < Console.output.length; ++i) {
                newOutput[i] = Console.output[i];
                outputString = outputString + newOutput[i].getName();
                outputString = outputString + " + ";
            }
            newOutput[newOutput.length - 1] = output;
            outputString = outputString + newOutput[newOutput.length - 1].getName();
            Console.output = newOutput;
            Console.setProperty("out", outputString);
        } else {
            for (int i = 0; i < Console.output.length; ++i) {
                String name = Console.output[i].getName();
                if (name.equals("*")) continue;
                Console.output[i].close();
            }
            Console.output = new ConsoleOutput[1];
            Console.output[0] = null == output ? new ConsoleOutput() : output;
            Console.setProperty("out", Console.output[0].getName());
        }
    }

    public static void setBCommandEcho(boolean b) {
        bCommandEcho = b;
    }

    public static boolean isBCommandEcho() {
        return bCommandEcho;
    }

    protected static void doOutput(Object o) {
        if (null != output) {
            for (int i = 0; i < output.length; ++i) {
                output[i].doOutput(o);
            }
        } else {
            System.err.println(o.toString());
        }
    }

    private static String stripDown(String s) {
        String retString = s;
        if (-1 != retString.indexOf(61)) {
            retString = retString.replace('=', ' ');
        }
        return retString;
    }

    public static Vector getErrors() {
        return errors;
    }

    public static void addError(Object x) {
        errors.add(x);
    }

    public static String setProperty(String key, String value) {
        String retString = null;
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (setProperties.containsKey(key)) {
            String oldValue = setProperties.getProperty(key);
            setProperties.remove(key);
            setProperties.put(key, value);
            retString = "\n " + key + " successfully changed from \"" + oldValue + "\"";
        } else {
            setProperties.put(key, value);
            retString = "\n " + key + " successfully set";
        }
        return retString;
    }

    public static String removeProperty(String key) {
        String retString = "\n " + key + " successfuly removed";
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (setProperties.containsKey(key)) {
            setProperties.remove(key);
        } else {
            retString = "\n " + key + " not found";
        }
        return null;
    }

    public static String getProperty(String key) {
        String retString = null;
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (null == key) {
            Set<Object> s = setProperties.keySet();
            StringBuffer sb = new StringBuffer();
            for (String string : s) {
                String itsValue = (String)setProperties.get(string);
                sb.append("\n" + string + " : " + itsValue);
            }
            retString = sb.toString();
        } else {
            retString = (String)setProperties.get(key);
        }
        return retString;
    }

    public static void reportError(String error, Exception e) {
        block6: {
            if (!verboseMode) {
                return;
            }
            Console.doOutput("\n*** Error Message: " + error + "\n");
            if (null == e) break block6;
            Console.doOutput("\n\tException attached to error:\n");
            if (null != e.getMessage()) {
                Console.doOutput(e.getMessage());
            }
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable realEx = ite.getTargetException();
                Console.doOutput("\t\tInvocationTargetException: really " + realEx.toString());
                Console.doOutput("\n\tStack trace:");
                realEx.fillInStackTrace();
                StackTraceElement[] ste = realEx.getStackTrace();
                for (int i = 0; i < ste.length; ++i) {
                    Console.doOutput("\t\t" + ste[i].toString());
                }
            } else {
                Console.doOutput(e.getClass().getName());
                Console.doOutput("\n\tStack trace:");
                StackTraceElement[] ste = e.getStackTrace();
                for (int i = 0; i < ste.length; ++i) {
                    Console.doOutput("\t\t" + ste[i].toString());
                }
            }
        }
    }

    public void setArgsProcessorMethod(Method method) {
        argsProcessorMethod = method;
    }

    public static HashMap getCmdConversions() {
        return cmdConversions;
    }

    public static void addHelp(PropertyResourceBundle helpData) {
        if (null == help) {
            help = new ArrayList();
        }
        help.add(helpData);
    }

    public static String getHelp(String key) {
        String retString = " No help found for \"" + key + "\"";
        boolean helpFound = false;
        Iterator iter = help.iterator();
        String helpString = null;
        while (iter.hasNext() && !helpFound) {
            PropertyResourceBundle helpData = (PropertyResourceBundle)iter.next();
            helpString = null;
            try {
                helpString = helpData.getString(key);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (null == helpString) continue;
            retString = helpString;
            helpFound = true;
        }
        return retString;
    }

    public static void setVerboseMode(boolean mode) {
        verboseMode = mode;
    }

    public static boolean getVerboseMode() {
        return verboseMode;
    }

    static {
        mode = 0;
        commandList = new Vector();
        title = "Generic";
        cmdConversions = new HashMap();
        bTerminate = false;
        bCommandEcho = false;
        bStripdown = true;
        errors = new Vector();
    }
}

