/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import com.ibm.jvm.j9.dump.systemdump.FlatDumpFile;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class Aixdump
extends Dump {
    static boolean verbose = false;
    private static MemoryRange[] memoryRanges;
    private static int numberOfMemoryRanges;
    private static Aixdump selfref;
    private static Vector debugFiles;
    private static Vector loadedModules;
    static final int S64BIT = 1;
    static final int NGPRS = 32;
    static final int NFPRS = 32;
    static final int RLIM_NLIMITS = 8;
    static final int NSIG = 64;
    static final int NSIG64 = 256;
    static final int MAXCOMLEN = 32;
    private static CoreHeader header;

    public Aixdump(String filename) throws FileNotFoundException {
        super(new FlatDumpFile(filename));
        this.setSystemType(4);
        Aixdump.setLittleEndian(false);
        selfref = this;
        try {
            this.seek(1276L);
            int pi_flags2 = this.readInt();
            this.bIs32Bit = (pi_flags2 & 1) == 0;
            this.seek(0L);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        header = new CoreHeader(this, 0L, true);
        this.fillMemoryRanges();
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("AIXAS", this, 0);
        J9Process proc = new J9Process("AIXProc", 0);
        this.addressSpaces[0].addProcess(proc);
        if (loadedModules.size() != 0) {
            for (int i = 0; i < loadedModules.size(); ++i) {
                AIXLdInfo ld = (AIXLdInfo)loadedModules.get(i);
                proc.addModule(loadedModules.size(), i, ld.filename, ld.textorg, ld.textsize);
            }
        }
    }

    public static Vector findDebugFiles(String name, Dump core, boolean b) {
        return debugFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dumpStat(String fileName) {
        int returnVal = 0;
        if (new File(fileName).exists()) {
            returnVal |= 1;
        } else {
            return returnVal;
        }
        FlatDumpFile file = null;
        try {
            file = new FlatDumpFile(fileName);
        }
        catch (FileNotFoundException e) {
            return returnVal;
        }
        returnVal |= 2;
        try {
            header = new CoreHeader(file, 0L, false);
            try {
                long filesize = file.length();
                if (Aixdump.header.c_fdsinfox > 0L && Aixdump.header.c_loader > 0L && Aixdump.header.c_loader > Aixdump.header.c_fdsinfox && Aixdump.header.c_fdsinfox < filesize && Aixdump.header.c_loader < filesize) {
                    if (verbose) {
                        System.err.println("isSupportedDump: It is an AIX core file");
                    }
                    returnVal |= 4;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnVal;
    }

    private int fillLoaderRegions(MemoryRange[] ranges, int startingFrom) {
        int numRegions = 0;
        long offset = Aixdump.header.c_loader;
        boolean finished = false;
        try {
            while (!finished) {
                long ld_core;
                this.seek(offset);
                int ld_next = this.readInt();
                if (!this.bIs32Bit) {
                    this.readInt();
                }
                if ((ld_core = this.readPtr()) == 0L) {
                    offset += (long)ld_next;
                }
                if (ld_core == 0L) continue;
                if (ranges != null) {
                    long ld_textorg = this.readPtr();
                    long ld_textsize = this.readPtr();
                    long ld_dataorg = this.readPtr();
                    long ld_datasize = this.readPtr();
                    String ld_filename = this.readString();
                    if (debugFiles == null) {
                        debugFiles = new Vector();
                    }
                    AIXLdInfo ld = new AIXLdInfo(offset, ld_textorg, ld_textsize, ld_dataorg, ld_datasize, ld_filename);
                    loadedModules.add(ld);
                    debugFiles.add(ld_filename);
                    ranges[startingFrom + numRegions] = new MemoryRange(ld_dataorg, ld_core, ld_datasize, ld_filename);
                    if (verbose) {
                        System.err.println("fillLoaderRegions: found " + ld_filename);
                    }
                }
                offset += (long)ld_next;
                ++numRegions;
                if (ld_next != 0) continue;
                finished = true;
            }
        }
        catch (Exception e) {
            boolean x = true;
        }
        return numRegions;
    }

    private void fillMemoryRanges() {
        if (Aixdump.header.c_data != 0L) {
            ++numberOfMemoryRanges;
        }
        if (Aixdump.header.c_stack != 0L) {
            ++numberOfMemoryRanges;
        }
        numberOfMemoryRanges = (int)((long)numberOfMemoryRanges + Aixdump.header.c_vmregions);
        numberOfMemoryRanges = (int)((long)numberOfMemoryRanges + Aixdump.header.c_segs);
        MemoryRange[] tempRanges = new MemoryRange[numberOfMemoryRanges += this.fillLoaderRegions(null, 0)];
        int ongoingRangeCount = 0;
        if (Aixdump.header.c_data != 0L) {
            tempRanges[ongoingRangeCount] = new MemoryRange(Aixdump.header.c_dataorg, Aixdump.header.c_data, Aixdump.header.c_datasize, "User data");
            ++ongoingRangeCount;
        }
        try {
            this.seek(Aixdump.header.c_vmm);
            int i = 0;
            while ((long)i < Aixdump.header.c_vmregions) {
                long address = this.readLong();
                long size = this.readLong();
                long offset = this.readLong();
                tempRanges[ongoingRangeCount] = new MemoryRange(address, offset, size, "anonymously mapped area");
                ++ongoingRangeCount;
                ++i;
            }
            boolean SEG_AVAIL = false;
            boolean SEG_SHARED = true;
            int SEG_MAPPED = 2;
            int SEG_MRDWR = 4;
            int SEG_DEFER = 8;
            int SEG_MMAP = 16;
            int SEG_WORKING = 32;
            int SEG_RMMAP = 64;
            int SEG_OTHER = 128;
            int SEG_EXTSHM = 256;
            int SEG_TEXT = 512;
            this.seek(Aixdump.header.c_segregion);
            int i2 = 0;
            while ((long)i2 < Aixdump.header.c_segs) {
                long address = this.readLong();
                long size = this.readLong();
                long offset = this.readLong();
                int segflags = this.readInt();
                int reserved = this.readInt();
                StringBuffer description = new StringBuffer();
                if ((segflags & 0) != 0) {
                    description.append("SEG_AVAIL");
                }
                if ((segflags & 1) != 0) {
                    description.append("SEG_SHARED");
                }
                if ((segflags & 2) != 0) {
                    description.append("SEG_MAPPED");
                }
                if ((segflags & 4) != 0) {
                    description.append("SEG_MRDWR");
                }
                if ((segflags & 8) != 0) {
                    description.append("SEG_DEFER");
                }
                if ((segflags & 0x10) != 0) {
                    description.append("SEG_MMAP");
                }
                if ((segflags & 0x20) != 0) {
                    description.append("SEG_WORKING");
                }
                if ((segflags & 0x40) != 0) {
                    description.append("SEG_RMMAP");
                }
                if ((segflags & 0x80) != 0) {
                    description.append("SEG_OTHER");
                }
                if ((segflags & 0x100) != 0) {
                    description.append("SEG_EXTSHM");
                }
                if ((segflags & 0x200) != 0) {
                    description.append("SEG_TEXT ");
                }
                if (0L != offset) {
                    tempRanges[ongoingRangeCount] = new MemoryRange(address, offset, size, "anonymously mapped area");
                    ++ongoingRangeCount;
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (Aixdump.header.c_stack != 0L) {
            tempRanges[ongoingRangeCount] = new MemoryRange(Aixdump.header.c_stackorg, Aixdump.header.c_stack, Aixdump.header.c_size, "Stack");
            ++ongoingRangeCount;
        }
        if ((ongoingRangeCount += this.fillLoaderRegions(tempRanges, ongoingRangeCount)) < numberOfMemoryRanges) {
            memoryRanges = new MemoryRange[ongoingRangeCount];
            for (int i = 0; i < ongoingRangeCount; ++i) {
                Aixdump.memoryRanges[i] = tempRanges[i];
            }
        } else {
            memoryRanges = tempRanges;
        }
    }

    protected MemoryRange[] getRawMemoryRanges() {
        return memoryRanges;
    }

    public static void main(String[] args) {
    }

    static {
        loadedModules = new Vector();
    }

    class AIXLdInfo {
        long core_offset;
        long textorg;
        long textsize;
        long dataorg;
        long datasize;
        String filename;

        public AIXLdInfo(long offset, long orgtxt, long sizetext, long orgdata, long sizedata, String name) {
            this.core_offset = offset;
            this.textorg = orgtxt;
            this.textsize = sizetext;
            this.dataorg = orgdata;
            this.datasize = sizedata;
            this.filename = name;
        }
    }

    static class CoreHeader {
        static final long FULL_CORE = 1L;
        static final long CORE_VERSION_1 = 2L;
        static final long MSTS_VALID = 4L;
        static final long CORE_BIGDATA = 8L;
        static final long UBLOCK_VALID = 16L;
        static final long USTACK_VALID = 32L;
        static final long LE_VALID = 64L;
        static final long CORE_TRUNC = 128L;
        static final int POWER_RS1 = 1;
        static final int POWER_RSC = 2;
        static final int POWER_RS2 = 4;
        static final int POWER_601 = 8;
        static final int POWER_603 = 32;
        static final int POWER_604 = 16;
        static final int POWER_620 = 64;
        static final int POWER_630 = 128;
        static final int POWER_A35 = 256;
        static final int POWER_RS64II = 512;
        static final int POWER_RS64III = 1024;
        static final int POWER_4 = 2048;
        static final int POWER_MPC7450 = 4096;
        public byte c_signo;
        public byte c_flag;
        public short c_entries;
        public int c_version;
        public long c_fdsinfox;
        public long c_loader;
        public long c_lsize;
        public int c_n_thr;
        public int c_reserved0;
        public long c_thr;
        public long c_segs;
        public long c_segregion;
        public long c_stack;
        public long c_stackorg;
        public long c_size;
        public long c_data;
        public long c_dataorg;
        public long c_datasize;
        public long c_sdorg;
        public long c_sdsize;
        public long c_vmregions;
        public long c_vmm;
        public int c_impl;
        public int c_pad;
        public long c_cprs;
        public long[] c_reserved = new long[7];
        public Thrdctx c_flt;
        public Userx c_u;
        Vector threadVector;

        public CoreHeader(DumpFile dump, long start, boolean fullAnalysis) {
            try {
                dump.seek(start);
                this.c_signo = dump.readByte();
                this.c_flag = dump.readByte();
                if (((long)this.c_flag & 0x80L) != 0L && fullAnalysis) {
                    System.out.println("Core file is truncated\n***This dump will NOT be adequate for problem determination.***");
                }
                this.c_entries = dump.readShort();
                this.c_version = dump.readInt();
                this.c_fdsinfox = dump.readLong();
                this.c_loader = dump.readLong();
                this.c_lsize = dump.readLong();
                this.c_n_thr = dump.readInt();
                this.c_reserved0 = dump.readInt();
                this.c_thr = dump.readLong();
                this.c_segs = dump.readLong();
                this.c_segregion = dump.readLong();
                this.c_stack = dump.readLong();
                this.c_stackorg = dump.readLong();
                this.c_size = dump.readLong();
                this.c_data = dump.readLong();
                this.c_dataorg = dump.readLong();
                this.c_datasize = dump.readLong();
                this.c_sdorg = dump.readLong();
                this.c_sdsize = dump.readLong();
                this.c_vmregions = dump.readLong();
                this.c_vmm = dump.readLong();
                this.c_impl = dump.readInt();
                this.c_pad = dump.readInt();
                this.c_cprs = dump.readLong();
                for (int i = 0; i < this.c_reserved.length; ++i) {
                    this.c_reserved[i] = dump.readLong();
                }
                if (fullAnalysis) {
                    this.c_flt = new Thrdctx(dump, dump.getFilePointer());
                    this.c_u = new Userx(dump, dump.getFilePointer());
                    Vector<Thrdctx> threadVector = new Vector<Thrdctx>();
                    threadVector.add(this.c_flt);
                    if (this.c_n_thr > 0) {
                        this.getThreadData(dump, threadVector);
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        void getThreadData(DumpFile dump, Vector threadVector) throws IOException {
            dump.seek(this.c_thr);
            for (int i = 0; i < this.c_n_thr; ++i) {
            }
        }
    }

    static class Thrdctx {
        long ti_tid;
        long ti_pid;
        long ti_pri;
        long ti_policy;
        long ti_state;
        long ti_flag;
        long ti_scount;
        long ti_wtype;
        long ti_wchan;
        long ti_cpu;
        long ti_cpuid;
        long ti_affinity;
        long ti_sigmask_loset;
        long ti_sigmask_hiset;
        long[] ti_sigmask64 = new long[4];
        long ti_sig_loset;
        long ti_sig_hiset;
        long[] ti_sig64 = new long[4];
        long ti_code;
        long ti_scp;
        long ti_cursig;
        byte[] ti_pad = new byte[7];
        long ti_oldmask_loset;
        long ti_oldmask_hiset;
        long[] ti_oldmask64 = new long[4];
        long ti_stkb;
        long ti_ucontext;
        long ti_sigsp;
        long ti_sigssz;
        long ti_userdata;
        long ti_errnopp;
        long ti_ustk;
        long ti_ticks;
        long ti_dispct;
        long ti_fpuct;
        long ti_watch;
        long[] ti_resvd = new long[7];
        long[] ti_64bit_resvd = new long[8];
        long prev;
        long kjmpbuf;
        long stackfix;
        long intpri;
        long backt;
        byte[] rsvd = new byte[2];
        long curid;
        long excp_type;
        long mq;
        long tid;
        long fpscr;
        long fpeu;
        long fpinfo;
        byte[] pad = new byte[2];
        long[] except = new long[5];
        byte[] pad1 = new byte[4];
        long o_iar;
        long o_toc;
        long o_arg1;
        long excbranch;
        long fpscrx;
        long o_vaddr;
        long[] cachealign = new long[7];
        long alloc;
        long[] srval = new long[16];
        long ti_ru_utime_sec;
        long ti_ru_utime_usec;
        long ti_ru_stime_sec;
        long ti_ru_stime_usec;
        long ti_ru_maxrss;
        long ti_ru_ixrss;
        long ti_ru_idrss;
        long ti_ru_isrss;
        long ti_ru_minflt;
        long ti_ru_majflt;
        long ti_ru_nswap;
        long ti_ru_inblock;
        long ti_ru_oublock;
        long ti_ru_msgsnd;
        long ti_ru_msgrcv;
        long ti_ru_nsignals;
        long ti_ru_nvcsw;
        long ti_ru_nivcsw;
        Vector gpr = new Vector(32);
        Vector fpr = new Vector(32);
        HashMap specials = new HashMap();

        public Thrdctx(DumpFile dump, long start) {
            try {
                if (selfref.bIs32Bit) {
                    this.populate32BitThread();
                } else {
                    this.populate64BitThread();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        private void populate64BitThread() throws IOException {
            int i;
            this.ti_tid = selfref.readLong();
            this.ti_pid = selfref.readLong();
            this.ti_pri = selfref.readLong();
            this.ti_policy = selfref.readLong();
            this.ti_state = selfref.readLong();
            this.ti_flag = selfref.readLong();
            this.ti_scount = selfref.readLong();
            this.ti_wtype = selfref.readLong();
            this.ti_cpu = selfref.readLong();
            this.ti_cpuid = selfref.readInt();
            this.ti_affinity = selfref.readInt();
            selfref.readLong();
            this.ti_wchan = selfref.readLong();
            for (i = 0; i < this.ti_sigmask64.length; ++i) {
                this.ti_sigmask64[i] = selfref.readLong();
            }
            for (i = 0; i < this.ti_sig64.length; ++i) {
                this.ti_sig64[i] = selfref.readLong();
            }
            this.ti_code = selfref.readLong();
            this.ti_scp = selfref.readLong();
            this.ti_cursig = selfref.readByte();
            selfref.read(this.ti_pad);
            for (i = 0; i < this.ti_oldmask64.length; ++i) {
                this.ti_oldmask64[i] = selfref.readLong();
            }
            this.ti_stkb = selfref.readLong();
            this.ti_ucontext = selfref.readLong();
            this.ti_sigsp = selfref.readLong();
            this.ti_sigssz = selfref.readLong();
            this.ti_userdata = selfref.readLong();
            this.ti_errnopp = selfref.readLong();
            this.ti_ustk = selfref.readLong();
            this.ti_ticks = selfref.readLong();
            this.ti_dispct = selfref.readLong();
            this.ti_fpuct = selfref.readLong();
            this.ti_watch = selfref.readLong();
            this.ti_ru_utime_sec = selfref.readLong();
            this.ti_ru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.ti_ru_stime_sec = selfref.readLong();
            this.ti_ru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.ti_ru_maxrss = selfref.readLong();
            this.ti_ru_ixrss = selfref.readLong();
            this.ti_ru_idrss = selfref.readLong();
            this.ti_ru_isrss = selfref.readLong();
            this.ti_ru_minflt = selfref.readLong();
            this.ti_ru_majflt = selfref.readLong();
            this.ti_ru_nswap = selfref.readLong();
            this.ti_ru_inblock = selfref.readLong();
            this.ti_ru_oublock = selfref.readLong();
            this.ti_ru_msgsnd = selfref.readLong();
            this.ti_ru_msgrcv = selfref.readLong();
            this.ti_ru_nsignals = selfref.readLong();
            this.ti_ru_nvcsw = selfref.readLong();
            this.ti_ru_nivcsw = selfref.readLong();
            for (i = 0; i < this.ti_64bit_resvd.length; ++i) {
                this.ti_64bit_resvd[i] = selfref.readLong();
            }
            for (i = 0; i < 32; ++i) {
                this.gpr.add(new Long(selfref.readLong()));
            }
            this.specials.put("msr", new Long(selfref.readLong()));
            this.specials.put("iar", new Long(selfref.readLong()));
            this.specials.put("lr", new Long(selfref.readLong()));
            this.specials.put("ctr", new Long(selfref.readLong()));
            this.specials.put("cr", new Long(selfref.readLong()));
            this.specials.put("xer", new Long(selfref.readLong()));
            this.fpscr = selfref.readLong();
            this.fpscrx = selfref.readLong();
            this.except[1] = selfref.readLong();
            for (i = 0; i < 32; ++i) {
                this.fpr.add(new Long(selfref.readLong()));
            }
            this.fpeu = selfref.readByte();
            this.fpinfo = selfref.readByte();
            selfref.readByte();
            selfref.readByte();
            this.excp_type = selfref.readLong();
        }

        private void populate32BitThread() throws IOException {
            int i;
            this.tid = this.ti_tid = (long)selfref.readInt();
            this.ti_pid = selfref.readInt();
            this.ti_pri = selfref.readInt();
            this.ti_policy = selfref.readInt();
            this.ti_state = selfref.readInt();
            this.ti_flag = selfref.readInt();
            this.ti_scount = selfref.readInt();
            this.ti_wtype = selfref.readInt();
            this.ti_wchan = selfref.readLong();
            this.ti_cpu = selfref.readInt();
            this.ti_cpuid = selfref.readShort();
            this.ti_affinity = selfref.readShort();
            this.ti_sigmask_loset = selfref.readInt();
            this.ti_sigmask_hiset = selfref.readInt();
            this.ti_sig_loset = selfref.readInt();
            this.ti_sig_hiset = selfref.readInt();
            this.ti_code = selfref.readLong();
            this.ti_scp = selfref.readLong();
            this.ti_cursig = selfref.readByte();
            selfref.read(this.ti_pad);
            this.ti_oldmask_loset = selfref.readInt();
            this.ti_oldmask_hiset = selfref.readInt();
            this.ti_stkb = selfref.readLong();
            this.ti_ucontext = selfref.readLong();
            this.ti_sigsp = selfref.readLong();
            this.ti_sigssz = selfref.readLong();
            this.ti_userdata = selfref.readLong();
            this.ti_errnopp = selfref.readLong();
            this.ti_ustk = selfref.readLong();
            this.ti_ticks = selfref.readInt();
            this.ti_dispct = selfref.readInt();
            this.ti_fpuct = selfref.readInt();
            this.ti_watch = selfref.readInt();
            for (i = 0; i < this.ti_resvd.length; ++i) {
                this.ti_resvd[i] = selfref.readInt();
            }
            selfref.readInt();
            this.prev = selfref.readInt();
            this.kjmpbuf = selfref.readInt();
            this.stackfix = selfref.readInt();
            this.intpri = selfref.readByte();
            this.backt = selfref.readByte();
            selfref.read(this.rsvd);
            this.curid = selfref.readInt();
            this.excp_type = selfref.readInt();
            this.specials.put("iar", new Long(selfref.readInt()));
            this.specials.put("msr", new Long(selfref.readInt()));
            this.specials.put("cr", new Long(selfref.readInt()));
            this.specials.put("lr", new Long(selfref.readInt()));
            this.specials.put("ctr", new Long(selfref.readInt()));
            this.specials.put("xer", new Long(selfref.readInt()));
            this.mq = selfref.readInt();
            this.tid = selfref.readInt();
            this.fpscr = selfref.readInt();
            this.fpeu = selfref.readByte();
            this.fpinfo = selfref.readByte();
            selfref.read(this.pad);
            for (i = 0; i < this.except.length; ++i) {
                this.except[i] = selfref.readInt();
            }
            selfref.read(this.pad1);
            this.o_iar = selfref.readInt();
            this.o_toc = selfref.readInt();
            this.o_arg1 = selfref.readInt();
            this.excbranch = selfref.readInt();
            this.fpscrx = selfref.readInt();
            this.o_vaddr = selfref.readInt();
            for (i = 0; i < this.cachealign.length; ++i) {
                this.cachealign[i] = selfref.readInt();
            }
            this.alloc = selfref.readInt();
            for (i = 0; i < 16; ++i) {
                this.srval[i] = selfref.readInt();
            }
            for (i = 0; i < 32; ++i) {
                this.gpr.add(new Long(selfref.readInt()));
            }
            for (i = 0; i < 32; ++i) {
                this.fpr.add(new Long(selfref.readLong()));
            }
        }
    }

    static class Userx {
        private static final int S64BIT = 1;
        long pi_pid;
        long pi_ppid;
        long pi_sid;
        long pi_pgrp;
        long pi_uid;
        long pi_suid;
        long pi_ttyp;
        long pi_ttyd;
        long pi_ttympx;
        long pi_nice;
        long pi_state;
        long pi_flags;
        long pi_flags2;
        long pi_thcount;
        long pi_cpu;
        long pi_pri;
        long pi_adspace;
        long pi_majflt;
        long pi_minflt;
        long pi_repage;
        long pi_size;
        long pi_r1;
        long pi_utime;
        long pi_r2;
        long pi_stime;
        long cr_ref;
        long cr_ruid;
        long cr_uid;
        long cr_suid;
        long cr_luid;
        long cr_acctid;
        long cr_gid;
        long cr_rgid;
        long cr_sgid;
        long cr_ngrps;
        long cr_caps;
        long[] un_groups = new long[32];
        long[] cr_mpriv = new long[2];
        long[] cr_ipriv = new long[2];
        long[] cr_epriv = new long[2];
        long[] cr_bpriv = new long[2];
        long cr_pag;
        long pi_ru_utime_sec;
        long pi_ru_utime_usec;
        long pi_ru_stime_sec;
        long pi_ru_stime_usec;
        long pi_ru_maxrss;
        long pi_ru_ixrss;
        long pi_ru_idrss;
        long pi_ru_isrss;
        long pi_ru_minflt;
        long pi_ru_majflt;
        long pi_ru_nswap;
        long pi_ru_inblock;
        long pi_ru_oublock;
        long pi_ru_msgsnd;
        long pi_ru_msgrcv;
        long pi_ru_nsignals;
        long pi_ru_nvcsw;
        long pi_ru_nivcsw;
        long pi_cru_utime_sec;
        long pi_cru_utime_usec;
        long pi_cru_stime_sec;
        long pi_cru_stime_usec;
        long pi_cru_maxrss;
        long pi_cru_ixrss;
        long pi_cru_idrss;
        long pi_cru_isrss;
        long pi_cru_minflt;
        long pi_cru_majflt;
        long pi_cru_nswap;
        long pi_cru_inblock;
        long pi_cru_oublock;
        long pi_cru_msgsnd;
        long pi_cru_msgrcv;
        long pi_cru_nsignals;
        long pi_cru_nvcsw;
        long pi_cru_nivcsw;
        long pi_ioch;
        long pi_irss;
        long pi_start;
        long[] rlim_cur = new long[8];
        long[] rlim_max = new long[8];
        long pi_cmask;
        long pi_cdir;
        long pi_rdir;
        long pi_maxofile;
        byte[] pi_comm = new byte[33];
        byte[] pi_pad = new byte[7];
        long pi_drss;
        long pi_trss;
        long pi_dvm;
        long pi_prm;
        long pi_tsize;
        long pi_dsize;
        long pi_sdsize;
        long[] pi_signal = new long[64];
        long[] pi_sigflags = new long[64];
        long[] pi_signal64 = new long[256];
        long[] pi_sigflags64 = new long[256];
        long[] pi_ss64 = new long[4];
        long pi_sig_loset;
        long pi_sig_highset;
        long[] pi_resvd = new long[8];
        long pi_chk_utime;
        long pi_chk_stime;

        public Userx(DumpFile dump, long start) {
        }

        private void populate32Bit() throws IOException {
            int i;
            this.pi_pid = selfref.readInt();
            this.pi_ppid = selfref.readInt();
            this.pi_sid = selfref.readInt();
            this.pi_pgrp = selfref.readInt();
            this.pi_uid = selfref.readInt();
            this.pi_suid = selfref.readInt();
            this.pi_ttyp = selfref.readInt();
            this.pi_ttyd = selfref.readInt();
            this.pi_ttympx = selfref.readInt();
            this.pi_nice = selfref.readInt();
            this.pi_state = selfref.readInt();
            this.pi_flags = selfref.readInt();
            this.pi_flags2 = selfref.readInt();
            this.pi_thcount = selfref.readInt();
            this.pi_cpu = selfref.readInt();
            this.pi_pri = selfref.readInt();
            this.pi_adspace = selfref.readInt();
            selfref.readInt();
            this.pi_majflt = selfref.readLong();
            this.pi_minflt = selfref.readLong();
            this.pi_repage = selfref.readLong();
            this.pi_size = selfref.readLong();
            this.pi_r1 = selfref.readInt();
            this.pi_utime = selfref.readInt();
            this.pi_r2 = selfref.readInt();
            this.pi_stime = selfref.readInt();
            this.cr_ref = selfref.readInt();
            this.cr_ruid = selfref.readInt();
            this.cr_uid = selfref.readInt();
            this.cr_suid = selfref.readInt();
            this.cr_luid = selfref.readInt();
            this.cr_acctid = selfref.readInt();
            this.cr_gid = selfref.readInt();
            this.cr_rgid = selfref.readInt();
            this.cr_sgid = selfref.readInt();
            this.cr_ngrps = selfref.readShort();
            this.cr_caps = selfref.readShort();
            for (i = 0; i < this.un_groups.length; ++i) {
                this.un_groups[i] = selfref.readInt();
            }
            for (i = 0; i < this.cr_mpriv.length; ++i) {
                this.cr_mpriv[i] = selfref.readInt();
            }
            for (i = 0; i < this.cr_ipriv.length; ++i) {
                this.cr_ipriv[i] = selfref.readInt();
            }
            for (i = 0; i < this.cr_epriv.length; ++i) {
                this.cr_epriv[i] = selfref.readInt();
            }
            for (i = 0; i < this.cr_bpriv.length; ++i) {
                this.cr_bpriv[i] = selfref.readInt();
            }
            this.cr_pag = selfref.readInt();
            selfref.readInt();
            this.pi_ru_utime_sec = selfref.readInt();
            this.pi_ru_utime_usec = selfref.readInt();
            this.pi_ru_stime_sec = selfref.readInt();
            this.pi_ru_stime_usec = selfref.readInt();
            this.pi_ru_maxrss = selfref.readLong();
            this.pi_ru_ixrss = selfref.readLong();
            this.pi_ru_isrss = selfref.readLong();
            this.pi_ru_minflt = selfref.readLong();
            this.pi_ru_majflt = selfref.readLong();
            this.pi_ru_nswap = selfref.readLong();
            this.pi_ru_inblock = selfref.readLong();
            this.pi_ru_oublock = selfref.readLong();
            this.pi_ru_msgsnd = selfref.readLong();
            this.pi_ru_msgrcv = selfref.readLong();
            this.pi_ru_nsignals = selfref.readLong();
            this.pi_ru_nvcsw = selfref.readLong();
            this.pi_ru_nivcsw = selfref.readLong();
            this.pi_cru_utime_sec = selfref.readInt();
            this.pi_cru_utime_usec = selfref.readInt();
            this.pi_cru_stime_sec = selfref.readInt();
            this.pi_cru_stime_usec = selfref.readInt();
            this.pi_cru_maxrss = selfref.readLong();
            this.pi_cru_ixrss = selfref.readLong();
            this.pi_cru_idrss = selfref.readLong();
            this.pi_cru_isrss = selfref.readLong();
            this.pi_cru_minflt = selfref.readLong();
            this.pi_cru_majflt = selfref.readLong();
            this.pi_cru_nswap = selfref.readLong();
            this.pi_cru_inblock = selfref.readLong();
            this.pi_cru_oublock = selfref.readLong();
            this.pi_cru_msgsnd = selfref.readLong();
            this.pi_cru_msgrcv = selfref.readLong();
            this.pi_cru_nsignals = selfref.readLong();
            this.pi_cru_nvcsw = selfref.readLong();
            this.pi_cru_nivcsw = selfref.readLong();
            this.pi_ioch = selfref.readLong();
            this.pi_irss = selfref.readLong();
            this.pi_start = selfref.readLong();
            for (i = 0; i < 8; ++i) {
                this.rlim_cur[i] = selfref.readLong();
                this.rlim_max[i] = selfref.readLong();
            }
            this.pi_cmask = selfref.readShort();
            selfref.readByte();
            selfref.readByte();
            this.pi_cdir = selfref.readInt();
            this.pi_rdir = selfref.readInt();
            this.pi_maxofile = selfref.readInt();
            selfref.read(this.pi_comm);
            selfref.read(this.pi_pad);
            this.pi_drss = selfref.readLong();
            this.pi_trss = selfref.readLong();
            this.pi_dvm = selfref.readLong();
            this.pi_prm = selfref.readLong();
            this.pi_tsize = selfref.readLong();
            this.pi_dsize = selfref.readLong();
            this.pi_sdsize = selfref.readLong();
            for (i = 0; i < 64; ++i) {
                this.pi_signal[i] = selfref.readLong();
            }
            for (i = 0; i < 64; ++i) {
                this.pi_sigflags[i] = selfref.readByte();
            }
            this.pi_sig_loset = selfref.readInt();
            this.pi_sig_highset = selfref.readInt();
            selfref.read(new byte[72]);
            for (i = 0; i < this.pi_resvd.length; ++i) {
                this.pi_resvd[i] = selfref.readInt();
            }
        }

        void populate64Bit() throws IOException {
            int i;
            this.pi_pid = selfref.readLong();
            this.pi_ppid = selfref.readLong();
            this.pi_sid = selfref.readLong();
            this.pi_pgrp = selfref.readLong();
            this.pi_uid = selfref.readLong();
            this.pi_suid = selfref.readLong();
            this.pi_ttyp = selfref.readLong();
            selfref.readLong();
            this.pi_ttyd = selfref.readLong();
            this.pi_ttympx = selfref.readLong();
            this.pi_nice = selfref.readLong();
            this.pi_state = selfref.readLong();
            this.pi_flags = selfref.readLong();
            this.pi_flags2 = selfref.readLong();
            this.pi_thcount = selfref.readLong();
            this.pi_cpu = selfref.readLong();
            this.pi_pri = selfref.readLong();
            this.pi_maxofile = selfref.readLong();
            this.pi_cdir = selfref.readLong();
            this.pi_rdir = selfref.readLong();
            this.pi_cmask = selfref.readShort();
            selfref.readShort();
            selfref.read(this.pi_comm);
            this.pi_adspace = selfref.readLong();
            this.pi_majflt = selfref.readLong();
            this.pi_minflt = selfref.readLong();
            this.pi_repage = selfref.readLong();
            this.pi_size = selfref.readLong();
            this.pi_utime = selfref.readLong();
            this.pi_stime = selfref.readLong();
            selfref.read(new byte[1024]);
            this.pi_ru_utime_sec = selfref.readLong();
            this.pi_ru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_ru_stime_sec = selfref.readLong();
            this.pi_ru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_ru_maxrss = selfref.readLong();
            this.pi_ru_ixrss = selfref.readLong();
            this.pi_ru_idrss = selfref.readLong();
            this.pi_ru_isrss = selfref.readLong();
            this.pi_ru_minflt = selfref.readLong();
            this.pi_ru_majflt = selfref.readLong();
            this.pi_ru_nswap = selfref.readLong();
            this.pi_ru_inblock = selfref.readLong();
            this.pi_ru_oublock = selfref.readLong();
            this.pi_ru_msgsnd = selfref.readLong();
            this.pi_ru_msgrcv = selfref.readLong();
            this.pi_ru_nsignals = selfref.readLong();
            this.pi_ru_nvcsw = selfref.readLong();
            this.pi_ru_nivcsw = selfref.readLong();
            this.pi_cru_utime_sec = selfref.readLong();
            this.pi_cru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_cru_stime_sec = selfref.readLong();
            this.pi_cru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_cru_maxrss = selfref.readLong();
            this.pi_cru_ixrss = selfref.readLong();
            this.pi_cru_idrss = selfref.readLong();
            this.pi_cru_isrss = selfref.readLong();
            this.pi_cru_minflt = selfref.readLong();
            this.pi_cru_majflt = selfref.readLong();
            this.pi_cru_nswap = selfref.readLong();
            this.pi_cru_inblock = selfref.readLong();
            this.pi_cru_oublock = selfref.readLong();
            this.pi_cru_msgsnd = selfref.readLong();
            this.pi_cru_msgrcv = selfref.readLong();
            this.pi_cru_nsignals = selfref.readLong();
            this.pi_cru_nvcsw = selfref.readLong();
            this.pi_cru_nivcsw = selfref.readLong();
            this.pi_ioch = selfref.readLong();
            this.pi_irss = selfref.readLong();
            this.pi_start = selfref.readLong();
            for (i = 0; i < 8; ++i) {
                this.rlim_cur[i] = selfref.readLong();
                this.rlim_max[i] = selfref.readLong();
            }
            this.pi_drss = selfref.readLong();
            this.pi_trss = selfref.readLong();
            this.pi_dvm = selfref.readLong();
            this.pi_prm = selfref.readLong();
            this.pi_tsize = selfref.readLong();
            this.pi_dsize = selfref.readLong();
            this.pi_sdsize = selfref.readLong();
            for (i = 0; i < 256; ++i) {
                this.pi_signal64[i] = selfref.readLong();
            }
            for (i = 0; i < 256; ++i) {
                this.pi_sigflags64[i] = selfref.readLong();
            }
            for (i = 0; i < 4; ++i) {
                this.pi_ss64[i] = selfref.readLong();
            }
            selfref.read(new byte[72]);
            this.pi_chk_utime = selfref.readLong();
            this.pi_chk_stime = selfref.readLong();
            this.pi_resvd[4] = selfref.readLong();
        }
    }
}

