/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;

public class ClassField {
    static final int ACC_PUBLIC = 1;
    static final int ACC_PRIVATE = 2;
    static final int ACC_PROTECTED = 4;
    static final int ACC_STATIC = 8;
    static final int ACC_FINAL = 16;
    static final int ACC_SYNCHRONIZED = 32;
    static final int ACC_VOLATILE = 64;
    static final int ACC_TRANSIENT = 128;
    static final int ACC_NATIVE = 256;
    static final int ACC_INTERFACE = 512;
    static final int ACC_ABSTRACT = 1024;
    static final int ACC_SUPER = 32;
    static final int ACC_STRICT = 2048;
    static final int T_CLASS = 2;
    static final int T_BOOLEAN = 4;
    static final int T_CHAR = 5;
    static final int T_FLOAT = 6;
    static final int T_DOUBLE = 7;
    static final int T_BYTE = 8;
    static final int T_SHORT = 9;
    static final int T_INT = 10;
    static final int T_LONG = 11;
    private String definingClassId;
    private String fieldName;
    private String signature;
    private int offset;
    private static Dump theDump;
    private static String primativeClassShortForms;
    private int modifiers;

    public ClassField(String classId, String fName, String sig, String sOff, String modifiersIn) {
        this.definingClassId = classId;
        this.fieldName = fName;
        this.signature = sig;
        this.offset = Integer.parseInt(sOff);
        modifiersIn = DumpUtils.stripOff0x(modifiersIn);
        if (modifiersIn.length() == 8) {
            modifiersIn = modifiersIn.substring(1);
        }
        this.modifiers = Integer.parseInt(modifiersIn, 16);
    }

    public String toString() {
        String modString = ClassField.convertModifier(this.modifiers);
        StringBuffer sb = new StringBuffer(this.fieldName + "  modifiers:" + modString + "  sig: " + this.signature + "  offset: " + this.offset);
        if (null != this.definingClassId) {
            sb.append("  (defined in class " + this.definingClassId + ")");
        }
        return sb.toString();
    }

    public Object getObjectFromField(J9Object obj) {
        byte[] objectBytes;
        Object retObj = null;
        char firstCharofSig = this.signature.charAt(0);
        byte[] targetBytes = null;
        boolean temp = false;
        if (null == theDump) {
            theDump = J9JVMConsole.getTheDump();
        }
        if ((objectBytes = obj.getBytes()) == null) {
            return null;
        }
        switch (firstCharofSig) {
            case 'I': 
            case 'Z': {
                targetBytes = this.normalizeTarget(4, this.offset, objectBytes, theDump.isLittleEndian());
                int iValue = this.getIntFromBytes(targetBytes);
                if (firstCharofSig == 'Z') {
                    if (0 == iValue) {
                        retObj = new Boolean(false);
                        break;
                    }
                    retObj = new Boolean(true);
                    break;
                }
                retObj = new Integer(iValue);
                break;
            }
            case 'J': {
                targetBytes = this.normalizeTarget(8, this.offset, objectBytes, theDump.isLittleEndian());
                long lValue = this.getLongFromBytes(targetBytes);
                retObj = new Long(lValue);
                break;
            }
            case 'C': {
                targetBytes = this.normalizeTarget(2, this.offset, objectBytes, theDump.isLittleEndian());
                int i1 = targetBytes[0];
                i1 = i1 << 24 >>> 24;
                int i2 = targetBytes[1];
                i2 = i2 << 24 >>> 24;
                char c = (char)(i1 * 256 + i2);
                retObj = new Character(c);
                break;
            }
            case 'S': {
                targetBytes = this.normalizeTarget(2, this.offset, objectBytes, theDump.isLittleEndian());
                short sValue = this.getShortFromBytes(targetBytes);
                retObj = new Short(sValue);
                break;
            }
            case 'B': {
                byte b = objectBytes[this.offset];
                retObj = new Byte(b);
                break;
            }
            case 'F': {
                targetBytes = this.normalizeTarget(4, this.offset, objectBytes, theDump.isLittleEndian());
                int iValue1 = this.getIntFromBytes(targetBytes);
                Float f = new Float(Float.intBitsToFloat(iValue1));
                retObj = f;
                break;
            }
            case 'D': {
                targetBytes = this.normalizeTarget(8, this.offset, objectBytes, theDump.isLittleEndian());
                long lValue2 = this.getLongFromBytes(targetBytes);
                Double d = new Double(Double.longBitsToDouble(lValue2));
                retObj = d;
                break;
            }
            case 'L': {
                int pointerSize = 8;
                if (theDump.is32bit()) {
                    pointerSize = 4;
                }
                targetBytes = this.normalizeTarget(pointerSize, this.offset, objectBytes, theDump.isLittleEndian());
                long addrOfString = 0L;
                addrOfString = 4 == pointerSize ? (long)this.getIntFromBytes(targetBytes) & 0xFFFFFFFFL : this.getLongFromBytes(targetBytes);
                if (this.signature.equals("Ljava/lang/String;")) {
                    if (addrOfString == 0L) break;
                    retObj = J9JVMUtils.getStringValue(addrOfString, 0);
                    break;
                }
                retObj = null;
            }
        }
        return retObj;
    }

    public String formatField(byte[] objectBytes, boolean bIsLittleEndian, int pointerSize) {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + this.offset + ") " + "fieldName: " + this.fieldName + "  sig: " + this.signature);
        char firstCharofSig = this.signature.charAt(0);
        byte[] targetBytes = null;
        boolean temp = false;
        switch (firstCharofSig) {
            case 'I': 
            case 'Z': {
                targetBytes = this.normalizeTarget(4, this.offset, objectBytes, bIsLittleEndian);
                int iValue = this.getIntFromBytes(targetBytes);
                if (firstCharofSig == 'Z') {
                    if (0 == iValue) {
                        sb.append("  value= FALSE (0x0)");
                        break;
                    }
                    sb.append("  value= TRUE (0x" + Integer.toHexString(iValue) + ")");
                    break;
                }
                sb.append("  value=" + iValue + " (0x" + Integer.toHexString(iValue) + ")");
                break;
            }
            case 'S': {
                targetBytes = this.normalizeTarget(2, this.offset, objectBytes, bIsLittleEndian);
                short sValue = this.getShortFromBytes(targetBytes);
                sb.append("  value=" + sValue + " (0x" + Integer.toHexString(sValue) + ")");
                break;
            }
            case 'J': {
                targetBytes = this.normalizeTarget(8, this.offset, objectBytes, bIsLittleEndian);
                long lValue = this.getLongFromBytes(targetBytes);
                sb.append("  value=" + lValue + " (0x" + Long.toHexString(lValue) + ")");
                break;
            }
            case 'B': {
                byte b;
                byte i = b = objectBytes[this.offset];
                sb.append("  value= " + Byte.toString(b));
                break;
            }
            case 'F': {
                targetBytes = this.normalizeTarget(4, this.offset, objectBytes, bIsLittleEndian);
                int iValue1 = this.getIntFromBytes(targetBytes);
                Float f = new Float(Float.intBitsToFloat(iValue1));
                sb.append("  value= " + f + " (0x" + Integer.toHexString(iValue1) + ")");
                break;
            }
            case 'D': {
                targetBytes = this.normalizeTarget(8, this.offset, objectBytes, bIsLittleEndian);
                long lValue2 = this.getLongFromBytes(targetBytes);
                Double d = new Double(Double.longBitsToDouble(lValue2));
                sb.append("  value= " + d + " (0x" + Long.toHexString(lValue2) + ")");
                break;
            }
            case 'C': {
                targetBytes = this.normalizeTarget(2, this.offset, objectBytes, bIsLittleEndian);
                String c = new String(targetBytes);
                int i1 = targetBytes[0];
                i1 = i1 << 24 >>> 24;
                int i2 = targetBytes[1];
                i2 = i2 << 24 >>> 24;
                sb.append("  value= \"" + DumpUtils.byteToAscii.substring(i2, i2 + 1) + "\" (ascii)   \"" + DumpUtils.byteToEbcdic.substring(i2, i2 + 1) + "\" (ebcdic) ");
                sb.append("   (0x" + DumpUtils.byteToHex.substring(2 * i1, 2 * i1 + 2) + DumpUtils.byteToHex.substring(2 * i2, 2 * i2 + 2) + ")");
                break;
            }
            case '[': {
                boolean isPrimitiveArray = false;
                if (2 == this.signature.length()) {
                    char secondCharofSig = this.signature.charAt(1);
                    int index = primativeClassShortForms.indexOf(secondCharofSig);
                    if (-1 != index) {
                        isPrimitiveArray = true;
                    }
                    sb.append(" Its a primitive array @0x");
                } else {
                    sb.append(" Its a non-primitive array @0x");
                }
                targetBytes = this.normalizeTarget(pointerSize, this.offset, objectBytes, bIsLittleEndian);
                long addrOfReference = 0L;
                addrOfReference = 4 == pointerSize ? (long)this.getIntFromBytes(targetBytes) & 0xFFFFFFFFL : this.getLongFromBytes(targetBytes);
                sb.append(Long.toHexString(addrOfReference));
                break;
            }
            case 'L': {
                targetBytes = this.normalizeTarget(pointerSize, this.offset, objectBytes, bIsLittleEndian);
                long addrOfString = 0L;
                addrOfString = 4 == pointerSize ? (long)this.getIntFromBytes(targetBytes) & 0xFFFFFFFFL : this.getLongFromBytes(targetBytes);
                if (this.signature.equals("Ljava/lang/String;")) {
                    String first20 = null;
                    if (addrOfString == 0L) break;
                    first20 = J9JVMUtils.getStringValue(addrOfString, 20);
                    sb.append("  value= 0x" + Long.toHexString(addrOfString) + " ==> \"" + first20 + "\"");
                    break;
                }
                String refdetail = "";
                J9Object obj = null;
                if (0L != addrOfString) {
                    obj = J9Heap.checkForObject(addrOfString);
                    if (null == obj) {
                        refdetail = refdetail + " !!! Reference 0x" + Long.toHexString(addrOfString) + " is not a known object !!!";
                    } else if (!this.signature.equals("L" + obj.getClassForObject().getName() + ";")) {
                        refdetail = refdetail + " Reference is an instance of " + obj.getClassForObject().getName();
                    }
                }
                sb.append("  value= 0x" + Long.toHexString(addrOfString) + refdetail);
                break;
            }
            default: {
                sb.append("\n formatField method unable to cope with " + firstCharofSig);
            }
        }
        return sb.toString();
    }

    public String getSignature() {
        return this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    private byte[] normalizeTarget(int size, int offset, byte[] objectBytes, boolean isLittleEndian) {
        byte[] retBytes = new byte[size];
        int start = offset;
        int direction = 1;
        int initI = 0;
        if (isLittleEndian) {
            start = offset;
            direction = -1;
            initI = size - 1;
        }
        int i = initI;
        for (int count = 0; count < size; ++count) {
            retBytes[i] = objectBytes[start + count];
            i += direction;
        }
        return retBytes;
    }

    private long getLongFromBytes(byte[] ba) {
        long retLong = 0L;
        int temp = 0;
        for (int i = 0; i < 8; ++i) {
            retLong <<= 8;
            temp = ba[i];
            if (temp < 0) {
                temp += 256;
            }
            retLong += (long)temp;
        }
        return retLong;
    }

    private int getIntFromBytes(byte[] ba) {
        int retint = 0;
        int temp = 0;
        for (int i = 0; i < 4; ++i) {
            retint <<= 8;
            temp = ba[i];
            if (temp < 0) {
                temp += 256;
            }
            retint += temp;
        }
        return retint;
    }

    private short getShortFromBytes(byte[] ba) {
        int tempInt = 0;
        int temp = 0;
        for (int i = 0; i < 2; ++i) {
            tempInt <<= 8;
            temp = ba[i];
            if (temp < 0) {
                temp += 256;
            }
            tempInt += temp;
        }
        return (short)tempInt;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected static String convertModifier(int modifiers) {
        String retString = "";
        if (1 == (modifiers & 1)) {
            retString = retString + " public";
        }
        if (2 == (modifiers & 2)) {
            retString = retString + " private";
        }
        if (4 == (modifiers & 4)) {
            retString = retString + " protected";
        }
        if (8 == (modifiers & 8)) {
            retString = retString + " static";
        }
        if (16 == (modifiers & 0x10)) {
            retString = retString + " final";
        }
        if (128 == (modifiers & 0x80)) {
            retString = retString + " transient";
        }
        if (64 == (modifiers & 0x40)) {
            retString = retString + " volatile";
        }
        if (256 == (modifiers & 0x100)) {
            retString = retString + " native";
        }
        if (512 == (modifiers & 0x200)) {
            retString = retString + " interface";
        }
        if (1024 == (modifiers & 0x400)) {
            retString = retString + " abstract";
        }
        if (32 == (modifiers & 0x20)) {
            retString = retString + " super";
        }
        if (2048 == (modifiers & 0x800)) {
            retString = retString + " strict";
        }
        return retString;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    static {
        primativeClassShortForms = "IJZBSCDF";
    }
}

