/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import com.ibm.recordio.IRandomAccessRecordFile;
import com.ibm.recordio.IRecordFile;
import com.ibm.recordio.RandomAccessRecordFile;
import com.ibm.recordio.RecordFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DatasetDumpFile
implements DumpFile {
    private final IRecordFile _file;
    private final IRandomAccessRecordFile _rafile;
    private final byte[] _recordBuffer;
    private final int _recordLength;
    private int _seekOffset = 0;
    private long _recordNumber = 0L;
    private int _bufferValid = 0;
    private final String _name;

    public DatasetDumpFile(String name) throws FileNotFoundException {
        try {
            this._file = RecordFile.getInstanceOf((String)("//" + name));
            this._rafile = RandomAccessRecordFile.getInstanceOf((IRecordFile)this._file, (String)"r");
            this._recordLength = this._rafile.getRecordLength();
            this._recordBuffer = new byte[this._recordLength];
            this._name = name;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.toString());
        }
        catch (LinkageError e) {
            throw new FileNotFoundException(e.toString());
        }
    }

    public String getDumpName() {
        return this._name;
    }

    public long getFilePointer() throws IOException {
        return this._recordNumber * (long)this._recordLength + (long)this._seekOffset;
    }

    public long length() throws IOException {
        return -1L;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        try {
            this.readFully(b);
            return b[0] & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int sofar = 0;
        while (sofar < length) {
            int nbytes;
            if (this._seekOffset != 0 || length - sofar < this._recordLength) {
                int n = nbytes = this._bufferValid > 0 ? this._bufferValid : this._rafile.read(this._recordBuffer);
                if (nbytes < 0) break;
                if (nbytes < this._seekOffset) {
                    System.err.println("Problem reading record from RAFile. nbytes = " + nbytes + ", seekOffset = " + this._seekOffset);
                    break;
                }
                int tocopy = nbytes - this._seekOffset;
                if (tocopy > length - sofar) {
                    System.arraycopy(this._recordBuffer, this._seekOffset, b, offset + sofar, length - sofar);
                    sofar = length;
                    this._seekOffset += sofar;
                    this._bufferValid = nbytes;
                    continue;
                }
                System.arraycopy(this._recordBuffer, this._seekOffset, b, offset + sofar, tocopy);
                sofar += tocopy;
                ++this._recordNumber;
                this._seekOffset = 0;
                this._bufferValid = 0;
                continue;
            }
            nbytes = this._rafile.read(b, offset + sofar, length - sofar);
            if (nbytes < 0) break;
            ++this._recordNumber;
            sofar += nbytes;
        }
        return sofar;
    }

    public void seek(long pos) throws IOException {
        long newRecordNumber = pos / (long)this._recordLength;
        if (newRecordNumber != this._recordNumber) {
            this._rafile.seek(newRecordNumber);
            this._recordNumber = newRecordNumber;
            this._bufferValid = 0;
        }
        this._seekOffset = (int)pos % this._recordLength;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int read = this.read(b, off, len);
        if (read < len) {
            throw new EORFException(read);
        }
    }

    public int readInt() throws IOException {
        byte[] buffer = new byte[4];
        this.readFully(buffer);
        return (int)(((long)buffer[0] & 0xFFL) << 24 | ((long)buffer[1] & 0xFFL) << 16 | ((long)buffer[2] & 0xFFL) << 8 | (long)buffer[3] & 0xFFL);
    }

    public long readLong() throws IOException {
        byte[] buffer = new byte[8];
        this.readFully(buffer);
        return ((long)buffer[0] & 0xFFL) << 56 | ((long)buffer[1] & 0xFFL) << 48 | ((long)buffer[2] & 0xFFL) << 40 | ((long)buffer[3] & 0xFFL) << 32 | ((long)buffer[4] & 0xFFL) << 24 | ((long)buffer[5] & 0xFFL) << 16 | ((long)buffer[6] & 0xFFL) << 8 | (long)buffer[7] & 0xFFL;
    }

    public short readShort() throws IOException {
        byte[] buffer = new byte[2];
        this.readFully(buffer);
        return (short)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public void close() throws IOException {
        this._rafile.close();
    }

    private static class EORFException
    extends EOFException {
        private static final long serialVersionUID = 1L;
        public int bytesRead;

        public EORFException(int n) {
            this.bytesRead = n;
        }
    }
}

