/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoaderLibrary;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class J9ClassLoader {
    String id;
    long obj;
    Vector libraries = new Vector();
    Vector definedLoadedClasses = new Vector();
    Vector cachedLoadedClasses = new Vector();

    public J9ClassLoader(String id, String obj) {
        this.id = id;
        this.obj = DumpUtils.parseLongHex(DumpUtils.stripOff0x(obj));
        J9JVMConsole.addClassLoader(this);
    }

    public void addLibrary(J9ClassLoaderLibrary lib) {
        this.libraries.add(lib);
    }

    public void addLoadedClass(J9Class cl) {
        this.definedLoadedClasses.add(cl);
    }

    public void addLoadedClass(String id) {
        this.cachedLoadedClasses.add(id);
    }

    public J9ClassLoaderLibrary[] getLibraries() {
        J9ClassLoaderLibrary[] libs = null;
        int numLibs = this.libraries.size();
        if (numLibs > 0) {
            libs = new J9ClassLoaderLibrary[numLibs];
            for (int i = 0; i < numLibs; ++i) {
                libs[i] = (J9ClassLoaderLibrary)this.libraries.get(i);
            }
        }
        return libs;
    }

    public String getId() {
        return this.id;
    }

    public long getObj() {
        return this.obj;
    }

    public static void recordLoadedClasses() {
        Set s = J9JVMConsole.getKnownClassesByName().keySet();
        Iterator it = s.iterator();
        String x = null;
        while (it.hasNext()) {
            x = (String)it.next();
            J9Class j9c = J9JVMConsole.getClass(x);
            String cl = j9c.getLoader();
            if (cl == null) continue;
            J9ClassLoader j9cl = J9JVMConsole.getClassLoader(cl);
            j9cl.addLoadedClass(j9c);
        }
    }

    public Vector getDefinedLoadedClasses() {
        return this.definedLoadedClasses;
    }

    public Vector getCachedLoadedClasses() {
        return this.cachedLoadedClasses;
    }
}

