/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;

public class MemoryRange
implements Comparable {
    public static final String[] printableEBCDIC = new String[]{"40", " ", "F0", "0", "F1", "1", "F2", "2", "F3", "3", "F4", "4", "F5", "5", "F6", "6", "F7", "7", "F8", "8", "F9", "9", "C1", "A", "C2", "B", "C3", "C", "C4", "D", "C5", "E", "C6", "F", "C7", "G", "C8", "H", "C9", "I", "D1", "J", "D2", "K", "D3", "L", "D4", "M", "D5", "N", "D6", "O", "D7", "P", "D8", "Q", "D9", "R", "E2", "S", "E3", "T", "E4", "U", "E5", "V", "E6", "W", "E7", "X", "E8", "Y", "E9", "Z", "81", "a", "82", "b", "83", "c", "84", "d", "85", "e", "86", "f", "87", "g", "88", "h", "89", "i", "91", "j", "92", "k", "93", "l", "94", "m", "95", "n", "96", "o", "97", "p", "98", "q", "99", "r", "A2", "s", "A3", "t", "A4", "u", "A5", "v", "A6", "w", "A7", "x", "A8", "y", "A9", "z"};
    private long vaddr;
    private long fileoffset;
    private long size;
    private int asid;
    private String description;
    private boolean shared = false;
    private boolean readOnly = false;
    private boolean executable = true;

    public MemoryRange(long a, long fo, long s) {
        this.vaddr = a;
        this.fileoffset = fo;
        this.size = s;
        this.asid = 0;
    }

    public MemoryRange(long a, long fo, long s, String desc) {
        this.vaddr = a;
        this.fileoffset = fo;
        this.size = s;
        this.asid = 0;
        this.description = desc;
    }

    public MemoryRange(long a, long fo, long s, int id) {
        this.vaddr = a;
        this.fileoffset = fo;
        this.size = s;
        this.asid = id;
    }

    public MemoryRange() {
    }

    public long getFileoffset() {
        return this.fileoffset;
    }

    public long getSize() {
        return this.size;
    }

    public long getVaddr() {
        return this.vaddr;
    }

    public void setFileoffset(long l) {
        this.fileoffset = l;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setVaddr(long l) {
        this.vaddr = l;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String addrString = Long.toHexString(this.vaddr);
        addrString = DumpUtils.padToPtrSize(addrString);
        sb.append("Addr: 0x" + addrString);
        String sizeString = Long.toString(this.size);
        sizeString = DumpUtils.padWithSpaces(sizeString, 10);
        sb.append("   Size: 0x" + Long.toHexString(this.size) + " (" + this.size + ")");
        sb.append("   File Offset: 0x" + Long.toHexString(this.fileoffset));
        sb.append(" (" + this.fileoffset + ")");
        if (this.asid != 0) {
            String tempASID = Integer.toHexString(this.asid);
            boolean bIsReadable = false;
            StringBuffer sBuff = new StringBuffer("");
            if (8 == tempASID.length()) {
                bIsReadable = true;
                for (int i = 0; i < 8 && bIsReadable; i += 2) {
                    String x = tempASID.substring(i, i + 2);
                    String y = this.isPrintableEbcdic(x);
                    if (null == y) {
                        bIsReadable = false;
                        continue;
                    }
                    sBuff.append(y);
                }
            }
            if (bIsReadable) {
                sb.append("   asid: " + sBuff);
            } else {
                sb.append("   asid: 0x" + Integer.toHexString(this.asid));
            }
        }
        if (this.description != null) {
            sb.append("  \"" + this.description + "\"");
        }
        if (this.shared) {
            sb.append(" SHR ");
        }
        if (this.readOnly) {
            sb.append(" R\\O ");
        }
        if (this.executable) {
            sb.append(" EXE ");
        }
        return sb.toString();
    }

    private String isPrintableEbcdic(String in) {
        in = in.toUpperCase();
        for (int i = 0; i < printableEBCDIC.length; i += 2) {
            if (!in.equals(printableEBCDIC[i])) continue;
            return printableEBCDIC[i + 1];
        }
        return null;
    }

    public int getAsid() {
        return this.asid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isShared() {
        return this.shared;
    }

    public int compareTo(Object o) {
        MemoryRange rhs = (MemoryRange)o;
        if (this.vaddr == rhs.vaddr) {
            return 0;
        }
        if (this.vaddr >= 0L && rhs.vaddr >= 0L || this.vaddr < 0L && rhs.vaddr < 0L) {
            return this.vaddr < rhs.vaddr ? -1 : 1;
        }
        return this.vaddr < rhs.vaddr ? 1 : -1;
    }
}

