/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

public class PageCache {
    protected byte[] bytes;
    protected static final int NO_KEY = -1;
    public int numPages = 16;
    public int pageSize = 262144;
    public int hiUsage = 5;
    public int loUsage = 20;
    protected Page[] pages;
    protected long lruBits = 0L;
    protected int evictTick = 0;
    protected int evictPeriod = 1;
    protected int evictGrowth = 1;
    protected int maxPeriod = 65536;
    protected int maxGrowth = 32;

    protected void initialize() {
        this.pages = new Page[this.numPages];
        this.bytes = new byte[this.numPages * this.pageSize];
        for (int i = 0; i < this.numPages; ++i) {
            this.pages[i] = new Page();
            this.pages[i].slot = i * this.pageSize;
        }
    }

    PageCache() {
        this.initialize();
    }

    PageCache(int _numPages, int _pageSize, double _hiDensity, double _loDensity) {
        this.numPages = _numPages;
        this.pageSize = _pageSize;
        this.hiUsage = (int)(1.0 / _hiDensity);
        this.loUsage = (int)(1.0 / _loDensity);
        this.initialize();
    }

    public Page find(int key, long vaddr, int size) {
        if (size < 0 || size > this.pageSize) {
            return null;
        }
        for (int i = 0; i < this.numPages; ++i) {
            int delta;
            Page p = this.pages[i];
            if (p.key != key || 0 > (delta = (int)(vaddr - p.base)) || delta > p.span - size) continue;
            return p;
        }
        if (this.evictTick++ % this.evictPeriod > 0) {
            return null;
        }
        int index = 0;
        while (index < this.numPages) {
            long lruSite = 1 << index;
            long branch = (this.lruBits ^ 0xFFFFFFFFFFFFFFFFL) & lruSite;
            this.lruBits &= lruSite ^ 0xFFFFFFFFFFFFFFFFL;
            this.lruBits |= branch;
            if (branch == 0L) {
                index += index;
                continue;
            }
            index += index + 1;
        }
        Page lruPage = this.pages[index - this.numPages];
        if (lruPage.used < lruPage.span / this.loUsage && this.evictPeriod < this.maxPeriod) {
            this.evictPeriod += this.evictGrowth;
            this.evictTick = 1;
            if (this.evictGrowth < this.maxGrowth) {
                this.evictGrowth <<= 1;
            }
        }
        lruPage.base = vaddr;
        lruPage.span = 0;
        lruPage.used = 0;
        lruPage.key = -1;
        return lruPage;
    }

    public class Page {
        protected int slot = -1;
        protected long base = 0L;
        protected int span = 0;
        protected int key = -1;
        protected int used = 1;

        public boolean isEmpty() {
            return this.key == -1;
        }

        public void push(int forKey, long vaddr, byte[] buf) {
            System.arraycopy(buf, 0, PageCache.this.bytes, this.slot, buf.length);
            this.base = vaddr;
            this.span = buf.length;
            this.key = forKey;
        }

        public byte[] pull(int forKey, long vaddr, int size) {
            if (this.key != forKey || this.key == -1) {
                return null;
            }
            int delta = (int)(vaddr - this.base);
            if (delta > this.span - size) {
                size = this.span - delta;
            }
            if (size < 0) {
                return null;
            }
            byte[] buf = new byte[size];
            System.arraycopy(PageCache.this.bytes, this.slot + delta, buf, 0, size);
            this.used += size;
            if (this.used >= this.span / PageCache.this.hiUsage && PageCache.this.evictPeriod > 1) {
                PageCache.this.evictPeriod >>>= 1;
                PageCache.this.evictTick = 0;
                PageCache.this.evictGrowth = 1;
            }
            return buf;
        }
    }
}

