/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Symbol;

public class StackFrame {
    long position;
    long retAddr;

    public StackFrame(long stackPosition, long retAddr) {
        this.retAddr = retAddr;
        this.position = stackPosition;
    }

    public long getPosition() {
        return this.position;
    }

    public long getRetAddr() {
        return this.retAddr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(Bp: 0x");
        String ra = Long.toHexString(this.position);
        ra = DumpUtils.padToPtrSize(ra);
        sb.append(ra + ")");
        sb.append("  0x" + DumpUtils.padToPtrSize(Long.toHexString(this.retAddr)));
        String location = Symbol.getSymbolForAddress(this.retAddr);
        if (null != location) {
            sb.append("  <==");
            sb.append(location);
        }
        return sb.toString();
    }
}

