/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import java.lang.management.PlatformLoggingMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanInfo;

public class LoggingMXBeanImpl
extends DynamicMXBeanImpl
implements LoggingMXBean,
PlatformLoggingMXBean {
    private static LoggingMXBeanImpl instance = new LoggingMXBeanImpl();

    LoggingMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.util.logging:type=Logging"));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(LoggingMXBean.class.getName()));
        }
        return this.info;
    }

    static LoggingMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getLoggerLevel(String string) {
        String string2 = null;
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger != null) {
            Level level = logger.getLevel();
            string2 = level != null ? level.getName() : "";
        }
        return string2;
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    @Override
    public String getParentLoggerName(String string) {
        String string2 = null;
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger != null) {
            Logger logger2 = logger.getParent();
            string2 = logger2 != null ? logger2.getName() : "";
        }
        return string2;
    }

    @Override
    public void setLoggerLevel(String string, String string2) {
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger == null) {
            throw new IllegalArgumentException("Unable to find Logger with name " + string);
        }
        Level level = Level.parse(string2);
        logger.setLevel(level);
    }
}

