/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ExtendedOperatingSystem;
import com.ibm.lang.management.GarbageCollectorMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.oti.shared.SharedClassStatistics;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class MemoryMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryMXBean,
NotificationEmitter {
    private NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    private static MemoryMXBeanImpl instance = new MemoryMXBeanImpl();
    private static OperatingSystemMXBean osinstance = ExtendedOperatingSystem.getInstance();
    private List<MemoryManagerMXBean> memoryManagerList = new LinkedList<MemoryManagerMXBean>();

    MemoryMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=Memory"));
        this.createMemoryManagers();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.MemoryMXBean.class.getName()));
        }
        return this.info;
    }

    static MemoryMXBeanImpl getInstance() {
        return instance;
    }

    private native void createMemoryManagers();

    private void createMemoryManagerHelper(String string, int n, boolean bl) {
        if (bl) {
            ObjectName objectName = ManagementUtils.createObjectName("java.lang:type=GarbageCollector", string);
            this.memoryManagerList.add(new GarbageCollectorMXBeanImpl(objectName, string, n, this));
        } else {
            ObjectName objectName = ManagementUtils.createObjectName("java.lang:type=MemoryManager", string);
            this.memoryManagerList.add(new MemoryManagerMXBeanImpl(objectName, string, n, this));
        }
    }

    List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return this.memoryManagerList;
    }

    @Override
    public void gc() {
        System.gc();
    }

    private native MemoryUsage getHeapMemoryUsageImpl();

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        return this.getHeapMemoryUsageImpl();
    }

    private native MemoryUsage getNonHeapMemoryUsageImpl();

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getNonHeapMemoryUsageImpl();
    }

    private native int getObjectPendingFinalizationCountImpl();

    @Override
    public int getObjectPendingFinalizationCount() {
        return this.getObjectPendingFinalizationCountImpl();
    }

    private native boolean isVerboseImpl();

    @Override
    public boolean isVerbose() {
        return this.isVerboseImpl();
    }

    private native void setVerboseImpl(boolean var1);

    @Override
    public void setVerbose(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.setVerboseImpl(bl);
    }

    private native long getMaxHeapSizeLimitImpl();

    @Override
    public long getMaxHeapSizeLimit() {
        return this.getMaxHeapSizeLimitImpl();
    }

    private native long getMaxHeapSizeImpl();

    @Override
    public long getMaxHeapSize() {
        return this.getMaxHeapSizeImpl();
    }

    private native long getMinHeapSizeImpl();

    @Override
    public long getMinHeapSize() {
        return this.getMinHeapSizeImpl();
    }

    private native void setMaxHeapSizeImpl(long var1);

    @Override
    public void setMaxHeapSize(long l) {
        if (!this.isSetMaxHeapSizeSupported()) {
            throw new UnsupportedOperationException();
        }
        if (l < this.getMinHeapSize() || l > this.getMaxHeapSizeLimit()) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.setMaxHeapSizeImpl(l);
    }

    private native boolean isSetMaxHeapSizeSupportedImpl();

    @Override
    public boolean isSetMaxHeapSizeSupported() {
        return this.isSetMaxHeapSizeSupportedImpl();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.notifier.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(notificationListener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Memory Notification");
        return mBeanNotificationInfoArray;
    }

    public void sendNotification(Notification notification) {
        this.notifier.sendNotification(notification);
    }

    @Override
    public long getSharedClassCacheSize() {
        return SharedClassStatistics.maxSizeBytes();
    }

    @Override
    public long getSharedClassCacheFreeSpace() {
        return SharedClassStatistics.freeSpaceBytes();
    }

    @Override
    public String getGCMode() {
        return this.getGCModeImpl();
    }

    public long getUsedPhysicalMemory() {
        return osinstance.getTotalPhysicalMemory() - osinstance.getFreePhysicalMemorySize();
    }

    public long getTotalPhysicalMemory() {
        return osinstance.getTotalPhysicalMemory();
    }

    private native String getGCModeImpl();

    private native long getGCMasterThreadCpuUsedImpl();

    @Override
    public long getGCMasterThreadCpuUsed() {
        return this.getGCMasterThreadCpuUsedImpl();
    }

    private native long getGCSlaveThreadsCpuUsedImpl();

    @Override
    public long getGCSlaveThreadsCpuUsed() {
        return this.getGCSlaveThreadsCpuUsedImpl();
    }

    private native int getMaximumGCThreadsImpl();

    @Override
    public int getMaximumGCThreads() {
        return this.getMaximumGCThreadsImpl();
    }

    private native int getCurrentGCThreadsImpl();

    @Override
    public int getCurrentGCThreads() {
        return this.getCurrentGCThreadsImpl();
    }
}

