/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class MemoryManagerMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryManagerMXBean {
    protected final String name;
    protected final int id;
    private List<MemoryPoolMXBean> managedPoolList;
    private static MemoryManagerMXBeanImpl tempInstance = new MemoryManagerMXBeanImpl();

    MemoryManagerMXBeanImpl(ObjectName objectName, String string, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        super(objectName);
        this.name = string;
        this.id = n;
        this.managedPoolList = new LinkedList<MemoryPoolMXBean>();
        this.createMemoryPools(n, memoryMXBeanImpl);
    }

    MemoryManagerMXBeanImpl() {
        super(null);
        this.id = -1;
        this.name = null;
    }

    static MemoryManagerMXBeanImpl getInstanceFromMgmtUtils() {
        return tempInstance;
    }

    protected void initializeInfo() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(MemoryManagerMXBean.class.getName()));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.initializeInfo();
        }
        return this.info;
    }

    private native void createMemoryPools(int var1, MemoryMXBeanImpl var2);

    private void createMemoryPoolHelper(String string, boolean bl, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        if (bl) {
            this.managedPoolList.add(MemoryPoolMXBeanImpl.getJavaHeapMemoryPoolMXBean(string, n, memoryMXBeanImpl));
        } else {
            this.managedPoolList.add(new MemoryPoolMXBeanImpl(string, MemoryType.NON_HEAP, n, memoryMXBeanImpl));
        }
    }

    List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return this.managedPoolList;
    }

    @Override
    public String[] getMemoryPoolNames() {
        String[] stringArray = new String[this.managedPoolList.size()];
        int n = 0;
        Iterator<MemoryPoolMXBean> iterator = this.managedPoolList.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().getName();
        }
        return stringArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private native boolean isValidImpl();

    @Override
    public boolean isValid() {
        return this.isValidImpl();
    }
}

