/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ExtendedOperatingSystem;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.RuntimeMXBean;
import com.ibm.oti.vm.VM;
import java.lang.management.ManagementPermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanInfo;

public final class RuntimeMXBeanImpl
extends DynamicMXBeanImpl
implements RuntimeMXBean {
    private static RuntimeMXBeanImpl instance = new RuntimeMXBeanImpl();
    private static OperatingSystemMXBean os = ExtendedOperatingSystem.getInstance();

    RuntimeMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=Runtime"));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.RuntimeMXBean.class.getName()));
        }
        return this.info;
    }

    static RuntimeMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getBootClassPath() {
        if (!this.isBootClassPathSupported()) {
            throw new UnsupportedOperationException("VM does not support boot classpath.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    @Override
    public String getManagementSpecVersion() {
        return "1.0";
    }

    private native String getNameImpl();

    @Override
    public String getName() {
        return this.getNameImpl();
    }

    @Override
    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    private native long getStartTimeImpl();

    @Override
    public long getStartTime() {
        return this.getStartTimeImpl();
    }

    private native long getUptimeImpl();

    @Override
    public long getUptime() {
        return this.getUptimeImpl();
    }

    @Override
    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    private native boolean isBootClassPathSupportedImpl();

    @Override
    public boolean isBootClassPathSupported() {
        return this.isBootClassPathSupportedImpl();
    }

    @Override
    public List<String> getInputArguments() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return ManagementUtils.convertStringArrayToList(VM.getVMArgs());
    }

    @Override
    public long getProcessID() {
        return this.getProcessIDImpl();
    }

    private native long getProcessIDImpl();

    @Override
    public double getCPULoad() {
        return os.getSystemLoadAverage();
    }

    @Override
    public double getVMGeneratedCPULoad() {
        return os.getSystemLoadAverage() / (double)os.getAvailableProcessors();
    }

    @Override
    public Map<String, String> getSystemProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

