/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class MemoryUsage {
    private static CompositeType REF_MEM_USG_CTYPE = MemoryUsage.createMemoryUsageCompositeTypeObject();
    private long init;
    private long used;
    private long committed;
    private long max;
    private String TOSTRING_VALUE;

    public MemoryUsage(long l, long l2, long l3, long l4) {
        if (l < -1L) {
            throw new IllegalArgumentException("init argument cannot be less than -1");
        }
        if (l4 < -1L) {
            throw new IllegalArgumentException("max argument cannot be less than -1");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("used argument cannot be less than 0");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("committed argument cannot be less than 0");
        }
        if (l2 > l3) {
            throw new IllegalArgumentException("used value cannot be larger than the committed value");
        }
        if (l4 != -1L && l3 > l4) {
            throw new IllegalArgumentException("committed value cannot be larger than the max value");
        }
        this.init = l;
        this.used = l2;
        this.committed = l3;
        this.max = l4;
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getInit() {
        return this.init;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsed() {
        return this.used;
    }

    public String toString() {
        if (this.TOSTRING_VALUE == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("init = ");
            stringBuilder.append(this.init);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.init);
            stringBuilder.append("used = ");
            stringBuilder.append(this.used);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.used);
            stringBuilder.append("committed = ");
            stringBuilder.append(this.committed);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.committed);
            stringBuilder.append("max = ");
            stringBuilder.append(this.max);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.max);
            this.TOSTRING_VALUE = stringBuilder.toString().trim();
        }
        return this.TOSTRING_VALUE;
    }

    private static void appendSizeInKBytes(StringBuilder stringBuilder, long l) {
        if (l == -1L) {
            stringBuilder.append("(-1K) ");
        } else {
            stringBuilder.append("(" + l / 1024L + "K) ");
        }
    }

    public static MemoryUsage from(CompositeData compositeData) {
        MemoryUsage memoryUsage = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 4);
            String[] stringArray = new String[]{"init", "used", "committed", "max"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.Long", "java.lang.Long"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            long l = (Long)objectArray[0];
            long l2 = (Long)objectArray[1];
            long l3 = (Long)objectArray[2];
            long l4 = (Long)objectArray[3];
            memoryUsage = new MemoryUsage(l, l2, l3, l4);
        }
        return memoryUsage;
    }

    private static void verifyType(CompositeData compositeData) {
        if (!REF_MEM_USG_CTYPE.isValue(compositeData)) {
            throw new IllegalArgumentException("CompositeData object is not of the expected type.");
        }
    }

    private static CompositeType createMemoryUsageCompositeTypeObject() {
        CompositeType compositeType;
        block2: {
            compositeType = null;
            String[] stringArray = new String[]{"init", "used", "committed", "max"};
            String[] stringArray2 = new String[]{"init-desc", "used-desc", "committed-dec", "max-desc"};
            OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
            try {
                compositeType = new CompositeType("MemoryUsageType", "desc", stringArray, stringArray2, openTypeArray);
            }
            catch (OpenDataException openDataException) {
                if (!ManagementUtils.VERBOSE_MODE) break block2;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MemoryUsage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        MemoryUsage memoryUsage = (MemoryUsage)object;
        if (memoryUsage.getInit() != this.getInit()) {
            return false;
        }
        if (memoryUsage.getCommitted() != this.getCommitted()) {
            return false;
        }
        if (memoryUsage.getUsed() != this.getUsed()) {
            return false;
        }
        return memoryUsage.getMax() == this.getMax();
    }

    public int hashCode() {
        return new String(Long.toString(this.getCommitted()) + Long.toString(this.getInit()) + Long.toString(this.getMax()) + Long.toString(this.getUsed())).hashCode();
    }
}

