/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadRecordFlagException;
import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;

final class RecordFactory {
    private RecordFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Record newRecord(InputStream in) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        return RecordFactory.newRecord(in, 0);
    }

    public static Record newRawRecord(InputStream in, int length) throws IllegalArgumentException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (length <= 0) {
            throw new IllegalArgumentException();
        }
        return new RawRecordImpl(ByteSequenceInputStreamFactory.newByteSequenceInputStream().getByteSequence(in, length));
    }

    public static Record newRecord(InputStream in, int length) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        int len;
        Buffer gen_issuerAndSerialNumberHash;
        Buffer gen_subjectPublicKeyInfoHash;
        Buffer gen_subjectNameHash;
        Buffer gen_unsignedCertHash;
        Buffer gen_signatureHash;
        if (in == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        ByteSequenceInputStream bsis = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        RecordFlag recordFlag = RecordFlag.recordFlagFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(s));
        if (recordFlag == null) {
            throw new BadRecordFlagException();
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence recordId = IntableByteSequenceFactory.newIntableByteSequence(s);
        RecordEncoding encoding = RecordEncodingFactory.newRecordEncoding(BufferFactory.newBuffer(in));
        if (encoding == null) {
            return null;
        }
        Buffer label = BufferFactory.newBuffer(in);
        if (label == null) {
            return null;
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence issuerRecordId = IntableByteSequenceFactory.newIntableByteSequence(s);
        try {
            RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
            X509Certificate certificate = (X509Certificate)encoding.getCertificate();
            gen_signatureHash = hashGen.generateCertificateSignatureHash(certificate);
            gen_unsignedCertHash = hashGen.generateTBSCertificateHash(certificate);
            gen_subjectNameHash = hashGen.generateSubjectNameHash(certificate);
            gen_subjectPublicKeyInfoHash = hashGen.generateSubjectPublicKeyInfoHash(certificate);
            gen_issuerAndSerialNumberHash = hashGen.generateIssuerAndSerialNumberHash(certificate);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        int l = recordFlag.length() + recordId.length() + encoding.length() + label.length() + issuerRecordId.length();
        int n = len = length == 0 ? 0 : length - l;
        if (len < 0) {
            throw new IllegalArgumentException("Invalid parameter 'length' value: " + length + "for newRecord");
        }
        if (len > 0) {
            bsis.getByteSequence(in, len);
        }
        int hashLen = gen_signatureHash.length() + gen_unsignedCertHash.length() + gen_subjectNameHash.length() + gen_subjectPublicKeyInfoHash.length() + gen_issuerAndSerialNumberHash.length();
        return new RecordImpl(recordFlag, recordId, encoding, label, issuerRecordId, gen_signatureHash, gen_unsignedCertHash, gen_subjectNameHash, gen_subjectPublicKeyInfoHash, gen_issuerAndSerialNumberHash, len - hashLen);
    }

    private static final class RawRecordImpl
    implements Record {
        private ByteSequence rawRecordSequence;

        RawRecordImpl(ByteSequence rawSequence) {
            this.rawRecordSequence = rawSequence;
        }

        public int length() {
            return this.rawRecordSequence == null ? 0 : this.rawRecordSequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            return this.rawRecordSequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            return this.rawRecordSequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.rawRecordSequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.rawRecordSequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.rawRecordSequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.rawRecordSequence.indexOf(position, b);
        }

        public boolean isEmpty() {
            return this.rawRecordSequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.rawRecordSequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.rawRecordSequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            return this.rawRecordSequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.rawRecordSequence.toBinaryString();
        }

        public String toOctalString() {
            return this.rawRecordSequence.toOctalString();
        }

        public String toHexString() {
            return this.rawRecordSequence.toHexString();
        }

        public RecordFlag getRecordFlag() {
            return null;
        }

        public IntableByteSequence getRecordId() {
            return null;
        }

        public RecordEncoding getEncoding() {
            return null;
        }

        public Buffer getLabel() {
            return null;
        }

        public IntableByteSequence getIssuerRecordId() {
            return null;
        }

        public Buffer getSignatureHash() {
            return null;
        }

        public Buffer getUnsignedCertHash() {
            return null;
        }

        public Buffer getSubjectNameHash() {
            return null;
        }

        public Buffer getSubjectPublicKeyInfoHash() {
            return null;
        }

        public Buffer getIssuerAndSerialNumberHash() {
            return null;
        }

        public ByteSequence expand(int i) {
            if (i > 0) {
                this.rawRecordSequence = this.rawRecordSequence.append(ByteSequenceFactory.newConstantByteSequence((byte)0, i));
            }
            return this.rawRecordSequence;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            return this.rawRecordSequence.get(index);
        }
    }

    private static final class RecordImpl
    implements Record {
        private final RecordFlag recordFlag;
        private final IntableByteSequence recordId;
        private final RecordEncoding encoding;
        private final Buffer label;
        private final IntableByteSequence issuerRecordId;
        private Buffer signatureHash;
        private Buffer unsignedCertHash;
        private Buffer subjectNameHash;
        private Buffer subjectPublicKeyInfoHash;
        private Buffer issuerAndSerialNumberHash;
        private ByteSequence sequence;

        RecordImpl(RecordFlag recordFlag, IntableByteSequence recordId, RecordEncoding encoding, Buffer label, IntableByteSequence issuerRecordId, Buffer gen_signatureHash, Buffer gen_unsignedCertHash, Buffer gen_subjectNameHash, Buffer gen_subjectPublicKeyInfoHash, Buffer gen_issuerAndSerialNumberHash, int length) {
            this.recordFlag = recordFlag;
            this.recordId = recordId;
            this.encoding = encoding;
            this.label = label;
            this.issuerRecordId = issuerRecordId;
            this.signatureHash = gen_signatureHash;
            this.unsignedCertHash = gen_unsignedCertHash;
            this.subjectNameHash = gen_subjectNameHash;
            this.subjectPublicKeyInfoHash = gen_subjectPublicKeyInfoHash;
            this.issuerAndSerialNumberHash = gen_issuerAndSerialNumberHash;
            this.sequence = recordFlag.append(recordId).append(encoding).append(label).append(issuerRecordId).append(gen_signatureHash).append(gen_unsignedCertHash).append(gen_subjectNameHash).append(gen_subjectPublicKeyInfoHash).append(gen_issuerAndSerialNumberHash);
            if (length > 0) {
                this.sequence = this.sequence.append(ByteSequenceFactory.newConstantByteSequence((byte)0, length));
            }
        }

        public RecordFlag getRecordFlag() {
            return this.recordFlag;
        }

        public IntableByteSequence getRecordId() {
            return this.recordId;
        }

        public RecordEncoding getEncoding() {
            return this.encoding;
        }

        public Buffer getLabel() {
            return this.label;
        }

        public IntableByteSequence getIssuerRecordId() {
            return this.issuerRecordId;
        }

        public Buffer getSignatureHash() {
            return this.signatureHash;
        }

        public Buffer getUnsignedCertHash() {
            return this.unsignedCertHash;
        }

        public Buffer getSubjectNameHash() {
            return this.subjectNameHash;
        }

        public Buffer getSubjectPublicKeyInfoHash() {
            return this.subjectPublicKeyInfoHash;
        }

        public Buffer getIssuerAndSerialNumberHash() {
            return this.issuerAndSerialNumberHash;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return this.sequence.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.sequence.hashCode();
        }

        public ByteSequence expand(int i) {
            if (i > 0) {
                this.sequence = this.sequence.append(ByteSequenceFactory.newConstantByteSequence((byte)0, i));
            }
            return this.sequence;
        }
    }
}

