/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.InputStreamCache;
import com.ibm.jvm.packed.OutputStreamCache;
import com.ibm.jvm.packed.PackedConstants;
import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.PackedReader;
import com.ibm.jvm.packed.PackedSerialContext;
import com.ibm.jvm.packed.PackedWriter;
import com.ibm.jvm.packed.ReaderFactory;
import com.ibm.jvm.packed.WriterFactory;
import com.ibm.jvm.packed.reflect.PackedField;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class PackedObjectSupport
implements PackedConstants {
    private static final InputStreamCache inCache = InputStreamCache.getInstance();
    private static final OutputStreamCache outCache = OutputStreamCache.getInstance();

    private PackedObjectSupport() {
    }

    public static void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream) throws IOException {
        PackedSerialContext packedSerialContext;
        long l;
        if (PackedSerialContext.isPacked) {
            l = 0L;
            packedSerialContext = outCache.get(objectOutputStream);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Ctx  not yet writtenll)");
            }
        } else {
            throw new IOException("An attempt to serialize a packed object was made without enabling the support for packed object.");
        }
        l = PackedObjectSupport.computeHash(packedObject.getClass());
        objectOutputStream.writeByte(13);
        objectOutputStream.writeUTF(packedObject.getClass().getName());
        objectOutputStream.writeLong(l);
        PackedObjectSupport.writePackedObject(packedObject, objectOutputStream, packedSerialContext);
    }

    protected static long computeHash(Class<?> clazz) {
        return PackedObjectSupport.computeHashCodeForPackedObject(clazz);
    }

    private static long computeHashCodeForPackedObject(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        int n = 0;
        int n2 = 0;
        try {
            int n3;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != PackedObject.class) {
                long l2 = PackedObjectSupport.computeHashCodeForPackedObject(clazz2);
                dataOutputStream.writeLong(l2);
            }
            PackedField[] packedFieldArray = PackedField.getDeclaredFields((Class)clazz);
            PackedField[] packedFieldArray2 = new PackedField[packedFieldArray.length];
            PackedField[] packedFieldArray3 = new PackedField[packedFieldArray.length];
            for (n3 = 0; n3 < packedFieldArray.length; ++n3) {
                Class clazz3 = packedFieldArray[n3].getType();
                int n4 = packedFieldArray[n3].getModifiers();
                if ((n4 & 8) > 0 || (n4 & 0x80) > 0) continue;
                if (clazz3.isPrimitive()) {
                    packedFieldArray2[n++] = packedFieldArray[n3];
                    continue;
                }
                if (PackedObject.isPackedClass((Class)clazz3)) {
                    long l3 = PackedObjectSupport.computeHashCodeForPackedObject(clazz3);
                    dataOutputStream.writeLong(l3);
                }
                if (!packedFieldArray[n3].isNestedPacked()) {
                    if (clazz3 == PackedObject.class || clazz3 == PackedObject[].class || PackedObject[].class.isAssignableFrom(clazz3)) {
                        packedFieldArray3[n2++] = packedFieldArray[n3];
                        continue;
                    }
                } else {
                    Class clazz4 = clazz3;
                    if (PackedObject.isPackedArray((Class)clazz4)) {
                        if (PackedObject.isMixedPacked((Class)clazz4)) {
                            packedFieldArray3[n2++] = packedFieldArray[n3];
                            continue;
                        }
                        packedFieldArray2[n++] = packedFieldArray[n3];
                        continue;
                    }
                    if (PackedObject.isMixedPacked((Class)clazz4)) {
                        packedFieldArray3[n2++] = packedFieldArray[n3];
                        continue;
                    }
                    packedFieldArray2[n++] = packedFieldArray[n3];
                    continue;
                }
                if (!Object.class.isAssignableFrom(clazz3)) continue;
                packedFieldArray3[n2++] = packedFieldArray[n3];
            }
            dataOutputStream.writeUTF(clazz.getName());
            dataOutputStream.write(n);
            dataOutputStream.write(n2);
            for (n3 = 0; n3 < n; ++n3) {
                dataOutputStream.writeUTF(packedFieldArray2[n3].getName());
                dataOutputStream.writeBytes(packedFieldArray2[n3].getType().getCanonicalName());
                dataOutputStream.writeInt(packedFieldArray2[n3].getModifiers());
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dataOutputStream.writeUTF(packedFieldArray3[n3].getName());
                dataOutputStream.writeBytes(packedFieldArray3[n3].getType().getCanonicalName());
                dataOutputStream.writeInt(packedFieldArray3[n3].getModifiers());
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityException securityException = new SecurityException("EXCEPTION : :" + noSuchAlgorithmException.toString());
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    static void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
        if (packedObject == null) {
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Packed type=(null)");
            }
            objectOutputStream.writeByte(7);
            return;
        }
        int n = packedSerialContext.getLastWrittenOffset(packedObject);
        if (n >= 0) {
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Packed indirection offset=(" + n + ")");
            }
            objectOutputStream.writeByte(8);
            objectOutputStream.writeInt(n);
            return;
        }
        n = packedSerialContext.objectWrite(packedObject);
        PackedWriter packedWriter = WriterFactory.getPackedWriter(packedObject.getClass());
        objectOutputStream.writeByte(packedWriter.getMarkerByte());
        objectOutputStream.writeInt(n);
        packedWriter.writePackedObject(packedObject, objectOutputStream, packedSerialContext);
    }

    public static PackedObject readPackedObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InstantiationException {
        if (PackedSerialContext.isPacked) {
            int n = -1;
            PackedSerialContext packedSerialContext = inCache.get(objectInputStream);
            n = objectInputStream.readByte();
            if (n == 13) {
                packedSerialContext.hashWrite(objectInputStream.readUTF(), objectInputStream.readLong());
            }
            return PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
        }
        throw new IOException("An attempt to de-serialize a packed object was made without enabling the support for packed object.");
    }

    static PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
        byte by = objectInputStream.readByte();
        if (by == 7) {
            return null;
        }
        if (by == 8) {
            int n = objectInputStream.readInt();
            return (PackedObject)packedSerialContext.getPreviouslyReadObject(n);
        }
        int n = objectInputStream.readInt();
        PackedReader packedReader = ReaderFactory.getPackedReader(by);
        PackedObject packedObject = packedReader.readPackedObject(objectInputStream, packedSerialContext);
        packedSerialContext.objectRead(packedObject, n);
        return packedObject;
    }

    public static void resetContext(ObjectOutputStream objectOutputStream) {
        if (PackedSerialContext.isPacked) {
            outCache.clear(objectOutputStream);
        }
    }

    public static void resetContext(ObjectInputStream objectInputStream) {
        if (PackedSerialContext.isPacked) {
            inCache.clear(objectInputStream);
        }
    }
}

