/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.PackedConstants;
import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.PackedObjectSupport;
import com.ibm.jvm.packed.PackedReader;
import com.ibm.jvm.packed.PackedSerialContext;
import com.ibm.jvm.packed.reflect.PackedArray;
import com.ibm.jvm.packed.reflect.PackedField;
import com.ibm.jvm.packed.reflect.PackedUnsafe;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ReaderFactory
implements PackedConstants {
    private static final PackedReader[] readers = new PackedReader[16];
    private static final PackedReader[] nestedFieldreaders = new PackedReader[16];

    ReaderFactory() {
    }

    static PackedReader getPackedReader(byte by) throws IOException {
        if (by < 0 || by >= 16) {
            throw new IOException("Do not know how to read field of type " + by);
        }
        return readers[by];
    }

    public static PackedReader getMixedFieldReader(byte by) throws IOException {
        if (by < 0 || by >= 16) {
            throw new IOException("Do not know how to read field of type " + by);
        }
        return nestedFieldreaders[by];
    }

    public static void compareHash(Class clazz, PackedSerialContext packedSerialContext, ObjectInputStream objectInputStream) throws InvalidClassException {
        long l = packedSerialContext.hashRead(clazz.getName());
        if (l == -1L) {
            return;
        }
        long l2 = PackedObjectSupport.computeHash(clazz);
        if (l2 != l) {
            throw new InvalidClassException("Mismatched serialization UIDs : stream classdesc Hash = " + l2 + ", incompatible local class serialVersionUID = " + l);
        }
    }

    static {
        ReaderFactory.readers[0] = new SimplePackedReader();
        ReaderFactory.readers[1] = new PackedArrayReader();
        ReaderFactory.readers[2] = ReaderFactory.nestedFieldreaders[2] = new MixedPackedReader();
        ReaderFactory.readers[3] = ReaderFactory.nestedFieldreaders[3] = new MixedPackedArrayReader();
        ReaderFactory.readers[4] = ReaderFactory.nestedFieldreaders[4] = new PackedReferenceReader();
        ReaderFactory.readers[5] = ReaderFactory.nestedFieldreaders[5] = new PackedArrayReferenceReader();
        ReaderFactory.readers[6] = ReaderFactory.nestedFieldreaders[6] = new POJOReader();
        ReaderFactory.readers[14] = ReaderFactory.nestedFieldreaders[14] = new InheritPackedReader();
    }

    private static final class PackedArrayReferenceReader
    extends AbstractReader {
        private static final PackedObject EMPTY_ARR = null;

        private PackedArrayReferenceReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            int n = objectInputStream.readInt();
            if (n == -1) {
                return null;
            }
            if (n == 0) {
                return EMPTY_ARR;
            }
            PackedObject[] packedObjectArray = new PackedObject[n];
            for (int i = 0; i < n; ++i) {
                PackedObject packedObject = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
                if (packedObject == null) continue;
            }
            return packedObjectArray[n];
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            Object var5_7;
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            if (n2 == -1) {
                var5_7 = null;
            }
            if (n2 == 0) {
                var5_7 = null;
            }
            PackedObject[] packedObjectArray = new PackedObject[n2];
            packedSerialContext.objectRead(packedObjectArray, n);
            for (int i = 0; i < n2; ++i) {
                packedObjectArray[i] = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
            }
            if (packedObjectArray != null) {
                long l = us.fieldOffset(packedField);
                us.putObject(packedObject, l, (Object)packedObjectArray);
            }
        }
    }

    private static final class MixedPackedArrayReader
    extends AbstractReader {
        private MixedPackedArrayReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws ClassNotFoundException, InstantiationException, IOException {
            return this.readPackedObject(objectInputStream, packedSerialContext, null);
        }

        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext, Class<? extends PackedObject> clazz) throws IOException, ClassNotFoundException, InstantiationException {
            int n = objectInputStream.readInt();
            if (n == -1) {
                return null;
            }
            Class<Object> clazz2 = this.readClassDesc(objectInputStream);
            if (clazz != null) {
                clazz2 = clazz;
            }
            ReaderFactory.compareHash(clazz2, packedSerialContext, objectInputStream);
            PackedObject packedObject = PackedObject.isPackedArray(clazz2) ? PackedArray.newArray(clazz2, (int)n) : PackedArray.newArray((Class)PackedArray.getPackedArrayClass(clazz2), (int)n);
            for (int i = 0; i < n; ++i) {
                PackedObject packedObject2 = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
                PackedArray.setNestedPackedObject((PackedObject)packedObject, (int)i, (PackedObject)packedObject2);
            }
            return packedObject;
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            PackedUnsafe packedUnsafe = PackedUnsafe.getUnsafe();
            int n = packedField.getNestedArrayLength();
            long l = packedUnsafe.fieldOffset(packedField);
            PackedObject packedObject2 = packedUnsafe.getNestedPackedArray(packedObject, l, packedField.getType(), n);
            int n2 = objectInputStream.readInt();
            packedSerialContext.objectRead(packedObject2, n2);
            for (int i = 0; i < n; ++i) {
                PackedObject packedObject3 = PackedArray.getPackedObject((PackedObject)packedObject2, (int)i);
                this.readMixedFields(packedObject3, objectInputStream, packedSerialContext, null);
            }
        }
    }

    private static final class PackedArrayReader
    extends AbstractReader {
        private PackedArrayReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            boolean bl = objectInputStream.readBoolean();
            int n = objectInputStream.readInt();
            if (n == -1) {
                return null;
            }
            Class<?> clazz = this.readClassDesc(objectInputStream);
            if (clazz == null) {
                return null;
            }
            ReaderFactory.compareHash(clazz, packedSerialContext, objectInputStream);
            PackedObject packedObject = null;
            packedObject = bl ? (PackedObject.isPackedArray(clazz) ? PackedArray.newNativeArray(clazz, (int)n) : PackedArray.newNativeArray((Class)PackedArray.getPackedArrayClass(clazz), (int)n, (long)0L)) : (PackedObject.isPackedArray(clazz) ? PackedArray.newArray(clazz, (int)n) : PackedArray.newArray((Class)PackedArray.getPackedArrayClass(clazz), (int)n));
            for (int i = 0; i < n; ++i) {
                PackedObject packedObject2 = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
                PackedArray.setNestedPackedObject((PackedObject)packedObject, (int)i, (PackedObject)packedObject2);
            }
            return packedObject;
        }
    }

    private static final class POJOReader
    extends AbstractReader {
        private POJOReader() {
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException {
            int n = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            packedSerialContext.objectRead(object, n);
            this.setObjectInField(packedObject, packedField, object);
        }
    }

    private static final class PackedReferenceReader
    extends AbstractReader {
        private PackedReferenceReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            PackedObject packedObject = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
            return packedObject;
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            PackedObject packedObject2 = PackedObjectSupport.readPackedObject(objectInputStream, packedSerialContext);
            if (packedObject2 != null) {
                this.setPackedObjectInField(packedField, packedObject, packedObject2);
            }
        }
    }

    private static final class InheritPackedReader
    extends SimplePackedReader {
        private InheritPackedReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            int n = objectInputStream.readByte();
            int n2 = 0;
            Class<?> clazz = this.readClassDesc(objectInputStream);
            if (clazz == null) {
                return null;
            }
            ReaderFactory.compareHash(clazz, packedSerialContext, objectInputStream);
            PackedObject packedObject = PackedObject.newPackedObject(clazz);
            this.readSerializedByteArray(packedObject, objectInputStream);
            for (n2 = 0; n2 < n; ++n2) {
                clazz = this.readClassDesc(objectInputStream);
                this.readMixedFields(packedObject, objectInputStream, packedSerialContext, clazz);
            }
            return packedObject;
        }

        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext, Class<?> clazz) throws IOException, ClassNotFoundException, InstantiationException {
            PackedUnsafe packedUnsafe = PackedUnsafe.getUnsafe();
            long l = packedUnsafe.fieldOffset(packedField);
            clazz = this.readClassDesc(objectInputStream);
            PackedObject packedObject2 = packedUnsafe.getNestedPackedObject(packedObject, l, clazz);
            this.readMixedFields(packedObject2, objectInputStream, packedSerialContext, null);
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            PackedUnsafe packedUnsafe = PackedUnsafe.getUnsafe();
            long l = packedUnsafe.fieldOffset(packedField);
            PackedObject packedObject2 = packedUnsafe.getNestedPackedObject(packedObject, l, packedField.getType());
            int n = objectInputStream.readInt();
            packedSerialContext.objectRead(packedObject2, n);
            this.readMixedFields(packedObject2, objectInputStream, packedSerialContext, null);
        }
    }

    private static final class MixedPackedReader
    extends SimplePackedReader {
        private MixedPackedReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            Class<?> clazz = this.readClassDesc(objectInputStream);
            if (clazz == null) {
                return null;
            }
            ReaderFactory.compareHash(clazz, packedSerialContext, objectInputStream);
            PackedObject packedObject = PackedObject.newPackedObject(clazz);
            this.readSerializedByteArray(packedObject, objectInputStream);
            this.readMixedFields(packedObject, objectInputStream, packedSerialContext, null);
            return packedObject;
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            PackedUnsafe packedUnsafe = PackedUnsafe.getUnsafe();
            long l = packedUnsafe.fieldOffset(packedField);
            PackedObject packedObject2 = packedUnsafe.getNestedPackedObject(packedObject, l, packedField.getType());
            int n = objectInputStream.readInt();
            packedSerialContext.objectRead(packedObject2, n);
            this.readMixedFields(packedObject2, objectInputStream, packedSerialContext, null);
        }
    }

    private static class SimplePackedReader
    extends AbstractReader {
        private SimplePackedReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            boolean bl = objectInputStream.readBoolean();
            Class<?> clazz = this.readClassDesc(objectInputStream);
            if (clazz == null) {
                return null;
            }
            ReaderFactory.compareHash(clazz, packedSerialContext, objectInputStream);
            PackedObject packedObject = null;
            packedObject = bl ? PackedObject.newNativePackedObject(clazz, (long)0L) : PackedObject.newPackedObject(clazz);
            this.readSerializedByteArray(packedObject, objectInputStream);
            return packedObject;
        }
    }

    private static abstract class AbstractReader
    implements PackedReader {
        static final int MAX_BUFFER_SIZE = 1024;
        protected static PackedUnsafe us = PackedUnsafe.getUnsafe();

        private AbstractReader() {
        }

        @Override
        public PackedObject readPackedObject(ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            throw new InternalError("Unsupported operation");
        }

        @Override
        public void readMixedField(PackedObject packedObject, PackedField packedField, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext) throws IOException, ClassNotFoundException, InstantiationException {
            throw new InternalError("Unsupported operation");
        }

        void setObjectInField(PackedObject packedObject, PackedField packedField, Object object) {
            long l = us.fieldOffset(packedField);
            us.putObject(packedObject, l, object);
        }

        void setPackedObjectInField(PackedField packedField, PackedObject packedObject, PackedObject packedObject2) {
            long l = us.fieldOffset(packedField);
            us.putObject(packedObject, l, (Object)packedObject2);
        }

        private String readFieldDesc(ObjectInputStream objectInputStream) throws IOException {
            return objectInputStream.readUTF();
        }

        Class<?> readClassDesc(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            String string = null;
            byte by = objectInputStream.readByte();
            if (by != 11) {
                throw new IOException("Expected class description marker, found " + by);
            }
            string = objectInputStream.readUTF();
            Class<?> clazz = RMIClassLoader.loadClass(null, string, AbstractReader.latestUserDefinedLoader());
            return clazz;
        }

        private static ClassLoader latestUserDefinedLoader() {
            ClassLoader classLoader = null;
            PrivilegedAction<ClassLoader> privilegedAction = new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    String string = "java.io.ObjectInputStream";
                    String string2 = "latestUserDefinedLoader";
                    Method method = null;
                    try {
                        Class<?> clazz = Class.forName(string);
                        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                        if (classLoader2 != null) {
                            clazz = classLoader2.loadClass(string);
                        }
                        if (clazz != null) {
                            method = clazz.getDeclaredMethod(string2, new Class[0]);
                            method.setAccessible(true);
                        }
                        if (method != null) {
                            classLoader = (ClassLoader)method.invoke(null, new Object[0]);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        exception.printStackTrace();
                    }
                    return classLoader;
                }
            };
            classLoader = AccessController.doPrivileged(privilegedAction);
            return classLoader;
        }

        void readSerializedByteArray(PackedObject packedObject, ObjectInputStream objectInputStream) throws IOException {
            byte by = objectInputStream.readByte();
            if (by != 10) {
                throw new IOException("Expected a BYTE_ARRAY tag");
            }
            long l = objectInputStream.readLong();
            byte[] byArray = new byte[l > 1024L ? 1024 : (int)l];
            long l2 = 0L;
            while (l > 0L) {
                int n = l < (long)byArray.length ? (int)l : byArray.length;
                int n2 = objectInputStream.read(byArray, 0, n);
                int n3 = packedObject.readPackedDataFromByteArray(l2, byArray, 0, n2);
                if (n3 < n2) {
                    throw new IOException("Error reading the complete bytes from the buffer");
                }
                l -= (long)n2;
                l2 += (long)n3;
            }
        }

        void readMixedFields(PackedObject packedObject, ObjectInputStream objectInputStream, PackedSerialContext packedSerialContext, Class<?> clazz) throws IOException, ClassNotFoundException, InstantiationException {
            block7: {
                int n = -1;
                Class<?> clazz2 = null;
                while (true) {
                    byte by = objectInputStream.readByte();
                    n = by;
                    if (by == 16) break block7;
                    if (n != 12) break;
                    String string = this.readFieldDesc(objectInputStream);
                    byte by2 = objectInputStream.readByte();
                    PackedField packedField = null;
                    clazz2 = clazz != null ? clazz : packedObject.getClass();
                    try {
                        packedField = PackedField.getDeclaredField(clazz2, (String)string);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new IOException("Unable to deserialize field " + string + " from stream as the local class does not have this field");
                    }
                    catch (SecurityException securityException) {
                        throw new IOException("Unable to deserialize field " + string + " from stream as the local class does not have this field");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IOException("Unable to deserialize field " + string + " from stream as the local class does not have this field");
                    }
                    if (by2 == 7) {
                        this.setObjectInField(packedObject, packedField, null);
                        continue;
                    }
                    if (by2 == 8) {
                        int n2 = objectInputStream.readInt();
                        this.setObjectInField(packedObject, packedField, packedSerialContext.getPreviouslyReadObject(n2));
                        continue;
                    }
                    PackedReader packedReader = ReaderFactory.getMixedFieldReader(by2);
                    if (packedReader == null) continue;
                    packedReader.readMixedField(packedObject, packedField, objectInputStream, packedSerialContext);
                }
                throw new IOException("Unexpected flag make sure the version of the class used for desrialization is same as that used for serialization");
            }
        }
    }
}

