/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net;

import com.ibm.net.SocketKeepAliveParameters;
import java.io.FileDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketAdaptor;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class SocketUtils {
    private static boolean separateIPv6Stack;
    private static final Field fdSocketChannelImplField;
    private static final Field fdServerSocketChannelImplField;
    private static final Field fdSocketImplField;
    private static final Field fd1TwoStacksPlainSocketImplField;
    private static final Field fdFileDescriptorField;
    private static final Field fd2FileDescriptorField;
    private static final Method getImplSocketMethod;
    private static final Method getImplServerSocketMethod;
    private static Class twoStacksPlainSocketImplClass;

    private static native void configureKeepAlive(long var0, int var2, int var3, int var4) throws SocketException;

    public static void configureKeepAlive(Socket socket, SocketKeepAliveParameters socketKeepAliveParameters) throws SocketException {
        long[] lArray;
        for (long l : lArray = SocketUtils.getFileDescriptor(socket)) {
            SocketUtils.configureKeepAlive(l, socketKeepAliveParameters.getIdleTime(), socketKeepAliveParameters.getProbeCount(), socketKeepAliveParameters.getIntervalTime());
        }
    }

    public static long[] getFileDescriptor(SocketChannel socketChannel) {
        long[] lArray = new long[]{-1L};
        if (fdSocketChannelImplField == null) {
            throw new IllegalStateException("Error retrieving socket from " + socketChannel + " (field not found)");
        }
        try {
            FileDescriptor fileDescriptor = (FileDescriptor)fdSocketChannelImplField.get(socketChannel);
            lArray = SocketUtils.getFileDescriptor(fileDescriptor);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socketChannel);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    public static long[] getFileDescriptor(ServerSocketChannel serverSocketChannel) {
        long[] lArray = new long[]{-1L};
        if (fdServerSocketChannelImplField == null) {
            throw new IllegalStateException("Error retrieving socket from " + serverSocketChannel + " (field not found)");
        }
        try {
            FileDescriptor fileDescriptor = (FileDescriptor)fdServerSocketChannelImplField.get(serverSocketChannel);
            lArray = SocketUtils.getFileDescriptor(fileDescriptor);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + serverSocketChannel);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    public static long[] getFileDescriptor(Socket socket) {
        long[] lArray = new long[]{-1L};
        if (socket instanceof SocketAdaptor) {
            return SocketUtils.getFileDescriptor(((SocketAdaptor)socket).getChannel());
        }
        if (getImplSocketMethod == null) {
            throw new IllegalStateException("Error retrieving socket from " + socket + " (method not found)");
        }
        try {
            SocketImpl socketImpl = (SocketImpl)getImplSocketMethod.invoke(socket, new Object[0]);
            lArray = SocketUtils.getFileDescriptor(socketImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socket);
            illegalStateException.initCause(invocationTargetException);
            throw illegalStateException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socket);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    public static long[] getFileDescriptor(ServerSocket serverSocket) {
        long[] lArray = new long[]{-1L};
        if (serverSocket instanceof ServerSocketAdaptor) {
            return SocketUtils.getFileDescriptor(((ServerSocketAdaptor)serverSocket).getChannel());
        }
        if (getImplServerSocketMethod == null) {
            throw new IllegalStateException("Error retrieving socket from " + serverSocket + " (method not found)");
        }
        try {
            SocketImpl socketImpl = (SocketImpl)getImplServerSocketMethod.invoke(serverSocket, new Object[0]);
            lArray = SocketUtils.getFileDescriptor(socketImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + serverSocket);
            illegalStateException.initCause(invocationTargetException);
            throw illegalStateException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + serverSocket);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    private static long[] getFileDescriptor(FileDescriptor fileDescriptor) {
        long[] lArray = new long[separateIPv6Stack ? 2 : 1];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = -1L;
        }
        if (fdFileDescriptorField == null) {
            throw new IllegalStateException("Error retrieving socket from " + fileDescriptor + " (field not found)");
        }
        if (separateIPv6Stack && fd2FileDescriptorField == null) {
            throw new IllegalStateException("Error retrieving socket from " + fileDescriptor + " (field not found)");
        }
        try {
            lArray[0] = fdFileDescriptorField.getInt(fileDescriptor);
            if (separateIPv6Stack) {
                lArray[1] = fd2FileDescriptorField.getInt(fileDescriptor);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + fileDescriptor);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    private static long[] getFileDescriptor(SocketImpl socketImpl) {
        long[] lArray = new long[]{-1L};
        if (fdSocketImplField == null) {
            throw new IllegalStateException("Error retrieving socket from " + socketImpl + " (field not found)");
        }
        try {
            if (separateIPv6Stack && twoStacksPlainSocketImplClass != null && twoStacksPlainSocketImplClass.isInstance(socketImpl)) {
                FileDescriptor fileDescriptor = (FileDescriptor)fdSocketImplField.get(socketImpl);
                FileDescriptor fileDescriptor2 = (FileDescriptor)fd1TwoStacksPlainSocketImplField.get(socketImpl);
                if (fileDescriptor != null && fileDescriptor2 != null) {
                    lArray = SocketUtils.getFileDescriptor(fileDescriptor);
                    long[] lArray2 = SocketUtils.getFileDescriptor(fileDescriptor2);
                    long[] lArray3 = new long[lArray.length + lArray2.length];
                    System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
                    System.arraycopy(lArray2, 0, lArray3, lArray.length, lArray2.length);
                    return lArray3;
                }
                if (fileDescriptor == null && fileDescriptor2 != null) {
                    lArray = SocketUtils.getFileDescriptor(fileDescriptor2);
                } else if (fileDescriptor != null && fileDescriptor2 == null) {
                    lArray = SocketUtils.getFileDescriptor(fileDescriptor);
                }
            } else {
                FileDescriptor fileDescriptor = (FileDescriptor)fdSocketImplField.get(socketImpl);
                lArray = SocketUtils.getFileDescriptor(fileDescriptor);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socketImpl);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return lArray;
    }

    static {
        Field field;
        AnnotatedElement annotatedElement;
        separateIPv6Stack = false;
        twoStacksPlainSocketImplClass = null;
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        Field field2 = null;
        Field field3 = null;
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.startsWith("Windows")) {
            try {
                annotatedElement = Class.forName("sun.nio.ch.Net");
                field = annotatedElement.getDeclaredField("isSecondSocketRequired");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                if (field.getBoolean(null)) {
                    separateIPv6Stack = true;
                    twoStacksPlainSocketImplClass = Class.forName("java.net.TwoStacksPlainSocketImpl");
                    field3 = twoStacksPlainSocketImplClass.getDeclaredField("fd1");
                    field2 = Class.forName("java.io.FileDescriptor").getDeclaredField("fd2");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        fd2FileDescriptorField = field2;
        fd1TwoStacksPlainSocketImplField = field3;
        annotatedElement = null;
        try {
            annotatedElement = Class.forName("sun.nio.ch.SocketChannelImpl").getDeclaredField("fd");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdSocketChannelImplField = annotatedElement;
        field = null;
        try {
            field = Class.forName("sun.nio.ch.ServerSocketChannelImpl").getDeclaredField("fd");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdServerSocketChannelImplField = field;
        Field field4 = null;
        try {
            field4 = Class.forName("java.net.SocketImpl").getDeclaredField("fd");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdSocketImplField = field4;
        Field field5 = null;
        try {
            field5 = Class.forName("java.io.FileDescriptor").getDeclaredField("fd");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdFileDescriptorField = field5;
        Method method = null;
        try {
            method = Class.forName("java.net.Socket").getDeclaredMethod("getImpl", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getImplSocketMethod = method;
        Method method2 = null;
        try {
            method2 = Class.forName("java.net.ServerSocket").getDeclaredMethod("getImpl", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getImplServerSocketMethod = method2;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (fd2FileDescriptorField != null) {
                    fd2FileDescriptorField.setAccessible(true);
                }
                if (fd1TwoStacksPlainSocketImplField != null) {
                    fd1TwoStacksPlainSocketImplField.setAccessible(true);
                }
                if (fdSocketChannelImplField != null) {
                    fdSocketChannelImplField.setAccessible(true);
                }
                if (fdSocketImplField != null) {
                    fdSocketImplField.setAccessible(true);
                }
                if (fdServerSocketChannelImplField != null) {
                    fdServerSocketChannelImplField.setAccessible(true);
                }
                if (fdFileDescriptorField != null) {
                    fdFileDescriptorField.setAccessible(true);
                }
                if (getImplSocketMethod != null) {
                    getImplSocketMethod.setAccessible(true);
                }
                if (getImplServerSocketMethod != null) {
                    getImplServerSocketMethod.setAccessible(true);
                }
                return null;
            }
        });
    }
}

