/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class ClassCache {
    private final ConcurrentHashMap<Key, Object> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<LoaderRef, CacheKey> loaderKeys = new ConcurrentHashMap();
    private final ConcurrentHashMap<LoaderRef, LoaderRef> canonicalLoaderRefs = new ConcurrentHashMap();
    private final ReferenceQueue<Object> staleLoaderRefs = new ReferenceQueue();

    public ClassCache() {
        for (ClassLoader classLoader = ClassLoader.getSystemClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            this.setCanonicalSystemLoaderRef(classLoader);
        }
        this.setCanonicalSystemLoaderRef(null);
        AccessController.doPrivileged(new CreateReaperAction(this, this.staleLoaderRefs)).start();
    }

    private void setCanonicalSystemLoaderRef(ClassLoader classLoader) {
        LoaderRef loaderRef = new LoaderRef(classLoader, this.staleLoaderRefs, true);
        assert (this.canonicalLoaderRefs.put(loaderRef, loaderRef) == null);
    }

    LoaderRef getCanonicalLoaderRef(Object object) {
        LoaderRef loaderRef = new LoaderRef(object, this.staleLoaderRefs);
        LoaderRef loaderRef2 = this.canonicalLoaderRefs.get(loaderRef);
        if (loaderRef2 == null && (loaderRef2 = this.canonicalLoaderRefs.putIfAbsent(loaderRef, loaderRef)) == null) {
            return loaderRef;
        }
        loaderRef.clear();
        return loaderRef2;
    }

    void removeStaleRef(LoaderRef loaderRef) {
        this.canonicalLoaderRefs.remove(loaderRef);
        CacheKey cacheKey = this.loaderKeys.remove(loaderRef);
        while (cacheKey != null) {
            this.cache.remove(cacheKey);
            cacheKey = cacheKey.next;
        }
    }

    void update(CacheKey cacheKey, Class<?> clazz) {
        Object object = LoaderRef.getLoaderObj(clazz.getClassLoader());
        if (!this.getCanonicalLoaderRef((Object)object).isSystem) {
            return;
        }
        Class<?> clazz2 = this.cache.replace(cacheKey, clazz);
        assert (clazz2 instanceof FutureValue) : "Value replaced is of type '" + clazz2.getClass().getName() + "', not of type '" + FutureValue.class.getName() + "'.";
        LoaderRef loaderRef = cacheKey.loaderRef;
        if (!loaderRef.isSystem) {
            cacheKey.next = this.loaderKeys.get(loaderRef);
            if (cacheKey.next == null) {
                cacheKey.next = this.loaderKeys.putIfAbsent(loaderRef, cacheKey);
                if (cacheKey.next == null) {
                    return;
                }
            }
            while (!this.loaderKeys.replace(loaderRef, cacheKey.next, cacheKey)) {
                cacheKey.next = this.loaderKeys.get(loaderRef);
            }
        }
    }

    private Object createEntry(CacheKey cacheKey) {
        FutureValue futureValue = new FutureValue(cacheKey, this);
        Object object = this.cache.putIfAbsent(cacheKey, futureValue);
        if (object == null) {
            object = futureValue;
        }
        return object;
    }

    public Class<?> get(String string, ClassLoader classLoader) throws ClassNotFoundException {
        LookupKey lookupKey = new LookupKey(string, classLoader, this);
        Object object = this.cache.get(lookupKey);
        if (object == null) {
            object = this.createEntry(lookupKey.createCacheKey());
        }
        if (object instanceof FutureValue) {
            return ((FutureValue)object).get();
        }
        return (Class)object;
    }

    private static final class CacheKey
    extends Key {
        public final LoaderRef loaderRef;
        public CacheKey next = null;

        CacheKey(String string, int n, LoaderRef loaderRef) {
            super(string, n);
            this.loaderRef = loaderRef;
        }

        @Override
        Object getLoaderObj() {
            return this.loaderRef.get();
        }
    }

    private static final class LookupKey
    extends Key {
        private final Object loaderObj;
        private final ClassCache cache;

        private static int hashCode(String string, ClassLoader classLoader) {
            int n = string.hashCode();
            if (classLoader != null) {
                n += classLoader.getClass().getName().hashCode() + System.identityHashCode(classLoader);
            }
            return n;
        }

        public LookupKey(String string, ClassLoader classLoader, ClassCache classCache) {
            super(Objects.requireNonNull(string), LookupKey.hashCode(string, classLoader));
            this.loaderObj = LoaderRef.getLoaderObj(classLoader);
            this.cache = classCache;
        }

        @Override
        Object getLoaderObj() {
            return this.loaderObj;
        }

        CacheKey createCacheKey() {
            return new CacheKey(this.className, this.hashcode, this.cache.getCanonicalLoaderRef(this.loaderObj));
        }
    }

    private static abstract class Key {
        public final String className;
        protected final int hashcode;

        protected Key(String string, int n) {
            this.className = string;
            this.hashcode = n;
        }

        abstract Object getLoaderObj();

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            Object object2 = this.getLoaderObj();
            return this.className.equals(key.className) && object2 != null && object2 == key.getLoaderObj();
        }

        public final int hashCode() {
            return this.hashcode;
        }
    }

    private static class LoaderRef
    extends WeakReference<Object> {
        private static final String NULL_LOADER = new String("");
        private final int hashcode;
        public final boolean isSystem;

        static Object getLoaderObj(ClassLoader classLoader) {
            return classLoader == null ? NULL_LOADER : classLoader;
        }

        LoaderRef(Object object, ReferenceQueue<Object> referenceQueue) {
            this(false, Objects.requireNonNull(object), referenceQueue);
        }

        LoaderRef(ClassLoader classLoader, ReferenceQueue<Object> referenceQueue, boolean bl) {
            this(bl, LoaderRef.getLoaderObj(classLoader), referenceQueue);
        }

        private LoaderRef(boolean bl, Object object, ReferenceQueue<Object> referenceQueue) {
            super(object, referenceQueue);
            String string = object == NULL_LOADER ? NULL_LOADER : object.getClass().getName();
            this.hashcode = string.hashCode() + System.identityHashCode(object);
            this.isSystem = bl;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LoaderRef)) {
                return false;
            }
            Object t = this.get();
            return t != null && t == ((LoaderRef)object).get();
        }

        public final int hashCode() {
            return this.hashcode;
        }

        ClassLoader getActiveLoader() {
            Object t = Objects.requireNonNull(this.get());
            return t == NULL_LOADER ? null : (ClassLoader)t;
        }
    }

    private static final class Reaper
    extends Thread {
        private final WeakReference<ClassCache> cacheRef;
        private final ReferenceQueue<Object> queue;

        Reaper(ClassCache classCache, ReferenceQueue<Object> referenceQueue) {
            super("ClassCache Reaper");
            this.queue = referenceQueue;
            this.cacheRef = new WeakReference<Object>(classCache, referenceQueue);
            this.setDaemon(true);
            this.setContextClassLoader(null);
        }

        @Override
        public void run() {
            Reference<Object> reference = null;
            while (true) {
                try {
                    while ((reference = this.queue.remove()) != this.cacheRef) {
                        this.processStaleRef((LoaderRef)reference);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processStaleRef(LoaderRef loaderRef) {
            ClassCache classCache = (ClassCache)this.cacheRef.get();
            if (classCache == null) {
                return;
            }
            classCache.removeStaleRef(loaderRef);
        }
    }

    private static final class CreateReaperAction
    implements PrivilegedAction<Thread> {
        private final ClassCache cache;
        private final ReferenceQueue<Object> queue;

        CreateReaperAction(ClassCache classCache, ReferenceQueue<Object> referenceQueue) {
            this.cache = classCache;
            this.queue = referenceQueue;
        }

        @Override
        public Thread run() {
            return new Reaper(this.cache, this.queue);
        }
    }

    private static final class FutureValue {
        private final CacheKey key;
        private final LoaderRef loaderRef;
        private final ClassCache cache;
        private Class<?> value = null;

        FutureValue(CacheKey cacheKey, ClassCache classCache) {
            this.key = cacheKey;
            this.loaderRef = cacheKey.loaderRef;
            this.cache = classCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Class<?> get() throws ClassNotFoundException {
            FutureValue futureValue = this;
            synchronized (futureValue) {
                if (this.value != null) {
                    return this.value;
                }
                this.value = Class.forName(this.key.className, false, this.loaderRef.getActiveLoader());
            }
            if (this.value != null) {
                this.cache.update(this.key, this.value);
            }
            return this.value;
        }
    }
}

