/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.SelectableChannel;
import sun.misc.SharedSecrets;
import sun.nio.ch.Interruptible;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private final Object closeLock = new Object();
    private volatile boolean open = true;
    private Interruptible interruptor;
    private volatile Thread interrupted;

    protected AbstractInterruptibleChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseChannel();
        }
    }

    protected abstract void implCloseChannel() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void interrupt(Thread thread) {
                    Object object = AbstractInterruptibleChannel.this.closeLock;
                    synchronized (object) {
                        if (!AbstractInterruptibleChannel.this.open) {
                            return;
                        }
                        AbstractInterruptibleChannel.this.open = false;
                        AbstractInterruptibleChannel.this.interrupted = thread;
                        try {
                            AbstractInterruptibleChannel.this.implCloseChannel();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (this instanceof SelectableChannel && !((SelectableChannel)this).isBlocking()) {
            return;
        }
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            this.interruptor.interrupt(thread);
        }
    }

    protected final void end(boolean bl) throws AsynchronousCloseException {
        AbstractInterruptibleChannel.blockedOn(null);
        Thread thread = this.interrupted;
        if (thread != null && thread == Thread.currentThread()) {
            thread = null;
            throw new ClosedByInterruptException();
        }
        if (!bl && !this.open) {
            throw new AsynchronousCloseException();
        }
    }

    static void blockedOn(Interruptible interruptible) {
        SharedSecrets.getJavaLangAccess().blockedOn(Thread.currentThread(), interruptible);
    }
}

