/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import sun.awt.EmbeddedFrame;

class KeyboardManager {
    static KeyboardManager currentManager = new KeyboardManager();
    Hashtable<Container, Hashtable> containerMap = new Hashtable();
    Hashtable<ComponentKeyStrokePair, Container> componentKeyStrokeMap = new Hashtable();

    KeyboardManager() {
    }

    public static KeyboardManager getCurrentManager() {
        return currentManager;
    }

    public static void setCurrentManager(KeyboardManager keyboardManager) {
        currentManager = keyboardManager;
    }

    public void registerKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        Object v;
        Container container = KeyboardManager.getTopAncestor(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((v = hashtable.get(keyStroke)) == null) {
            hashtable.put(keyStroke, jComponent);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            if (!vector.contains(jComponent)) {
                vector.addElement(jComponent);
            }
        } else if (v instanceof JComponent) {
            if (v != jComponent) {
                Vector<JComponent> vector = new Vector<JComponent>();
                vector.addElement((JComponent)v);
                vector.addElement(jComponent);
                hashtable.put(keyStroke, vector);
            }
        } else {
            System.out.println("Unexpected condition in registerKeyStroke");
            Thread.dumpStack();
        }
        this.componentKeyStrokeMap.put(new ComponentKeyStrokePair(jComponent, keyStroke), container);
        if (container instanceof EmbeddedFrame) {
            ((EmbeddedFrame)container).registerAccelerator(keyStroke);
        }
    }

    private static Container getTopAncestor(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if ((!(container instanceof Window) || !((Window)container).isFocusableWindow()) && !(container instanceof Applet) && !(container instanceof JInternalFrame)) continue;
            return container;
        }
        return null;
    }

    public void unregisterKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        ComponentKeyStrokePair componentKeyStrokePair = new ComponentKeyStrokePair(jComponent, keyStroke);
        Container container = this.componentKeyStrokeMap.get(componentKeyStrokePair);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            Thread.dumpStack();
            return;
        }
        Object v = hashtable.get(keyStroke);
        if (v == null) {
            Thread.dumpStack();
            return;
        }
        if (v instanceof JComponent && v == jComponent) {
            hashtable.remove(keyStroke);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            vector.removeElement(jComponent);
            if (vector.isEmpty()) {
                hashtable.remove(keyStroke);
            }
        }
        if (hashtable.isEmpty()) {
            this.containerMap.remove(container);
        }
        this.componentKeyStrokeMap.remove(componentKeyStrokePair);
        if (container instanceof EmbeddedFrame) {
            ((EmbeddedFrame)container).unregisterAccelerator(keyStroke);
        }
    }

    public boolean fireKeyboardAction(KeyEvent keyEvent, boolean bl, Container container) {
        Object object;
        Serializable serializable;
        Vector vector;
        KeyStroke keyStroke;
        if (keyEvent.isConsumed()) {
            System.out.println("Aquired pre-used event!");
            Thread.dumpStack();
        }
        KeyStroke keyStroke2 = null;
        if (keyEvent.getID() == 400) {
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
        } else {
            if (keyEvent.getKeyCode() != keyEvent.getExtendedKeyCode()) {
                keyStroke2 = KeyStroke.getKeyStroke(keyEvent.getExtendedKeyCode(), keyEvent.getModifiers(), !bl);
            }
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl);
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable != null) {
            vector = null;
            if (keyStroke2 != null && (vector = (Vector)hashtable.get(keyStroke2)) != null) {
                keyStroke = keyStroke2;
            }
            if (vector == null) {
                vector = (Vector)hashtable.get(keyStroke);
            }
            if (vector != null) {
                if (vector instanceof JComponent) {
                    serializable = (JComponent)((Object)vector);
                    if (((Component)serializable).isShowing() && ((Component)serializable).isEnabled()) {
                        this.fireBinding((JComponent)serializable, keyStroke, keyEvent, bl);
                    }
                } else if (vector instanceof Vector) {
                    int n;
                    serializable = vector;
                    object = new int[serializable.size()];
                    for (int i = 0; i < serializable.size(); ++i) {
                        Component component = (Component)serializable.elementAt(i);
                        if (!(component instanceof JLabel)) continue;
                        JLabel jLabel = (JLabel)component;
                        for (n = 0; n < serializable.size(); ++n) {
                            if (serializable.elementAt(n) != jLabel.getLabelFor()) continue;
                            object[n] = true;
                        }
                    }
                    Vector vector2 = new Vector(8);
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (object[i] != false) continue;
                        vector2.add(serializable.elementAt(i));
                    }
                    serializable = vector2;
                    if ((keyEvent.getModifiers() & 8) == 8) {
                        JComponent jComponent;
                        JComponent jComponent2;
                        int n2;
                        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        int n3 = 0;
                        n = 0;
                        for (n2 = 0; n2 < serializable.size(); ++n2) {
                            jComponent2 = (JComponent)serializable.elementAt(n2);
                            if (!jComponent2.isShowing() || !jComponent2.isEnabled()) continue;
                            ++n3;
                            n = n2;
                        }
                        if (n3 == 1) {
                            JComponent jComponent3 = (JComponent)serializable.elementAt(n);
                            this.fireBinding(jComponent3, keyStroke, keyEvent, bl);
                            if (keyEvent.isConsumed()) {
                                return true;
                            }
                        }
                        for (n2 = serializable.size() - 1; n2 >= 0; --n2) {
                            jComponent2 = (JComponent)serializable.elementAt(n2);
                            if (!jComponent2.isShowing() || !jComponent2.isEnabled() || jComponent2 != component && (!(jComponent2 instanceof JLabel) || ((JLabel)jComponent2).getLabelFor() != component)) continue;
                            if (keyEvent.getID() == 402) {
                                n = n2;
                                break;
                            }
                            n = (n2 - 1 + serializable.size()) % serializable.size();
                            break;
                        }
                        while (!(n < 0 || (jComponent = (JComponent)serializable.elementAt(n)).isShowing() && jComponent.isEnabled())) {
                            --n;
                        }
                        if (n >= 0) {
                            JComponent jComponent4 = (JComponent)serializable.elementAt(n);
                            if (!(jComponent4 instanceof AbstractButton)) {
                                this.fireBinding(jComponent4, keyStroke, keyEvent, bl);
                                if (keyEvent.isConsumed()) {
                                    return true;
                                }
                            }
                            if (jComponent4 instanceof JMenu) {
                                this.fireBinding(jComponent4, keyStroke, keyEvent, bl);
                                jComponent4.requestFocusInWindow();
                                if (keyEvent.isConsumed()) {
                                    return true;
                                }
                            } else {
                                boolean bl2 = jComponent4.requestFocusInWindow();
                                keyEvent.consume();
                                return bl2;
                            }
                        }
                    }
                    for (int i = serializable.size() - 1; i >= 0; --i) {
                        JComponent jComponent = (JComponent)serializable.elementAt(i);
                        if (!jComponent.isShowing() || !jComponent.isEnabled()) continue;
                        this.fireBinding(jComponent, keyStroke, keyEvent, bl);
                        if (!keyEvent.isConsumed()) continue;
                        return true;
                    }
                } else {
                    System.out.println("Unexpected condition in fireKeyboardAction " + vector);
                    Thread.dumpStack();
                }
            }
        }
        if (keyEvent.isConsumed()) {
            return true;
        }
        if (hashtable != null && (vector = (Vector)hashtable.get(JMenuBar.class)) != null) {
            serializable = vector.elements();
            while (serializable.hasMoreElements()) {
                boolean bl3;
                object = (JMenuBar)serializable.nextElement();
                if (!((Component)object).isShowing() || !((Component)object).isEnabled()) continue;
                boolean bl4 = bl3 = keyStroke2 != null && !keyStroke2.equals(keyStroke);
                if (bl3) {
                    this.fireBinding((JComponent)object, keyStroke2, keyEvent, bl);
                }
                if (!bl3 || !keyEvent.isConsumed()) {
                    this.fireBinding((JComponent)object, keyStroke, keyEvent, bl);
                }
                if (!keyEvent.isConsumed()) continue;
                return true;
            }
        }
        return keyEvent.isConsumed();
    }

    void fireBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent, boolean bl) {
        if (jComponent.processKeyBinding(keyStroke, keyEvent, 2, bl)) {
            keyEvent.consume();
        }
    }

    public void registerMenuBar(JMenuBar jMenuBar) {
        Vector<JMenuBar> vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((vector = (Vector<JMenuBar>)hashtable.get(JMenuBar.class)) == null) {
            vector = new Vector<JMenuBar>();
            hashtable.put(JMenuBar.class, vector);
        }
        if (!vector.contains(jMenuBar)) {
            vector.addElement(jMenuBar);
        }
    }

    public void unregisterMenuBar(JMenuBar jMenuBar) {
        Vector vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable != null && (vector = (Vector)hashtable.get(JMenuBar.class)) != null) {
            vector.removeElement(jMenuBar);
            if (vector.isEmpty()) {
                hashtable.remove(JMenuBar.class);
                if (hashtable.isEmpty()) {
                    this.containerMap.remove(container);
                }
            }
        }
    }

    protected Hashtable registerNewTopContainer(Container container) {
        Hashtable hashtable = new Hashtable();
        this.containerMap.put(container, hashtable);
        return hashtable;
    }

    class ComponentKeyStrokePair {
        Object component;
        Object keyStroke;

        public ComponentKeyStrokePair(Object object, Object object2) {
            this.component = object;
            this.keyStroke = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentKeyStrokePair)) {
                return false;
            }
            ComponentKeyStrokePair componentKeyStrokePair = (ComponentKeyStrokePair)object;
            return this.component.equals(componentKeyStrokePair.component) && this.keyStroke.equals(componentKeyStrokePair.keyStroke);
        }

        public int hashCode() {
            return this.component.hashCode() * this.keyStroke.hashCode();
        }
    }
}

