/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XErrorHandlerUtil;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsEnvironment;

public class XlibUtil {
    static Boolean isShapingSupported = null;

    private XlibUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRootWindow(int n) {
        XToolkit.awtLock();
        try {
            X11GraphicsEnvironment x11GraphicsEnvironment = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (x11GraphicsEnvironment.runningXinerama()) {
                long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), 0L);
                return l;
            }
            long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), n);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRoot(long l, long l2) {
        long l3;
        XToolkit.awtLock();
        try {
            l3 = XlibWrapper.RootWindow(XToolkit.getDisplay(), l2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return l3 == l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rectangle getWindowGeometry(long l) {
        XToolkit.awtLock();
        try {
            int n = XlibWrapper.XGetGeometry(XToolkit.getDisplay(), l, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            if (n == 0) {
                Rectangle rectangle = null;
                return rectangle;
            }
            int n2 = Native.getInt(XlibWrapper.larg2);
            int n3 = Native.getInt(XlibWrapper.larg3);
            long l2 = Native.getUInt(XlibWrapper.larg4);
            long l3 = Native.getUInt(XlibWrapper.larg5);
            Rectangle rectangle = new Rectangle(n2, n3, (int)l2, (int)l3);
            return rectangle;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Point translateCoordinates(long l, long l2, Point point) {
        Point point2 = null;
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xTranslateCoordinates = new XTranslateCoordinates(l, l2, point.x, point.y);
            try {
                int n = xTranslateCoordinates.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n != 0 && (XErrorHandlerUtil.saved_error == null || XErrorHandlerUtil.saved_error.get_error_code() == 0)) {
                    point2 = new Point(xTranslateCoordinates.get_dest_x(), xTranslateCoordinates.get_dest_y());
                }
            }
            finally {
                xTranslateCoordinates.dispose();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        return point2;
    }

    static Rectangle translateCoordinates(long l, long l2, Rectangle rectangle) {
        Point point = XlibUtil.translateCoordinates(l, l2, rectangle.getLocation());
        if (point == null) {
            return null;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getParentWindow(long l) {
        XToolkit.awtLock();
        try {
            Object object;
            block10: {
                XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
                if (xBaseWindow != null && (object = xBaseWindow.getParentWindow()) != null) {
                    long l2 = ((XBaseWindow)object).getWindow();
                    return l2;
                }
                object = new XQueryTree(l);
                try {
                    if (((XQueryTree)object).execute() != 0) break block10;
                    long l3 = 0L;
                    ((XQueryTree)object).dispose();
                    return l3;
                }
                catch (Throwable throwable) {
                    ((XQueryTree)object).dispose();
                    throw throwable;
                }
            }
            long l4 = ((XQueryTree)object).get_parent();
            ((XQueryTree)object).dispose();
            return l4;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Long> getChildWindows(long l) {
        XToolkit.awtLock();
        try {
            long l2;
            XQueryTree xQueryTree;
            block14: {
                block13: {
                    XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
                    if (xBaseWindow != null) {
                        Set<Long> set = xBaseWindow.getChildren();
                        return set;
                    }
                    xQueryTree = new XQueryTree(l);
                    int n = xQueryTree.execute();
                    if (n != 0) break block13;
                    Set<Long> set = Collections.emptySet();
                    xQueryTree.dispose();
                    return set;
                }
                l2 = xQueryTree.get_children();
                if (l2 != 0L) break block14;
                Set<Long> set = Collections.emptySet();
                xQueryTree.dispose();
                return set;
            }
            try {
                int n = xQueryTree.get_nchildren();
                HashSet<Long> hashSet = new HashSet<Long>(n);
                for (int i = 0; i < n; ++i) {
                    hashSet.add(Native.getWindow(l2, i));
                }
                HashSet<Long> hashSet2 = hashSet;
                xQueryTree.dispose();
                return hashSet2;
            }
            catch (Throwable throwable) {
                xQueryTree.dispose();
                throw throwable;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean isXAWTToplevelWindow(long l) {
        return XToolkit.windowToXWindow(l) instanceof XWindowPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isToplevelWindow(long l) {
        if (XToolkit.windowToXWindow(l) instanceof XDecoratedPeer) {
            return true;
        }
        XToolkit.awtLock();
        try {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean isTrueToplevelWindow(long l) {
        if (XToolkit.windowToXWindow(l) instanceof XEmbeddedFramePeer) {
            return false;
        }
        return XlibUtil.isToplevelWindow(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWindowMapState(long l) {
        XToolkit.awtLock();
        try {
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                if (n != 0 && (XErrorHandlerUtil.saved_error == null || XErrorHandlerUtil.saved_error.get_error_code() == 0)) {
                    int n2 = xWindowAttributes.get_map_state();
                    return n2;
                }
            }
            finally {
                xWindowAttributes.dispose();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean isShapingSupported() {
        if (isShapingSupported == null) {
            XToolkit.awtLock();
            try {
                isShapingSupported = XlibWrapper.XShapeQueryExtension(XToolkit.getDisplay(), XlibWrapper.larg1, XlibWrapper.larg2);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return isShapingSupported;
    }
}

