/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public abstract class ByteToCharSingleByte
extends ByteToCharConverter {
    protected char[] byteToCharTable;
    protected final char[] charMap;
    protected boolean normalSubMode = true;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static boolean bidiConfigDone = false;
    private static String bidiInit;
    protected static final int NEW_LINE_INDEX = 149;
    protected static final char SWAPPED_NEW_LINE_CHAR = '\u0085';

    protected ByteToCharSingleByte(String string) {
        String string2 = this.handleIBMSwapLF(string);
        this.byteToCharTable = string2.toCharArray();
        this.charMap = ByteToCharSingleByte.createCharMap(string2, true);
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected ByteToCharSingleByte(char[] cArray) {
        this.charMap = cArray;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected ByteToCharSingleByte() {
        this.charMap = null;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected static char[] createCharMap(String string, boolean bl) {
        char[] cArray;
        if (bl) {
            int n;
            cArray = new char[256];
            for (n = 0; n < 128; ++n) {
                cArray[n + 128] = string.charAt(n);
            }
            for (n = 128; n < 256; ++n) {
                cArray[n - 128] = string.charAt(n);
            }
        } else {
            cArray = null;
        }
        return cArray;
    }

    public String getType() {
        return "sbcs";
    }

    public char[] getCharData() {
        return this.byteToCharTable;
    }

    @Override
    public int flush(char[] cArray, int n, int n2) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    @Override
    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        BidiConvert bidiConvert;
        boolean bl = false;
        int n5 = n;
        int n6 = n3;
        int n7 = n2 - n;
        if (n7 > n4 - n3) {
            bl = true;
            n7 = n4 - n3;
        }
        int n8 = n7;
        if (this.normalSubMode) {
            int n9;
            char c = '\u0000';
            if (this.charMap != null) {
                for (n9 = 0; n9 < n8; ++n9) {
                    cArray[n9 + n6] = c = this.charMap[byArray[n9 + n5] & 0xFF];
                }
            } else {
                while (n9 < n8) {
                    cArray[n9 + n6] = c = this.byteToCharTable[byArray[n9 + n5] + 128];
                    ++n9;
                }
            }
        } else {
            this.convertLoop(byArray, n5, cArray, n6, n7);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n3, n3 + n7, this.bidiParms, this.getCharacterEncoding())) {
            char[] cArray2 = new char[n7];
            cArray2 = bidiConvert.toUnicode(cArray, n3, n3 + n7, this.bidiParms, this.getCharacterEncoding());
            System.arraycopy(cArray2, 0, cArray, n3, n7);
        }
        this.byteOff = n + n7;
        this.charOff = n3 + n7;
        if (bl) {
            this.throwConversionBufferFull();
        }
        return n7;
    }

    private void convertLoop(byte[] byArray, int n, char[] cArray, int n2, int n3) throws UnknownCharacterException {
        for (int i = 0; i < n3; ++i) {
            char c = this.byteToCharTable[byArray[n] + 128];
            if (c == '\ufffd') {
                if (this.subMode) {
                    c = this.subChars[0];
                } else {
                    this.byteOff = n;
                    this.charOff = n2;
                    throw new UnknownCharacterException();
                }
            }
            cArray[n2] = c;
            ++n;
            ++n2;
        }
    }

    private void throwConversionBufferFull() throws ConversionBufferFullException {
        throw new ConversionBufferFullException();
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    @Override
    public void setSubstitutionMode(boolean bl) {
        super.setSubstitutionMode(bl);
        this.normalSubMode = this.subMode && this.subChars[0] == '\ufffd';
    }

    @Override
    public void setSubstitutionChars(char[] cArray) {
        super.setSubstitutionChars(cArray);
        this.normalSubMode = this.subMode && this.subChars[0] == '\ufffd';
    }

    public static final boolean isSwapLF() {
        return Converters.isSwapLF();
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }
}

