/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FDBigInteger;

public class FloatingDecimal {
    float floatVal;
    double doubleVal;
    boolean isFloat;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final int MAX_NDIGITS = 1100;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static final String INFINITY_REP = "Infinity";
    private static final int INFINITY_LENGTH = "Infinity".length();
    private static final String NAN_REP = "NaN";
    private static final int NAN_LENGTH = "NaN".length();
    private static final BinaryToASCIIConverter B2AC_POSITIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("Infinity", false);
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("-Infinity", true);
    private static final BinaryToASCIIConverter B2AC_NOT_A_NUMBER = new ExceptionalBinaryToASCIIBuffer("NaN", false);
    private static final BinaryToASCIIConverter B2AC_POSITIVE_ZERO = new BinaryToASCIIBuffer(false, new char[]{'0'});
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_ZERO = new BinaryToASCIIBuffer(true, new char[]{'0'});
    private static final ThreadLocal<BinaryToASCIIBuffer> threadLocalBinaryToASCIIBuffer = new ThreadLocal<BinaryToASCIIBuffer>(){

        @Override
        protected BinaryToASCIIBuffer initialValue() {
            return new BinaryToASCIIBuffer();
        }
    };
    static final ASCIIToBinaryConverter A2BC_POSITIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.POSITIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.NEGATIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NOT_A_NUMBER = new PreparedASCIIToBinaryBuffer(Double.NaN);
    static final ASCIIToBinaryConverter A2BC_POSITIVE_ZERO = new PreparedASCIIToBinaryBuffer(0.0);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_ZERO = new PreparedASCIIToBinaryBuffer(-0.0);

    public FloatingDecimal(float f) {
        this.isFloat = true;
        this.floatVal = f;
    }

    public FloatingDecimal(double d) {
        this.isFloat = false;
        this.doubleVal = d;
    }

    public void appendTo(Appendable appendable) {
        if (this.isFloat) {
            FloatingDecimal.getBinaryToASCIIConverter(this.floatVal).appendTo(appendable);
        } else {
            FloatingDecimal.getBinaryToASCIIConverter(this.doubleVal).appendTo(appendable);
        }
    }

    public String toJavaFormatString() {
        if (this.isFloat) {
            return FloatingDecimal.getBinaryToASCIIConverter(this.floatVal).toJavaFormatString();
        }
        return FloatingDecimal.getBinaryToASCIIConverter(this.doubleVal).toJavaFormatString();
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    private static BinaryToASCIIBuffer getBinaryToASCIIBuffer() {
        return threadLocalBinaryToASCIIBuffer.get();
    }

    public static BinaryToASCIIConverter getBinaryToASCIIConverter(double d) {
        return FloatingDecimal.getBinaryToASCIIConverter(d, true);
    }

    static BinaryToASCIIConverter getBinaryToASCIIConverter(double d, boolean bl) {
        int n;
        long l = Double.doubleToRawLongBits(d);
        boolean bl2 = (l & Long.MIN_VALUE) != 0L;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        int n2 = (int)((l & 0x7FF0000000000000L) >> 52);
        if (n2 == 2047) {
            if (l2 == 0L) {
                return bl2 ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (n2 == 0) {
            if (l2 == 0L) {
                return bl2 ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int n3 = Long.numberOfLeadingZeros(l2);
            int n4 = n3 - 11;
            l2 <<= n4;
            n2 = 1 - n4;
            n = 64 - n3;
        } else {
            l2 |= 0x10000000000000L;
            n = 53;
        }
        BinaryToASCIIBuffer binaryToASCIIBuffer = FloatingDecimal.getBinaryToASCIIBuffer();
        binaryToASCIIBuffer.setSign(bl2);
        binaryToASCIIBuffer.dtoa(n2 -= 1023, l2, n, bl);
        return binaryToASCIIBuffer;
    }

    private static BinaryToASCIIConverter getBinaryToASCIIConverter(float f) {
        int n;
        int n2 = Float.floatToRawIntBits(f);
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        int n3 = n2 & 0x7FFFFF;
        int n4 = (n2 & 0x7F800000) >> 23;
        if (n4 == 255) {
            if ((long)n3 == 0L) {
                return bl ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (n4 == 0) {
            if (n3 == 0) {
                return bl ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int n5 = Integer.numberOfLeadingZeros(n3);
            int n6 = n5 - 8;
            n3 <<= n6;
            n4 = 1 - n6;
            n = 32 - n5;
        } else {
            n3 |= 0x800000;
            n = 24;
        }
        BinaryToASCIIBuffer binaryToASCIIBuffer = FloatingDecimal.getBinaryToASCIIBuffer();
        binaryToASCIIBuffer.setSign(bl);
        binaryToASCIIBuffer.dtoa(n4 -= 127, (long)n3 << 29, n, true);
        return binaryToASCIIBuffer;
    }

    static ASCIIToBinaryConverter readJavaFormatString(String string) throws NumberFormatException {
        block35: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                boolean bl3;
                char c;
                string = string.trim();
                int n = string.length();
                if (n == 0) {
                    throw new NumberFormatException("empty String");
                }
                int n2 = 0;
                switch (string.charAt(n2)) {
                    case '-': {
                        bl = true;
                    }
                    case '+': {
                        ++n2;
                        bl2 = true;
                    }
                }
                char c2 = string.charAt(n2);
                if (c2 == 'N') {
                    if (n - n2 == NAN_LENGTH && string.indexOf(NAN_REP, n2) == n2) {
                        return A2BC_NOT_A_NUMBER;
                    }
                    break block35;
                }
                if (c2 == 'I') {
                    if (n - n2 == INFINITY_LENGTH && string.indexOf(INFINITY_REP, n2) == n2) {
                        return bl ? A2BC_NEGATIVE_INFINITY : A2BC_POSITIVE_INFINITY;
                    }
                    break block35;
                }
                if (c2 == '0' && n > n2 + 1 && ((c = string.charAt(n2 + 1)) == 'x' || c == 'X')) {
                    return FloatingDecimal.parseHexString(string);
                }
                char[] cArray = new char[n];
                int n3 = 0;
                boolean bl4 = false;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n2 < n) {
                    c2 = string.charAt(n2);
                    if (c2 == '0') {
                        ++n5;
                    } else {
                        if (c2 != '.') break;
                        if (bl4) {
                            throw new NumberFormatException("multiple points");
                        }
                        n4 = n2;
                        if (bl2) {
                            --n4;
                        }
                        bl4 = true;
                    }
                    ++n2;
                }
                while (n2 < n) {
                    c2 = string.charAt(n2);
                    if (c2 >= '1' && c2 <= '9') {
                        cArray[n3++] = c2;
                        n6 = 0;
                    } else if (c2 == '0') {
                        cArray[n3++] = c2;
                        ++n6;
                    } else {
                        if (c2 != '.') break;
                        if (bl4) {
                            throw new NumberFormatException("multiple points");
                        }
                        n4 = n2;
                        if (bl2) {
                            --n4;
                        }
                        bl4 = true;
                    }
                    ++n2;
                }
                boolean bl5 = bl3 = (n3 -= n6) == 0;
                if (bl3 && n5 == 0) break block35;
                int n7 = bl4 ? n4 - n5 : n3 + n6;
                if (n2 < n && ((c2 = string.charAt(n2)) == 'e' || c2 == 'E')) {
                    int n8 = 1;
                    int n9 = 0;
                    int n10 = 0xCCCCCCC;
                    boolean bl6 = false;
                    switch (string.charAt(++n2)) {
                        case '-': {
                            n8 = -1;
                        }
                        case '+': {
                            ++n2;
                        }
                    }
                    int n11 = n2;
                    while (n2 < n) {
                        if (n9 >= n10) {
                            bl6 = true;
                        }
                        if ((c2 = string.charAt(n2++)) >= '0' && c2 <= '9') {
                            n9 = n9 * 10 + (c2 - 48);
                            continue;
                        }
                        --n2;
                        break;
                    }
                    int n12 = 324 + n3 + n6;
                    n7 = bl6 || n9 > n12 ? n8 * n12 : (n7 += n8 * n9);
                    if (n2 == n11) break block35;
                }
                if (n2 >= n || n2 == n - 1 && (string.charAt(n2) == 'f' || string.charAt(n2) == 'F' || string.charAt(n2) == 'd' || string.charAt(n2) == 'D')) {
                    if (bl3) {
                        return bl ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
                    }
                    return new ASCIIToBinaryBuffer(bl, n7, cArray, n3);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + string + "\"");
    }

    static float stickyRound(double d, int n) {
        if (n != 0) {
            long l = Double.doubleToRawLongBits(d);
            long l2 = l & 0x7FF0000000000000L;
            if (l2 == 0L || l2 == 0x7FF0000000000000L) {
                return (float)d;
            }
            return (float)Double.longBitsToDouble(l += (long)n);
        }
        return (float)d;
    }

    static ASCIIToBinaryConverter parseHexString(String string) {
        boolean bl;
        long l;
        long l2;
        Matcher matcher = HexFloatPattern.VALUE.matcher(string);
        boolean bl2 = matcher.matches();
        if (!bl2) {
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        String string2 = matcher.group(1);
        boolean bl3 = string2 != null && string2.equals("-");
        String string3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string4 = matcher.group(4);
        if (string4 != null) {
            string3 = FloatingDecimal.stripLeadingZeros(string4);
            n3 = string3.length();
        } else {
            String string5 = FloatingDecimal.stripLeadingZeros(matcher.group(6));
            n3 = string5.length();
            String string6 = matcher.group(7);
            n4 = string6.length();
            string3 = (string5 == null ? "" : string5) + string6;
        }
        string3 = FloatingDecimal.stripLeadingZeros(string3);
        n = string3.length();
        n2 = n3 >= 1 ? 4 * (n3 - 1) : -4 * (n4 - n + 1);
        if (n == 0) {
            return bl3 ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
        }
        String string7 = matcher.group(8);
        n4 = string7 == null || string7.equals("+") ? 1 : 0;
        try {
            l2 = Integer.parseInt(matcher.group(9));
        }
        catch (NumberFormatException numberFormatException) {
            return bl3 ? (n4 != 0 ? A2BC_NEGATIVE_INFINITY : A2BC_NEGATIVE_ZERO) : (n4 != 0 ? A2BC_POSITIVE_INFINITY : A2BC_POSITIVE_ZERO);
        }
        long l3 = (n4 != 0 ? 1L : -1L) * l2;
        long l4 = l3 + (long)n2;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = 0;
        long l5 = 0L;
        long l6 = FloatingDecimal.getHexDigit(string3, 0);
        if (l6 == 1L) {
            l5 |= l6 << 52;
            n5 = 48;
        } else if (l6 <= 3L) {
            l5 |= l6 << 51;
            n5 = 47;
            ++l4;
        } else if (l6 <= 7L) {
            l5 |= l6 << 50;
            n5 = 46;
            l4 += 2L;
        } else if (l6 <= 15L) {
            l5 |= l6 << 49;
            n5 = 45;
            l4 += 3L;
        } else {
            throw new AssertionError((Object)"Result from digit conversion too large!");
        }
        int n6 = 0;
        for (n6 = 1; n6 < n && n5 >= 0; n5 -= 4, ++n6) {
            l = FloatingDecimal.getHexDigit(string3, n6);
            l5 |= l << n5;
        }
        if (n6 < n) {
            l = FloatingDecimal.getHexDigit(string3, n6);
            switch (n5) {
                case -1: {
                    l5 |= (l & 0xEL) >> 1;
                    bl4 = (l & 1L) != 0L;
                    break;
                }
                case -2: {
                    l5 |= (l & 0xCL) >> 2;
                    bl4 = (l & 2L) != 0L;
                    bl5 = (l & 1L) != 0L;
                    break;
                }
                case -3: {
                    l5 |= (l & 8L) >> 3;
                    bl4 = (l & 4L) != 0L;
                    bl5 = (l & 3L) != 0L;
                    break;
                }
                case -4: {
                    bl4 = (l & 8L) != 0L;
                    bl5 = (l & 7L) != 0L;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected shift distance remainder.");
                }
            }
            ++n6;
            while (n6 < n && !bl5) {
                l = FloatingDecimal.getHexDigit(string3, n6);
                bl5 = bl5 || l != 0L;
                ++n6;
            }
        }
        if (l4 > 1023L) {
            return bl3 ? A2BC_NEGATIVE_INFINITY : A2BC_POSITIVE_INFINITY;
        }
        if (l4 <= 1023L && l4 >= -1022L) {
            l5 = l4 + 1023L << 52 & 0x7FF0000000000000L | 0xFFFFFFFFFFFFFL & l5;
        } else {
            if (l4 < -1075L) {
                return bl3 ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
            }
            bl5 = bl5 || bl4;
            bl4 = false;
            int n7 = 53 - ((int)l4 - -1074 + 1);
            assert (n7 >= 1 && n7 <= 53);
            boolean bl6 = bl4 = (l5 & 1L << n7 - 1) != 0L;
            if (n7 > 1) {
                long l7 = -1L << n7 - 1 ^ 0xFFFFFFFFFFFFFFFFL;
                bl5 = bl5 || (l5 & l7) != 0L;
            }
            l5 >>= n7;
            l5 = 0L | 0xFFFFFFFFFFFFFL & l5;
        }
        boolean bl7 = bl = (l5 & 1L) == 0L;
        if (bl && bl4 && bl5 || !bl && bl4) {
            ++l5;
        }
        double d = bl3 ? Double.longBitsToDouble(l5 | Long.MIN_VALUE) : Double.longBitsToDouble(l5);
        int n8 = 0;
        if (l4 >= -150L && l4 <= 127L && (l5 & 0xFFFFFFFL) == 0L && (bl4 || bl5)) {
            if (bl) {
                if (bl4 ^ bl5) {
                    n8 = 1;
                }
            } else if (bl4) {
                n8 = -1;
            }
        }
        return new PreparedASCIIToBinaryBuffer(d, n8);
    }

    static String stripLeadingZeros(String string) {
        if (!string.isEmpty() && string.charAt(0) == '0') {
            for (int i = 1; i < string.length(); ++i) {
                if (string.charAt(i) == '0') continue;
                return string.substring(i);
            }
            return "";
        }
        return string;
    }

    static int getHexDigit(String string, int n) {
        int n2 = Character.digit(string.charAt(n), 16);
        if (n2 <= -1 || n2 >= 16) {
            throw new AssertionError((Object)("Unexpected failure of digit conversion of " + string.charAt(n)));
        }
        return n2;
    }

    private static class HexFloatPattern {
        private static final Pattern VALUE = Pattern.compile("([-+])?0[xX](((\\p{XDigit}+)\\.?)|((\\p{XDigit}*)\\.(\\p{XDigit}+)))[pP]([-+])?(\\p{Digit}+)[fFdD]?");

        private HexFloatPattern() {
        }
    }

    static class ASCIIToBinaryBuffer
    implements ASCIIToBinaryConverter {
        boolean isNegative;
        int decExponent;
        char[] digits;
        int nDigits;
        int roundDir = 0;
        private static final double[] SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        private static final float[] SINGLE_SMALL_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        private static final double[] BIG_10_POW = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        private static final double[] TINY_10_POW = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        private static final int MAX_SMALL_TEN = SMALL_10_POW.length - 1;
        private static final int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;

        ASCIIToBinaryBuffer(boolean bl, int n, char[] cArray, int n2) {
            this.isNegative = bl;
            this.decExponent = n;
            this.digits = cArray;
            this.nDigits = n2;
        }

        @Override
        public double doubleValue() {
            return this.doubleValue(false);
        }

        private static double ulp(double d, boolean bl) {
            long l = Double.doubleToLongBits(d) & Long.MAX_VALUE;
            int n = (int)(l >>> 52);
            if (bl && n >= 52 && (l & 0xFFFFFFFFFFFFFL) == 0L) {
                --n;
            }
            double d2 = n > 52 ? Double.longBitsToDouble((long)(n - 52) << 52) : (n == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << n - 1));
            if (bl) {
                d2 = -d2;
            }
            return d2;
        }

        private strictfp double doubleValue(boolean bl) {
            boolean bl2;
            double d;
            int n;
            int n2;
            int n3 = Math.min(this.nDigits, 16);
            if (bl) {
                this.roundDir = 0;
            }
            int n4 = this.digits[0] - 48;
            int n5 = Math.min(n3, 9);
            for (n2 = 1; n2 < n5; ++n2) {
                n4 = n4 * 10 + this.digits[n2] - 48;
            }
            long l = n4;
            for (n2 = n5; n2 < n3; ++n2) {
                l = l * 10L + (long)(this.digits[n2] - 48);
            }
            double d2 = l;
            n2 = this.decExponent - n3;
            if (this.nDigits <= 15) {
                if (n2 == 0 || d2 == 0.0) {
                    return this.isNegative ? -d2 : d2;
                }
                if (n2 >= 0) {
                    if (n2 <= MAX_SMALL_TEN) {
                        double d3 = d2 * SMALL_10_POW[n2];
                        if (bl) {
                            double d4 = d3 / SMALL_10_POW[n2];
                            this.roundDir = d4 == d2 ? 0 : (d4 < d2 ? 1 : -1);
                        }
                        return this.isNegative ? -d3 : d3;
                    }
                    n = 15 - n3;
                    if (n2 <= MAX_SMALL_TEN + n) {
                        double d5 = (d2 *= SMALL_10_POW[n]) * SMALL_10_POW[n2 - n];
                        if (bl) {
                            double d6 = d5 / SMALL_10_POW[n2 - n];
                            this.roundDir = d6 == d2 ? 0 : (d6 < d2 ? 1 : -1);
                        }
                        return this.isNegative ? -d5 : d5;
                    }
                } else if (n2 >= -MAX_SMALL_TEN) {
                    double d7 = d2 / SMALL_10_POW[-n2];
                    if (bl) {
                        double d8 = d7 * SMALL_10_POW[-n2];
                        this.roundDir = d8 == d2 ? 0 : (d8 < d2 ? 1 : -1);
                    }
                    return this.isNegative ? -d7 : d7;
                }
            }
            if (n2 > 0) {
                if (this.decExponent > 309) {
                    return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                if ((n2 & 0xF) != 0) {
                    d2 *= SMALL_10_POW[n2 & 0xF];
                }
                if ((n2 >>= 4) != 0) {
                    n = 0;
                    while (n2 > 1) {
                        if ((n2 & 1) != 0) {
                            d2 *= BIG_10_POW[n];
                        }
                        ++n;
                        n2 >>= 1;
                    }
                    d = d2 * BIG_10_POW[n];
                    if (Double.isInfinite(d)) {
                        d = d2 / 2.0;
                        if (Double.isInfinite(d *= BIG_10_POW[n])) {
                            return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        }
                        d = Double.MAX_VALUE;
                    }
                    d2 = d;
                }
            } else if (n2 < 0) {
                n2 = -n2;
                if (this.decExponent < -325) {
                    return this.isNegative ? -0.0 : 0.0;
                }
                if ((n2 & 0xF) != 0) {
                    d2 /= SMALL_10_POW[n2 & 0xF];
                }
                if ((n2 >>= 4) != 0) {
                    n = 0;
                    while (n2 > 1) {
                        if ((n2 & 1) != 0) {
                            d2 *= TINY_10_POW[n];
                        }
                        ++n;
                        n2 >>= 1;
                    }
                    d = d2 * TINY_10_POW[n];
                    if (d == 0.0) {
                        d = d2 * 2.0;
                        if ((d *= TINY_10_POW[n]) == 0.0) {
                            return this.isNegative ? -0.0 : 0.0;
                        }
                        d = Double.MIN_VALUE;
                    }
                    d2 = d;
                }
            }
            FDBigInteger fDBigInteger = new FDBigInteger(l, this.digits, n3, this.nDigits);
            n2 = this.decExponent - this.nDigits;
            int n6 = Math.max(0, -n2);
            int n7 = Math.max(0, n2);
            fDBigInteger = fDBigInteger.multByPow52(n7, 0);
            fDBigInteger.makeImmutable();
            FDBigInteger fDBigInteger2 = null;
            int n8 = 0;
            do {
                FDBigInteger fDBigInteger3;
                int n9;
                int n10;
                int n11;
                long l2 = Double.doubleToRawLongBits(d2) & Long.MAX_VALUE;
                int n12 = (int)(l2 >>> 52);
                l2 &= 0xFFFFFFFFFFFFFL;
                if (n12 > 0) {
                    l2 |= 0x10000000000000L;
                } else {
                    assert (l2 != 0L) : l2;
                    n11 = Long.numberOfLeadingZeros(l2);
                    n10 = n11 - 11;
                    l2 <<= n10;
                    n12 = 1 - n10;
                }
                n11 = Long.numberOfTrailingZeros(l2);
                l2 >>>= n11;
                n10 = (n12 -= 1023) - 52 + n11;
                int n13 = 53 - n11;
                int n14 = n6;
                int n15 = n7;
                if (n10 >= 0) {
                    n14 += n10;
                } else {
                    n15 -= n10;
                }
                int n16 = n14;
                int n17 = n12 <= -1023 ? n12 + n11 + 1023 : 1 + n11;
                int n18 = Math.min(n14 += n17, Math.min(n15 += n17, n16));
                n16 -= n18;
                FDBigInteger fDBigInteger4 = FDBigInteger.valueOfMulPow52(l2, n6, n14 -= n18);
                if (fDBigInteger2 == null || n8 != (n15 -= n18)) {
                    fDBigInteger2 = fDBigInteger.leftShift(n15);
                    n8 = n15;
                }
                if ((n9 = fDBigInteger4.cmp(fDBigInteger2)) > 0) {
                    bl2 = true;
                    fDBigInteger3 = fDBigInteger4.leftInplaceSub(fDBigInteger2);
                    if (n13 == 1 && n10 > -1022 && --n16 < 0) {
                        n16 = 0;
                        fDBigInteger3 = fDBigInteger3.leftShift(1);
                    }
                } else {
                    if (n9 >= 0) break;
                    bl2 = false;
                    fDBigInteger3 = fDBigInteger2.rightInplaceSub(fDBigInteger4);
                }
                if ((n9 = fDBigInteger3.cmpPow52(n6, n16)) < 0) {
                    if (!bl) break;
                    this.roundDir = bl2 ? -1 : 1;
                    break;
                }
                if (n9 != 0) continue;
                d2 += 0.5 * ASCIIToBinaryBuffer.ulp(d2, bl2);
                if (!bl) break;
                this.roundDir = bl2 ? -1 : 1;
                break;
            } while ((d2 += ASCIIToBinaryBuffer.ulp(d2, bl2)) != 0.0 && d2 != Double.POSITIVE_INFINITY);
            return this.isNegative ? -d2 : d2;
        }

        @Override
        public strictfp float floatValue() {
            int n;
            int n2 = Math.min(this.nDigits, 8);
            int n3 = this.digits[0] - 48;
            for (n = 1; n < n2; ++n) {
                n3 = n3 * 10 + this.digits[n] - 48;
            }
            float f = n3;
            n = this.decExponent - n2;
            if (this.nDigits <= 7) {
                if (n == 0 || f == 0.0f) {
                    return this.isNegative ? -f : f;
                }
                if (n >= 0) {
                    if (n <= SINGLE_MAX_SMALL_TEN) {
                        return this.isNegative ? -f : (f *= SINGLE_SMALL_10_POW[n]);
                    }
                    int n4 = 7 - n2;
                    if (n <= SINGLE_MAX_SMALL_TEN + n4) {
                        f *= SINGLE_SMALL_10_POW[n4];
                        return this.isNegative ? -f : (f *= SINGLE_SMALL_10_POW[n - n4]);
                    }
                } else if (n >= -SINGLE_MAX_SMALL_TEN) {
                    return this.isNegative ? -f : (f /= SINGLE_SMALL_10_POW[-n]);
                }
            } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
                long l = n3;
                for (int i = n2; i < this.nDigits; ++i) {
                    l = l * 10L + (long)(this.digits[i] - 48);
                }
                double d = l;
                n = this.decExponent - this.nDigits;
                f = (float)(d *= SMALL_10_POW[n]);
                return this.isNegative ? -f : f;
            }
            if (this.decExponent > 39) {
                return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (this.decExponent < -46) {
                return this.isNegative ? -0.0f : 0.0f;
            }
            double d = this.doubleValue(true);
            return FloatingDecimal.stickyRound(d, this.roundDir);
        }
    }

    static class PreparedASCIIToBinaryBuffer
    implements ASCIIToBinaryConverter {
        private final double doubleVal;
        private int roundDir = 0;

        public PreparedASCIIToBinaryBuffer(double d) {
            this.doubleVal = d;
        }

        public PreparedASCIIToBinaryBuffer(double d, int n) {
            this.doubleVal = d;
            this.roundDir = n;
        }

        @Override
        public double doubleValue() {
            return this.doubleVal;
        }

        @Override
        public float floatValue() {
            return FloatingDecimal.stickyRound(this.doubleVal, this.roundDir);
        }
    }

    static interface ASCIIToBinaryConverter {
        public double doubleValue();

        public float floatValue();
    }

    static class BinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private boolean isNegative;
        private int decExponent;
        private int firstDigitIndex;
        private int nDigits;
        private final char[] digits;
        private final char[] buffer = new char[26];
        private boolean exactDecimalConversion = false;
        private boolean decimalDigitsRoundedUp = false;
        private static int[] insignificantDigitsNumber = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19};
        private static final int[] N_5_BITS = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};

        BinaryToASCIIBuffer() {
            this.digits = new char[20];
        }

        BinaryToASCIIBuffer(boolean bl, char[] cArray) {
            this.isNegative = bl;
            this.decExponent = 0;
            this.digits = cArray;
            this.firstDigitIndex = 0;
            this.nDigits = cArray.length;
        }

        @Override
        public String toJavaFormatString() {
            int n = this.getChars(this.buffer);
            return new String(this.buffer, 0, n);
        }

        @Override
        public void appendTo(Appendable appendable) {
            int n = this.getChars(this.buffer);
            if (appendable instanceof StringBuilder) {
                ((StringBuilder)appendable).append(this.buffer, 0, n);
            } else if (appendable instanceof StringBuffer) {
                ((StringBuffer)appendable).append(this.buffer, 0, n);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            return this.decExponent;
        }

        @Override
        public int getDigits(char[] cArray) {
            System.arraycopy(this.digits, this.firstDigitIndex, cArray, 0, this.nDigits);
            return this.nDigits;
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return false;
        }

        @Override
        public boolean digitsRoundedUp() {
            return this.decimalDigitsRoundedUp;
        }

        @Override
        public boolean decimalDigitsExact() {
            return this.exactDecimalConversion;
        }

        private void setSign(boolean bl) {
            this.isNegative = bl;
        }

        private void developLongDigits(int n, long l, int n2) {
            if (n2 != 0) {
                long l2 = FDBigInteger.LONG_5_POW[n2] << n2;
                long l3 = l % l2;
                l /= l2;
                n += n2;
                if (l3 >= l2 >> 1) {
                    ++l;
                }
            }
            int n3 = this.digits.length - 1;
            if (l <= Integer.MAX_VALUE) {
                assert (l > 0L) : l;
                int n4 = (int)l;
                int n5 = n4 % 10;
                n4 /= 10;
                while (n5 == 0) {
                    ++n;
                    n5 = n4 % 10;
                    n4 /= 10;
                }
                while (n4 != 0) {
                    this.digits[n3--] = (char)(n5 + 48);
                    ++n;
                    n5 = n4 % 10;
                    n4 /= 10;
                }
                this.digits[n3] = (char)(n5 + 48);
            } else {
                int n6 = (int)(l % 10L);
                l /= 10L;
                while (n6 == 0) {
                    ++n;
                    n6 = (int)(l % 10L);
                    l /= 10L;
                }
                while (l != 0L) {
                    this.digits[n3--] = (char)(n6 + 48);
                    ++n;
                    n6 = (int)(l % 10L);
                    l /= 10L;
                }
                this.digits[n3] = (char)(n6 + 48);
            }
            this.decExponent = n + 1;
            this.firstDigitIndex = n3;
            this.nDigits = this.digits.length - n3;
        }

        private void dtoa(int n, long l, int n2, boolean bl) {
            long l2;
            boolean bl2;
            boolean bl3;
            assert (l > 0L);
            assert ((l & 0x10000000000000L) != 0L);
            int n3 = Long.numberOfTrailingZeros(l);
            int n4 = 53 - n3;
            this.decimalDigitsRoundedUp = false;
            this.exactDecimalConversion = false;
            int n5 = Math.max(0, n4 - n - 1);
            if (n <= 62 && n >= -21 && n5 < FDBigInteger.LONG_5_POW.length && n4 + N_5_BITS[n5] < 64 && n5 == 0) {
                int n6 = n > n2 ? BinaryToASCIIBuffer.insignificantDigitsForPow2(n - n2 - 1) : 0;
                l = n >= 52 ? (l <<= n - 52) : (l >>>= 52 - n);
                this.developLongDigits(0, l, n6);
                return;
            }
            int n7 = BinaryToASCIIBuffer.estimateDecExp(l, n);
            int n8 = Math.max(0, -n7);
            int n9 = n8 + n5 + n;
            int n10 = Math.max(0, n7);
            int n11 = n10 + n5;
            int n12 = n8;
            int n13 = n9 - n2;
            l >>>= n3;
            int n14 = Math.min(n9 -= n4 - 1, n11);
            n9 -= n14;
            n11 -= n14;
            n13 -= n14;
            if (n4 == 1) {
                --n13;
            }
            if (n13 < 0) {
                n9 -= n13;
                n11 -= n13;
                n13 = 0;
            }
            int n15 = 0;
            int n16 = n4 + n9 + (n8 < N_5_BITS.length ? N_5_BITS[n8] : n8 * 3);
            int n17 = n11 + 1 + (n10 + 1 < N_5_BITS.length ? N_5_BITS[n10 + 1] : (n10 + 1) * 3);
            if (n16 < 64 && n17 < 64) {
                if (n16 < 32 && n17 < 32) {
                    int n18 = (int)l * FDBigInteger.SMALL_5_POW[n8] << n9;
                    int n19 = FDBigInteger.SMALL_5_POW[n10] << n11;
                    int n20 = FDBigInteger.SMALL_5_POW[n12] << n13;
                    int n21 = n19 * 10;
                    n15 = 0;
                    int n22 = n18 / n19;
                    bl3 = (n18 = 10 * (n18 % n19)) < (n20 *= 10);
                    boolean bl4 = bl2 = n18 + n20 > n21;
                    assert (n22 < 10) : n22;
                    if (n22 == 0 && !bl2) {
                        --n7;
                    } else {
                        this.digits[n15++] = (char)(48 + n22);
                    }
                    if (!bl || n7 < -3 || n7 >= 8) {
                        bl3 = false;
                        bl2 = false;
                    }
                    while (!bl3 && !bl2) {
                        n22 = n18 / n19;
                        n18 = 10 * (n18 % n19);
                        n20 *= 10;
                        assert (n22 < 10) : n22;
                        if ((long)n20 > 0L) {
                            bl3 = n18 < n20;
                            bl2 = n18 + n20 > n21;
                        } else {
                            bl3 = true;
                            bl2 = true;
                        }
                        this.digits[n15++] = (char)(48 + n22);
                    }
                    l2 = (n18 << 1) - n21;
                    this.exactDecimalConversion = n18 == 0;
                } else {
                    long l3 = l * FDBigInteger.LONG_5_POW[n8] << n9;
                    long l4 = FDBigInteger.LONG_5_POW[n10] << n11;
                    long l5 = FDBigInteger.LONG_5_POW[n12] << n13;
                    long l6 = l4 * 10L;
                    n15 = 0;
                    int n23 = (int)(l3 / l4);
                    bl3 = (l3 = 10L * (l3 % l4)) < (l5 *= 10L);
                    boolean bl5 = bl2 = l3 + l5 > l6;
                    assert (n23 < 10) : n23;
                    if (n23 == 0 && !bl2) {
                        --n7;
                    } else {
                        this.digits[n15++] = (char)(48 + n23);
                    }
                    if (!bl || n7 < -3 || n7 >= 8) {
                        bl3 = false;
                        bl2 = false;
                    }
                    while (!bl3 && !bl2) {
                        n23 = (int)(l3 / l4);
                        l3 = 10L * (l3 % l4);
                        l5 *= 10L;
                        assert (n23 < 10) : n23;
                        if (l5 > 0L) {
                            bl3 = l3 < l5;
                            bl2 = l3 + l5 > l6;
                        } else {
                            bl3 = true;
                            bl2 = true;
                        }
                        this.digits[n15++] = (char)(48 + n23);
                    }
                    l2 = (l3 << 1) - l6;
                    this.exactDecimalConversion = l3 == 0L;
                }
            } else {
                FDBigInteger fDBigInteger = FDBigInteger.valueOfPow52(n10, n11);
                int n24 = fDBigInteger.getNormalizationBias();
                fDBigInteger = fDBigInteger.leftShift(n24);
                FDBigInteger fDBigInteger2 = FDBigInteger.valueOfMulPow52(l, n8, n9 + n24);
                FDBigInteger fDBigInteger3 = FDBigInteger.valueOfPow52(n12 + 1, n13 + n24 + 1);
                FDBigInteger fDBigInteger4 = FDBigInteger.valueOfPow52(n10 + 1, n11 + n24 + 1);
                n15 = 0;
                int n25 = fDBigInteger2.quoRemIteration(fDBigInteger);
                bl3 = fDBigInteger2.cmp(fDBigInteger3) < 0;
                boolean bl6 = bl2 = fDBigInteger4.addAndCmp(fDBigInteger2, fDBigInteger3) <= 0;
                assert (n25 < 10) : n25;
                if (n25 == 0 && !bl2) {
                    --n7;
                } else {
                    this.digits[n15++] = (char)(48 + n25);
                }
                if (!bl || n7 < -3 || n7 >= 8) {
                    bl3 = false;
                    bl2 = false;
                }
                while (!bl3 && !bl2) {
                    n25 = fDBigInteger2.quoRemIteration(fDBigInteger);
                    assert (n25 < 10) : n25;
                    bl3 = fDBigInteger2.cmp(fDBigInteger3 = fDBigInteger3.multBy10()) < 0;
                    bl2 = fDBigInteger4.addAndCmp(fDBigInteger2, fDBigInteger3) <= 0;
                    this.digits[n15++] = (char)(48 + n25);
                }
                if (bl2 && bl3) {
                    fDBigInteger2 = fDBigInteger2.leftShift(1);
                    l2 = fDBigInteger2.cmp(fDBigInteger4);
                } else {
                    l2 = 0L;
                }
                this.exactDecimalConversion = fDBigInteger2.cmp(FDBigInteger.ZERO) == 0;
            }
            this.decExponent = n7 + 1;
            this.firstDigitIndex = 0;
            this.nDigits = n15;
            if (bl2) {
                if (bl3) {
                    if (l2 == 0L) {
                        if ((this.digits[this.firstDigitIndex + this.nDigits - 1] & '\u0001') != 0) {
                            this.roundup();
                        }
                    } else if (l2 > 0L) {
                        this.roundup();
                    }
                } else {
                    this.roundup();
                }
            }
        }

        private void roundup() {
            int n = this.firstDigitIndex + this.nDigits - 1;
            char c = this.digits[n];
            if (c == '9') {
                while (c == '9' && n > this.firstDigitIndex) {
                    this.digits[n] = 48;
                    c = this.digits[--n];
                }
                if (c == '9') {
                    ++this.decExponent;
                    this.digits[this.firstDigitIndex] = 49;
                    return;
                }
            }
            this.digits[n] = (char)(c + '\u0001');
            this.decimalDigitsRoundedUp = true;
        }

        static int estimateDecExp(long l, int n) {
            boolean bl;
            double d = Double.longBitsToDouble(0x3FF0000000000000L | l & 0xFFFFFFFFFFFFFL);
            double d2 = (d - 1.5) * 0.289529654 + 0.176091259 + (double)n * 0.301029995663981;
            long l2 = Double.doubleToRawLongBits(d2);
            int n2 = (int)((l2 & 0x7FF0000000000000L) >> 52) - 1023;
            boolean bl2 = bl = (l2 & Long.MIN_VALUE) != 0L;
            if (n2 >= 0 && n2 < 52) {
                long l3 = 0xFFFFFFFFFFFFFL >> n2;
                int n3 = (int)((l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L) >> 52 - n2);
                return bl ? ((l3 & l2) == 0L ? -n3 : -n3 - 1) : n3;
            }
            if (n2 < 0) {
                return (l2 & Long.MAX_VALUE) == 0L ? 0 : (bl ? -1 : 0);
            }
            return (int)d2;
        }

        private static int insignificantDigits(int n) {
            int n2 = 0;
            while ((long)n >= 10L) {
                n = (int)((long)n / 10L);
                ++n2;
            }
            return n2;
        }

        private static int insignificantDigitsForPow2(int n) {
            if (n > 1 && n < insignificantDigitsNumber.length) {
                return insignificantDigitsNumber[n];
            }
            return 0;
        }

        private int getChars(char[] cArray) {
            assert (this.nDigits <= 19) : this.nDigits;
            int n = 0;
            if (this.isNegative) {
                cArray[0] = 45;
                n = 1;
            }
            if (this.decExponent > 0 && this.decExponent < 8) {
                int n2 = Math.min(this.nDigits, this.decExponent);
                System.arraycopy(this.digits, this.firstDigitIndex, cArray, n, n2);
                n += n2;
                if (n2 < this.decExponent) {
                    n2 = this.decExponent - n2;
                    Arrays.fill(cArray, n, n + n2, '0');
                    n += n2;
                    cArray[n++] = 46;
                    cArray[n++] = 48;
                } else {
                    cArray[n++] = 46;
                    if (n2 < this.nDigits) {
                        int n3 = this.nDigits - n2;
                        System.arraycopy(this.digits, this.firstDigitIndex + n2, cArray, n, n3);
                        n += n3;
                    } else {
                        cArray[n++] = 48;
                    }
                }
            } else if (this.decExponent <= 0 && this.decExponent > -3) {
                cArray[n++] = 48;
                cArray[n++] = 46;
                if (this.decExponent != 0) {
                    Arrays.fill(cArray, n, n - this.decExponent, '0');
                    n -= this.decExponent;
                }
                System.arraycopy(this.digits, this.firstDigitIndex, cArray, n, this.nDigits);
                n += this.nDigits;
            } else {
                int n4;
                cArray[n++] = this.digits[this.firstDigitIndex];
                cArray[n++] = 46;
                if (this.nDigits > 1) {
                    System.arraycopy(this.digits, this.firstDigitIndex + 1, cArray, n, this.nDigits - 1);
                    n += this.nDigits - 1;
                } else {
                    cArray[n++] = 48;
                }
                cArray[n++] = 69;
                if (this.decExponent <= 0) {
                    cArray[n++] = 45;
                    n4 = -this.decExponent + 1;
                } else {
                    n4 = this.decExponent - 1;
                }
                if (n4 <= 9) {
                    cArray[n++] = (char)(n4 + 48);
                } else if (n4 <= 99) {
                    cArray[n++] = (char)(n4 / 10 + 48);
                    cArray[n++] = (char)(n4 % 10 + 48);
                } else {
                    cArray[n++] = (char)(n4 / 100 + 48);
                    cArray[n++] = (char)((n4 %= 100) / 10 + 48);
                    cArray[n++] = (char)(n4 % 10 + 48);
                }
            }
            return n;
        }
    }

    private static class ExceptionalBinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private final String image;
        private boolean isNegative;

        public ExceptionalBinaryToASCIIBuffer(String string, boolean bl) {
            this.image = string;
            this.isNegative = bl;
        }

        @Override
        public String toJavaFormatString() {
            return this.image;
        }

        @Override
        public void appendTo(Appendable appendable) {
            if (appendable instanceof StringBuilder) {
                ((StringBuilder)appendable).append(this.image);
            } else if (appendable instanceof StringBuffer) {
                ((StringBuffer)appendable).append(this.image);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            throw new IllegalArgumentException("Exceptional value does not have an exponent");
        }

        @Override
        public int getDigits(char[] cArray) {
            throw new IllegalArgumentException("Exceptional value does not have digits");
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return true;
        }

        @Override
        public boolean digitsRoundedUp() {
            throw new IllegalArgumentException("Exceptional value is not rounded");
        }

        @Override
        public boolean decimalDigitsExact() {
            throw new IllegalArgumentException("Exceptional value is not exact");
        }
    }

    public static interface BinaryToASCIIConverter {
        public String toJavaFormatString();

        public void appendTo(Appendable var1);

        public int getDecimalExponent();

        public int getDigits(char[] var1);

        public boolean isNegative();

        public boolean isExceptional();

        public boolean digitsRoundedUp();

        public boolean decimalDigitsExact();
    }
}

