/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

public class ZosEventPort
extends Port {
    private boolean closed;
    private final int[] sp;
    private PollArrayWrapper poller;
    protected final Lock pollLock = new ReentrantLock(true);
    private int fdCount;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private static final int MAX_EPOLL_EVENTS = 512;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    ZosEventPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.fdToChannelLock.readLock().lock();
        this.fdCount = this.fdToChannel.size();
        this.poller = new PollArrayWrapper(this.fdCount);
        int n = 1;
        for (Integer n2 : this.fdToChannel.keySet()) {
            if (n > this.fdCount) continue;
            this.poller.putDescriptor(n, n2);
            this.poller.putEventOps(n, 0);
            this.poller.putReventOps(n, 0);
            ++n;
        }
        this.poller.totalChannels = this.fdCount + 1;
        this.fdToChannelLock.readLock().unlock();
        Object object = new int[2];
        ZosEventPort.socketpair((int[])object);
        this.poller.initInterrupt((int)object[0], (int)object[1]);
        this.poller.putEventOps(0, 1);
        this.sp = (int[])object;
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    @Override
    void startPoll(int n, int n2) {
        this.pollLock.lock();
        for (int i = 1; i <= this.fdCount; ++i) {
            if (this.poller.getDescriptor(i) != n) continue;
            int n3 = this.poller.getEventOps(i);
            this.poller.putEventOps(i, n3 |= Event.toZosEvent(n2));
            this.pollLock.unlock();
            return;
        }
        ++this.fdCount;
        this.poller.grow(this.fdCount);
        this.poller.putDescriptor(this.fdCount, n);
        this.poller.putEventOps(this.fdCount, Event.toZosEvent(n2));
        this.poller.putReventOps(this.fdCount, 0);
        this.poller.totalChannels = this.fdCount + 1;
        this.poller.initInterrupt(this.sp[0], this.sp[1]);
        this.poller.putEventOps(0, 1);
        this.pollLock.unlock();
    }

    ZosEventPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        ZosEventPort zosEventPort = this;
        synchronized (zosEventPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        ZosEventPort zosEventPort = this;
        synchronized (zosEventPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.pollLock.lock();
        this.poller.free();
        this.pollLock.unlock();
        ZosEventPort.close0(this.sp[0]);
        ZosEventPort.close0(this.sp[1]);
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    private void wakeup() {
        this.pollLock.lock();
        if (this.wakeupCount.incrementAndGet() == 1) {
            this.poller.interrupt();
        }
        this.pollLock.unlock();
    }

    private static native void socketpair(int[] var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$900(ZosEventPort zosEventPort) {
        zosEventPort.implClose();
    }

    static {
        Util.load();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block10: while (true) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    ZosEventPort.this.pollLock.lock();
                    ZosEventPort.this.fdToChannelLock.readLock().lock();
                    if (ZosEventPort.this.fdRegistrationUpdated) {
                        n4 = ZosEventPort.this.fdToChannel.size();
                        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n4);
                        n3 = 0;
                        for (n2 = 1; n2 <= ZosEventPort.this.fdCount; ++n2) {
                            n = ZosEventPort.this.poller.getDescriptor(n2);
                            if (ZosEventPort.this.fdToChannel.get(n) == null) continue;
                            pollArrayWrapper.putDescriptor(++n3, n);
                            int n5 = ZosEventPort.this.poller.getEventOps(n2);
                            pollArrayWrapper.putEventOps(n3, n5);
                            int n6 = ZosEventPort.this.poller.getReventOps(n2);
                            pollArrayWrapper.putReventOps(n3, n6);
                        }
                        ZosEventPort.this.fdCount = n3;
                        ZosEventPort.this.poller.free();
                        ZosEventPort.this.poller = pollArrayWrapper;
                        ((ZosEventPort)ZosEventPort.this).poller.totalChannels = ZosEventPort.this.fdCount + 1;
                        ZosEventPort.this.poller.initInterrupt(ZosEventPort.this.sp[0], ZosEventPort.this.sp[1]);
                        ZosEventPort.this.poller.putEventOps(0, 1);
                        ZosEventPort.this.fdRegistrationUpdated = false;
                    }
                    n4 = ZosEventPort.this.poller.poll(ZosEventPort.this.fdCount + 1, 0, 100L);
                    try {
                        int n7 = 0;
                        while (true) {
                            if (n7 > ZosEventPort.this.fdCount) continue block10;
                            n3 = ZosEventPort.this.poller.getDescriptor(n7);
                            n2 = Event.fromZosEvent(ZosEventPort.this.poller.getReventOps(n7));
                            n = Event.fromZosEvent(ZosEventPort.this.poller.getEventOps(n7));
                            if (n != 0 && n2 != 0 && (n & n2) > 0) {
                                --n4;
                                ZosEventPort.this.poller.putReventOps(n7, 0);
                                if (n7 == 0) {
                                    if (ZosEventPort.this.wakeupCount.decrementAndGet() == 0) {
                                        ZosEventPort.drain1(n3);
                                    }
                                    if (n4 <= 0) {
                                        Event event = ZosEventPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                        return event;
                                    }
                                    ZosEventPort.this.queue.offer(ZosEventPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                } else {
                                    Port.PollableChannel pollableChannel = (Port.PollableChannel)ZosEventPort.this.fdToChannel.get(n3);
                                    if (pollableChannel != null) {
                                        Event event = new Event(pollableChannel, n2);
                                        if (n4 <= 0) {
                                            Event event2 = event;
                                            return event2;
                                        }
                                        ZosEventPort.this.queue.offer(event);
                                    }
                                }
                            }
                            ++n7;
                        }
                    }
                    finally {
                        ZosEventPort.this.fdToChannelLock.readLock().unlock();
                        ZosEventPort.this.pollLock.unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                ZosEventPort.this.queue.offer(ZosEventPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;
        static final int POLLIN = 1;
        static final int POLLOUT = 4;
        static final int POLLERR = 32;
        static final int POLLHUP = 64;
        static final int POLLNULL = 0;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }

        static int toZosEvent(int n) {
            int n2 = 0;
            if ((n & 1) == 1) {
                n2 |= 1;
            }
            if ((n & 4) == 4) {
                n2 |= 4;
            }
            if ((n & 8) == 8) {
                n2 |= 0x20;
            }
            if ((n & 0x10) == 16) {
                n2 |= 0x40;
            }
            return n2;
        }

        static int fromZosEvent(int n) {
            int n2 = 0;
            if ((n & 1) == 1) {
                n2 |= 1;
            }
            if ((n & 4) == 4) {
                n2 |= 4;
            }
            if ((n & 0x20) == 32) {
                n2 |= 8;
            }
            if ((n & 0x40) == 64) {
                n2 |= 0x10;
            }
            return n2;
        }
    }
}

