/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import sun.nio.fs.Util;
import sun.security.action.GetPropertyAction;

class UnixMountEntry {
    private byte[] name;
    private byte[] dir;
    private byte[] fstype;
    private byte[] opts;
    private long dev;
    private volatile String fstypeAsString;
    private volatile String optionsAsString;
    private static String encoding;
    private static boolean conversionRequired;

    UnixMountEntry() {
    }

    String name() {
        String string = null;
        try {
            string = conversionRequired ? new String(this.name, encoding) : new String(this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    String fstype() {
        try {
            if (this.fstypeAsString == null) {
                this.fstypeAsString = conversionRequired ? new String(this.fstype, encoding) : new String(this.fstype);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return this.fstypeAsString;
    }

    byte[] dir() {
        return this.dir;
    }

    long dev() {
        return this.dev;
    }

    boolean hasOption(String string) {
        if (this.optionsAsString == null) {
            this.optionsAsString = this.opts == null ? new String() : new String(this.opts);
        }
        for (String string2 : Util.split(this.optionsAsString, ',')) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    boolean isIgnored() {
        return this.hasOption("ignore");
    }

    boolean isReadOnly() {
        return this.hasOption("ro");
    }

    static {
        conversionRequired = false;
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.equals("z/OS")) {
            String string2 = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            String string3 = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
            if (!string3.equals(string2)) {
                conversionRequired = true;
                encoding = string3;
            }
        }
    }
}

