/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs;

import com.ibm.net.rdma.jverbs.verbs.Device;
import com.ibm.net.rdma.jverbs.verbs.DeviceAttribute;
import com.ibm.net.rdma.jverbs.verbs.DeviceList;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;

public final class DeviceConstants {
    public static final int IBV_MAX_SEND_WR = DeviceConstants.getMaxWr();
    public static final int IBV_MAX_RECV_WR = DeviceConstants.getMaxWr();
    public static final int IBV_MAX_SEND_SGE = DeviceConstants.getMaxSge();
    public static final int IBV_MAX_RECV_SGE = DeviceConstants.getMaxSge();
    public static final int IBV_MAX_INITIATOR_DEPTH = DeviceConstants.getMaxResponderInitiatorValue();
    public static final int IBV_MAX_RESPONDER_RESOURCES = DeviceConstants.getMaxResponderInitiatorValue();
    private static DeviceAttribute deviceAttr = DeviceConstants.setDeviceAttribute();

    private static synchronized DeviceAttribute setDeviceAttribute() {
        if (deviceAttr != null) {
            return deviceAttr;
        }
        DeviceAttribute deviceAttribute = null;
        try {
            Device device = null;
            DeviceList deviceList = DeviceList.getDeviceList();
            if (deviceList != null && (device = deviceList.getDevice(0)) != null) {
                VerbsContext verbsContext = device.getContext();
                deviceAttribute = verbsContext.queryDevice();
            }
            deviceList.freeDeviceList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceAttribute;
    }

    private static int getMaxWr() {
        if (deviceAttr != null) {
            return deviceAttr.getMaxQueuePairWorkRequest();
        }
        return 200;
    }

    private static int getMaxSge() {
        if (deviceAttr != null) {
            return deviceAttr.getMaxSge();
        }
        return 4;
    }

    private static int getMaxResponderInitiatorValue() {
        if (deviceAttr != null) {
            return deviceAttr.getMaxQpRdAtom();
        }
        return 2;
    }
}

