/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.CompletionChannel;
import com.ibm.net.rdma.jverbs.verbs.CompletionQueue;
import com.ibm.net.rdma.jverbs.verbs.DeregisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.Device;
import com.ibm.net.rdma.jverbs.verbs.DeviceAttribute;
import com.ibm.net.rdma.jverbs.verbs.DeviceGlobalId;
import com.ibm.net.rdma.jverbs.verbs.DeviceList;
import com.ibm.net.rdma.jverbs.verbs.MemoryRegion;
import com.ibm.net.rdma.jverbs.verbs.NativeCompletionChannel;
import com.ibm.net.rdma.jverbs.verbs.NativeCompletionQueue;
import com.ibm.net.rdma.jverbs.verbs.NativeDeregisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.NativeDevice;
import com.ibm.net.rdma.jverbs.verbs.NativeDeviceList;
import com.ibm.net.rdma.jverbs.verbs.NativePollCQMethod;
import com.ibm.net.rdma.jverbs.verbs.NativePostReceiveMethod;
import com.ibm.net.rdma.jverbs.verbs.NativePostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.NativeProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.NativeRegisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.NativeRequestNotifyCQMethod;
import com.ibm.net.rdma.jverbs.verbs.NativeVerbsContext;
import com.ibm.net.rdma.jverbs.verbs.PollCQMethod;
import com.ibm.net.rdma.jverbs.verbs.PortAttribute;
import com.ibm.net.rdma.jverbs.verbs.PostReceiveMethod;
import com.ibm.net.rdma.jverbs.verbs.PostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.RdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.ReceiveWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.RegisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.RequestNotifyCQMethod;
import com.ibm.net.rdma.jverbs.verbs.SendWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import com.ibm.net.rdma.jverbs.verbs.WorkCompletion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class NativeRdmaJVerbs
extends RdmaJVerbs {
    private MemoryBufferPool memAlloc = MemoryBufferPool.getInstance();
    private ConcurrentHashMap<Integer, ByteBuffer> registeredBuffers = new ConcurrentHashMap();

    protected void removeRegisteredBuffer(int n) {
        this.registeredBuffers.remove(n);
    }

    protected void addRegisteredBuffer(int n, ByteBuffer byteBuffer) {
        this.registeredBuffers.put(n, byteBuffer);
    }

    @Override
    public void cleanup() {
        this.memAlloc.cleanupBuffers();
    }

    @Override
    public ProtectionDomain allocProtectionDomain(VerbsContext verbsContext) throws IOException {
        int n = -1;
        if (verbsContext == null || (n = verbsContext.getFD()) < 0) {
            throw new IOException("Context is not valid");
        }
        int n2 = this.allocPd0(n);
        if (n2 < 0) {
            throw new IOException("Allocate Protection Domain action failed");
        }
        return new NativeProtectionDomain(n2, verbsContext);
    }

    @Override
    public CompletionChannel createCompletionChannel(VerbsContext verbsContext) throws IOException {
        int n = -1;
        if (verbsContext == null || (n = verbsContext.getFD()) < 0) {
            throw new IOException("Context is not valid");
        }
        int n2 = this.createCompChannel0(n);
        if (n2 < 0) {
            throw new IOException("Create Completion channel action failed");
        }
        return new NativeCompletionChannel(n2, verbsContext);
    }

    @Override
    public CompletionQueue createCompletionQueue(VerbsContext verbsContext, CompletionChannel completionChannel, int n, int n2) throws IllegalArgumentException, IOException {
        int n3 = -1;
        if (verbsContext == null || (n3 = verbsContext.getFD()) < 0) {
            throw new IOException("Context is not valid");
        }
        int n4 = -1;
        if (completionChannel == null || (n4 = completionChannel.getFD()) < 0) {
            throw new IllegalArgumentException("Completion Channel is not valid");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Completion Queue size should be greater than zero");
        }
        int n5 = this.createCq0(n3, n4, n, n2);
        if (n5 < 0) {
            throw new IOException("Create Completion Queue action failed");
        }
        return new NativeCompletionQueue(verbsContext, completionChannel, n5, n);
    }

    @Override
    public RegisterMemoryRegionMethod registerMemoryRegion(ProtectionDomain protectionDomain, ByteBuffer byteBuffer, int n) throws IllegalArgumentException, IOException {
        NativeRegisterMemoryRegionMethod nativeRegisterMemoryRegionMethod = new NativeRegisterMemoryRegionMethod(this, this.memAlloc, protectionDomain, byteBuffer, n);
        return nativeRegisterMemoryRegionMethod;
    }

    @Override
    public DeregisterMemoryRegionMethod deregisterMemoryRegion(MemoryRegion memoryRegion) throws IllegalArgumentException, IOException {
        NativeDeregisterMemoryRegionMethod nativeDeregisterMemoryRegionMethod = new NativeDeregisterMemoryRegionMethod(this, memoryRegion);
        return nativeDeregisterMemoryRegionMethod;
    }

    @Override
    public PostSendMethod preparePostSend(QueuePair queuePair, List<SendWorkRequest> list) throws IllegalArgumentException, IOException {
        NativePostSendMethod nativePostSendMethod = new NativePostSendMethod(this, this.memAlloc, queuePair, list);
        return nativePostSendMethod;
    }

    @Override
    public PostReceiveMethod preparePostReceive(QueuePair queuePair, List<ReceiveWorkRequest> list) throws IllegalArgumentException, IOException {
        NativePostReceiveMethod nativePostReceiveMethod = new NativePostReceiveMethod(this, this.memAlloc, queuePair, list);
        return nativePostReceiveMethod;
    }

    @Override
    public boolean getCQEvent(CompletionChannel completionChannel, int n) throws IOException {
        int n2 = this.getCqEvent0(completionChannel.getFD(), n);
        return n2 >= 0;
    }

    @Override
    public PollCQMethod pollCQ(CompletionQueue completionQueue, WorkCompletion[] workCompletionArray, int n) throws IllegalArgumentException, IOException {
        NativePollCQMethod nativePollCQMethod = new NativePollCQMethod(this, this.memAlloc, completionQueue, workCompletionArray, n);
        return nativePollCQMethod;
    }

    @Override
    public RequestNotifyCQMethod requestNotifyCQ(CompletionQueue completionQueue, boolean bl) throws IllegalArgumentException, IOException {
        NativeRequestNotifyCQMethod nativeRequestNotifyCQMethod = new NativeRequestNotifyCQMethod(this, completionQueue, bl);
        return nativeRequestNotifyCQMethod;
    }

    @Override
    public void ackCQEvents(CompletionQueue completionQueue, int n) throws IllegalArgumentException, IOException {
        int n2 = -1;
        if (completionQueue == null || (n2 = completionQueue.getHandle()) < 0) {
            throw new IOException("Completion Queue is invalid");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Atleast one event should be acknowledged");
        }
        int n3 = this.ackCqEvent0(n2, n);
        if (n3 < 0) {
            throw new IOException("Acknowledge Completion Queue Events action failed");
        }
    }

    @Override
    public void destroyCompletionChannel(CompletionChannel completionChannel) throws IllegalArgumentException, IOException {
        int n = -1;
        if (completionChannel == null || (n = completionChannel.getFD()) < 0) {
            throw new IOException("Completion Channel is invalid");
        }
        int n2 = this.destroyCompChannel0(n);
        if (n2 < 0) {
            throw new IOException("Destroy Completion Channel  action failed");
        }
    }

    @Override
    public void deallocProtectionDomain(ProtectionDomain protectionDomain) throws IllegalArgumentException, IOException {
        int n = -1;
        if (protectionDomain == null || (n = protectionDomain.getHandle()) < 0) {
            throw new IOException("Invalid ProtectionDomain");
        }
        int n2 = this.deallocPd0(n);
        if (n2 < 0) {
            throw new IOException("Dealloc Protection Domain action failed");
        }
    }

    @Override
    public void destroyCompletionQueue(CompletionQueue completionQueue) throws IllegalArgumentException, IOException {
        int n = -1;
        if (completionQueue == null || (n = completionQueue.getHandle()) < 0) {
            throw new IOException("Completion Queue is invalid");
        }
        int n2 = this.destroyCq0(n);
        if (n2 < 0) {
            throw new IOException("Destroy Completion Queue action failed");
        }
    }

    @Override
    public DeviceList getDeviceList() throws IOException {
        NativeDeviceList nativeDeviceList = null;
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(NativeSizeConstants.INT_SIZE, MemoryBufferPool.MemType.DIRECT);
        long l = this.getDeviceList0(memoryBuffer.getAddress());
        if (l < 0L) {
            memoryBuffer.cache();
            throw new IOException("Get Device List failed");
        }
        int n = memoryBuffer.getInt();
        nativeDeviceList = new NativeDeviceList(n, l);
        for (int i = 0; i < n; ++i) {
            NativeDevice nativeDevice = new NativeDevice(i, l);
            nativeDevice.getDeviceInfo();
            nativeDeviceList.addDevice(nativeDevice);
        }
        memoryBuffer.cache();
        return nativeDeviceList;
    }

    @Override
    public void freeDeviceList(DeviceList deviceList) throws IOException {
        long l = -1L;
        if (deviceList == null || (l = ((NativeDeviceList)deviceList).getNativeId()) == -1L) {
            throw new IOException("Device List is invalid");
        }
        int n = this.freeDeviceList0(l);
        if (n < 0) {
            throw new IOException("Free device list failed");
        }
    }

    @Override
    public String getDeviceName(Device device) throws IOException {
        if (device == null || ((NativeDevice)device).getNativeId() < 0L) {
            throw new IOException("Device is invalid");
        }
        return ((NativeDevice)device).getDevName();
    }

    @Override
    public long getDeviceGuid(Device device) throws IOException {
        if (device == null || ((NativeDevice)device).getNativeId() < 0L) {
            throw new IOException("Device is invalid");
        }
        return ((NativeDevice)device).getDeviceGuid();
    }

    @Override
    public DeviceAttribute queryDevice(VerbsContext verbsContext) throws IOException {
        if (verbsContext == null || verbsContext.getFD() < 0) {
            throw new IOException("Context is invalid");
        }
        return ((NativeVerbsContext)verbsContext).queryDevice();
    }

    @Override
    public PortAttribute queryPort(VerbsContext verbsContext, int n) throws IllegalArgumentException, IOException {
        if (verbsContext == null || verbsContext.getFD() < 0) {
            throw new IOException("Context is invalid");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Port number cannot be less than 1");
        }
        return ((NativeVerbsContext)verbsContext).queryPort(n);
    }

    @Override
    public DeviceGlobalId queryGid(VerbsContext verbsContext, int n, int n2) throws IllegalArgumentException, IOException {
        if (verbsContext == null || verbsContext.getFD() < 0) {
            throw new IOException("Context is not valid");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Port number cannot be less than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Gid table index cannot be less than 0");
        }
        return ((NativeVerbsContext)verbsContext).queryGid(n, n2);
    }

    native int allocPd0(int var1);

    native int createCompChannel0(int var1);

    native int createCq0(int var1, int var2, int var3, int var4);

    native int modifyQp0(int var1, long var2);

    native int regMr0(int var1, long var2, int var4, int var5, long var6, long var8, long var10);

    native int deregMr0(int var1);

    native int postSend0(int var1, long var2);

    native int postRecv0(int var1, long var2);

    native int getCqEvent0(int var1, int var2);

    native int pollCq0(int var1, int var2, long var3);

    native int reqNotifyCq0(int var1, int var2);

    native int ackCqEvent0(int var1, int var2);

    native int destroyCompChannel0(int var1);

    native int deallocPd0(int var1);

    native int destroyCq0(int var1);

    native long getDeviceList0(long var1);

    native int freeDeviceList0(long var1);

    native String getDeviceName0(long var1, int var3);

    native long getDeviceGuid0(long var1, int var3);
}

