/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.MemoryRegion;
import com.ibm.net.rdma.jverbs.verbs.NativeMemoryRegion;
import com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.RegisterMemoryRegionMethod;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

class NativeRegisterMemoryRegionMethod
extends RegisterMemoryRegionMethod {
    private NativeRdmaJVerbs verbsImpl;
    private MemoryBufferPool memAlloc;
    private int pdHandle;
    private int bufferCapacity;
    private MemoryBuffer cmd;
    private long userAddress;
    private int access;
    private MemoryRegion mr;
    private boolean valid = false;
    private boolean success = false;
    private ByteBuffer buffer;

    public NativeRegisterMemoryRegionMethod(NativeRdmaJVerbs nativeRdmaJVerbs, MemoryBufferPool memoryBufferPool, ProtectionDomain protectionDomain, ByteBuffer byteBuffer, int n) {
        this.buffer = byteBuffer;
        this.verbsImpl = nativeRdmaJVerbs;
        this.memAlloc = memoryBufferPool;
        this.cmd = null;
        this.pdHandle = protectionDomain.getHandle();
        this.bufferCapacity = byteBuffer.capacity();
        this.userAddress = ((DirectBuffer)((Object)byteBuffer)).address();
        this.access = n;
        this.cmd = memoryBufferPool.allocate(3 * NativeSizeConstants.INT_SIZE, MemoryBufferPool.MemType.DIRECT);
        this.valid = true;
    }

    @Override
    public RegisterMemoryRegionMethod execute() {
        this.success = false;
        if (!this.valid) {
            return this;
        }
        this.cmd.clear();
        int n = this.verbsImpl.regMr0(this.pdHandle, this.userAddress, this.bufferCapacity, this.access, this.cmd.getAddress(), this.cmd.getAddress() + (long)NativeSizeConstants.INT_SIZE, this.cmd.getAddress() + (long)(2 * NativeSizeConstants.INT_SIZE));
        if (n >= 0) {
            int n2 = this.cmd.getInt();
            int n3 = this.cmd.getInt();
            int n4 = this.cmd.getInt();
            this.mr = new NativeMemoryRegion(this.buffer, this.userAddress, this.bufferCapacity, this.access, n2, n3, n4);
            this.verbsImpl.addRegisteredBuffer(n4, this.buffer);
            this.success = true;
        } else {
            this.mr = null;
            this.buffer = null;
        }
        return this;
    }

    @Override
    public MemoryRegion getMemoryRegion() {
        return this.mr;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public RegisterMemoryRegionMethod free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

